/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.detail;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.apps.inet.accounting.detail.InetFlowSelector;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogUtils;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowSelector;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class FlowExport {
    public static void main(String[] args) throws IOException, BGException {
        Setup setup = Setup.getSetup();
        new FlowExport().export((ParameterMap)setup, args);
    }

    public void export(ParameterMap setup, String command) throws IOException, BGException {
        ArrayList<String> args = new ArrayList<String>();
        Matcher m = Pattern.compile("(?:\\A|[\\s]*)(?:(?:\"(.+?)\")|(?:(.+?)))(?:[\\s]|\\z)").matcher(command);
        while (m.find()) {
            String k = m.group(1);
            if (k == null) {
                k = m.group(2);
            }
            args.add(k);
        }
        this.export(setup, args.toArray(new String[args.size()]));
    }

    protected void export(ParameterMap setup, String[] args) throws IOException, BGException {
        int agentDeviceId = 0;
        Date timeFrom = null;
        Date timeTo = null;
        Set ifaces = null;
        byte[] addressFrom = null;
        byte[] addressTo = null;
        File file = null;
        String timestampFormat = null;
        String timeZoneName = null;
        int maxSort = 30000;
        String directory = null;
        boolean writeIfaces = true;
        int size = args.length - 1;
        for (int i = 0; i < size; ++i) {
            String k = args[i];
            String v = args[i + 1].trim();
            System.out.printf("\u0440\u0430\u0437\u0431\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430: %s -> %s\n", k, v);
            if ("-s".equals(k)) {
                agentDeviceId = Utils.parseInt((String)v);
                ++i;
                continue;
            }
            if ("-h".equals(k)) {
                timeFrom = TimeUtils.parseDate((String)v, (String)"yyyy-MM-dd-HH");
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(timeFrom);
                ((Calendar)calendar).add(11, 1);
                ((Calendar)calendar).add(14, -1);
                timeTo = calendar.getTime();
                System.out.printf("timeFrom=%s, timeTo=%s\n", timeFrom, timeTo);
                ++i;
                continue;
            }
            if ("-tFrom".equals(k)) {
                timeFrom = TimeUtils.parseDate((String)v, (String)"yyyy-MM-dd'T'HH:mm:ss");
                System.out.printf("timeFrom=%s\n", timeFrom);
                ++i;
                continue;
            }
            if ("-tTo".equals(k)) {
                timeTo = TimeUtils.parseDate((String)v, (String)"yyyy-MM-dd'T'HH:mm:ss");
                System.out.printf("timeTo=%s\n", timeTo);
                ++i;
                continue;
            }
            if ("-i".equals(k)) {
                ifaces = Utils.toIntegerSet((String)v);
                ++i;
                continue;
            }
            if ("-r".equals(k)) {
                String[] vv = v.split("-");
                if (vv.length == 1) {
                    addressFrom = addressTo = InetAddress.getByName(v).getAddress();
                } else if (vv.length == 2) {
                    addressFrom = InetAddress.getByName(vv[0]).getAddress();
                    addressTo = InetAddress.getByName(vv[1]).getAddress();
                }
                System.out.printf("addressFrom=%s, addressTo=%s\n", addressFrom, addressTo);
                ++i;
                continue;
            }
            if ("-f".equals(k)) {
                file = new File(v);
                System.out.printf("file=%s\n", file.getAbsolutePath());
                ++i;
                continue;
            }
            if ("-tFmt".equals(k)) {
                timestampFormat = v;
                ++i;
                continue;
            }
            if ("-tZone".equals(k)) {
                timeZoneName = v;
                ++i;
                continue;
            }
            if ("-dir".equals(k)) {
                directory = v;
                ++i;
                continue;
            }
            if ("-maxSort".equals(k)) {
                maxSort = Utils.parseInt((String)v);
                ++i;
                continue;
            }
            if (!"-writeIfaces".equals(k)) continue;
            writeIfaces = Utils.parseBoolean((String)v);
            ++i;
        }
        if (setup == null && Utils.isBlankString(directory)) {
            throw new BGException("Parameter -dir must not be empty. For example, -dir data/flow");
        }
        if (file == null) {
            throw new BGException("Parameter -f must not be empty.");
        }
        if (agentDeviceId <= 0) {
            System.out.printf("\tagentDeviceId: %d\n", agentDeviceId);
            throw new BGException("Parameter -s must not be empty.");
        }
        if (timeFrom == null || timeTo == null) {
            System.out.printf("\ttimeFrom: %s\n", timeFrom);
            System.out.printf("\ttimeTo: %s\n", timeTo);
            throw new BGException("Parameter -h (or -tFrom and -tTo) must not be empty.");
        }
        int timeZoneDelta = 0;
        if (!Utils.isEmptyString(timeZoneName)) {
            TimeZone processTimeZone = TimeZone.getTimeZone(timeZoneName);
            TimeZone currentTimeZone = TimeZone.getDefault();
            timeZoneDelta = processTimeZone.getRawOffset() - currentTimeZone.getRawOffset();
        }
        this.export(setup, directory, agentDeviceId, timeFrom, timeTo, ifaces, addressFrom, addressTo, maxSort, writeIfaces, file, timestampFormat, timeZoneDelta);
    }

    public void export(ParameterMap setup, String directory, int agentDeviceId, Date timeFrom, Date timeTo, Set<Integer> ifaces, byte[] addressFrom, byte[] addressTo, int maxSort, boolean writeIfaces, File file, String timestampFormat, int timeZoneDelta) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter, 65536);
        this.export(setup, directory, agentDeviceId, timeFrom, timeTo, ifaces, addressFrom, addressTo, maxSort, writeIfaces, bufferedWriter, timestampFormat, timeZoneDelta);
        bufferedWriter.flush();
        fileWriter.flush();
        fileWriter.close();
    }

    public void export(ParameterMap setup, String directory, int agentDeviceId, Date timeFrom, Date timeTo, Set<Integer> ifaces, byte[] addressFrom, byte[] addressTo, int maxSort, boolean writeIfaces, Writer writer, String timestampFormat, int timeZoneDelta) throws IOException {
        SortedSet<Calendar> hours = FlowExport.getLogHours(timeFrom, timeTo);
        InetFlowSelector flowSelector = new InetFlowSelector(timeFrom.getTime(), timeTo.getTime() / 1000L * 1000L + 999L, ifaces, addressFrom, addressTo, null, 0, null, timeZoneDelta);
        this.export(setup, "datalog.flow.dir", directory, agentDeviceId, new ArrayList<Calendar>(hours), flowSelector, maxSort, writeIfaces, writer, timestampFormat, timeZoneDelta);
    }

    protected static SortedSet<Calendar> getLogHours(Date timeFrom, Date timeTo) {
        TreeSet<Calendar> result = new TreeSet<Calendar>();
        Calendar hour = new GregorianCalendar();
        hour.setTime(timeFrom);
        TimeUtils.clear_MIN_MIL_SEC((Calendar)hour);
        GregorianCalendar end = new GregorianCalendar();
        end.setTime(timeTo);
        while (TimeUtils.hourDelta((Calendar)hour, (Calendar)end) >= 0) {
            result.add(hour);
            hour = (Calendar)hour.clone();
            hour.add(11, 1);
        }
        return result;
    }

    public void export(ParameterMap setup, String directoryKey, String directoryValue, int agentDeviceId, List<Calendar> hours, FlowSelector flowSelector, int maxSort, boolean writeIfaces, Writer writer, String timestampFormat, int timeZoneDelta) throws IOException {
        if (Utils.notBlankString((String)directoryValue)) {
            Preferences prefs = new Preferences();
            prefs.set(directoryKey, directoryValue);
            setup = prefs;
        }
        Iterable logs = IPDataLogUtils.newIPHourlyDataLogIterable((ParameterMap)setup, (String)directoryKey, (int)agentDeviceId, hours);
        Iterable flowDetailIterable = IPDataLogUtils.newFlowDetailIterable((Iterable)logs, (FlowSelector)flowSelector, (int)maxSort);
        this.writeHeader(writer, writeIfaces);
        Date utilDate = new Date();
        SimpleDateFormat dateFormat = Utils.notBlankString((String)timestampFormat) ? new SimpleDateFormat(timestampFormat) : null;
        for (FlowArray f : flowDetailIterable) {
            int size = f.size;
            for (int i = 0; i < size; ++i) {
                IPDataLogUtils.FlowDetail flow = ((IPDataLogUtils.FlowDetail[])f.array)[i];
                this.writeRecord(writer, flow, dateFormat, utilDate, timeZoneDelta, writeIfaces);
            }
        }
        writer.flush();
    }

    protected void writeHeader(Writer writer, boolean writeIfaces) throws IOException {
        writer.write("Timestamp\tFromIp\tFromPort\tToIp\tToPort\tBytes");
        if (writeIfaces) {
            writer.write("\tFromIface\tToIface");
        }
        writer.write("\tProtocol\n");
    }

    protected void writeRecord(Writer writer, IPDataLogUtils.FlowDetail flow, DateFormat dateFormat, Date utilDate, int timeZoneDelta, boolean writeIfaces) throws IOException {
        if (dateFormat != null) {
            utilDate.setTime(flow.getMilliseconds() + (long)timeZoneDelta);
            writer.write(dateFormat.format(utilDate));
        } else {
            writer.write(String.valueOf(flow.getMilliseconds()));
        }
        writer.write(9);
        writer.write(String.valueOf(flow.getSrcIpAddress()));
        writer.write(9);
        writer.write(String.valueOf(flow.getSrcPort()));
        writer.write(9);
        writer.write(String.valueOf(flow.getDstIpAddress()));
        writer.write(9);
        writer.write(String.valueOf(flow.getDstPort()));
        writer.write(9);
        writer.write(String.valueOf(flow.getOctets()));
        if (writeIfaces) {
            writer.write(9);
            writer.write(String.valueOf(flow.getInputInterface()));
            writer.write(9);
            writer.write(String.valueOf(flow.getOutputInterface()));
        }
        writer.write(9);
        writer.write(String.valueOf(flow.getProtocol()));
        writer.write(10);
    }
}

