/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class DeletedConnectionsRemover
implements Runnable {
    private static final Logger logger = LogManager.getLogger();
    private final Access access;

    public DeletedConnectionsRemover(Access access) {
        this.access = access;
    }

    @Override
    public void run() {
        Connection con = this.access.setup.getDBConnectionFromPool();
        try {
            this.runImpl(con);
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public void runImpl(Connection con) throws BGException {
        logger.debug("Run DeletedConnectionsRemover...");
        try {
            PreparedStatement ps = con.prepareStatement("SELECT id FROM inet_connection_" + this.access.moduleId + " WHERE status>0");
            HashSet<Long> ids = new HashSet<Long>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ids.add(rs.getLong(1));
            }
            rs.close();
            if (!con.getAutoCommit()) {
                con.commit();
            }
            ArrayList<InetConnection> list = new ArrayList<InetConnection>();
            for (Map.Entry<Integer, ConcurrentMap<Long, InetConnectionRuntime>> e : this.access.connectionManager.deviceConnectionEntrySet()) {
                for (InetConnectionRuntime connectionRuntime : e.getValue().values()) {
                    if (connectionRuntime.connection == null || ids.contains(connectionRuntime.connection.getId()) || connectionRuntime.connection.getConnectionStart().getTime() > System.currentTimeMillis() - 120000L) continue;
                    list.add(connectionRuntime.connection);
                }
            }
            ids.clear();
            rs = ps.executeQuery();
            while (rs.next()) {
                ids.add(rs.getLong(1));
            }
            rs.close();
            ps.close();
            if (!con.getAutoCommit()) {
                con.commit();
            }
            int count = 0;
            for (InetConnection connection : list) {
                if (ids.contains(connection.getId())) continue;
                logger.warn("Found connection in connectionManager what not exist in DB: " + connection);
                this.access.connectionManager.remove(connection);
                ++count;
            }
            logger.debug("Removed " + count + " deleted connections");
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

