/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bots.message;

import com.vk.api.sdk.objects.messages.Keyboard;
import com.vk.api.sdk.objects.messages.KeyboardButton;
import com.vk.api.sdk.objects.messages.KeyboardButtonAction;
import com.vk.api.sdk.objects.messages.Message;
import com.vk.api.sdk.objects.messages.TemplateActionTypeNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.message.MessageBuilder;
import ru.bitel.common.Utils;

public class VKMessageBuilder
extends MessageBuilder {
    private static final Logger logger = LogManager.getLogger();

    public VKMessageBuilder(RuntimeBot currentBot) throws BGException {
        super(currentBot);
    }

    @Override
    public Message buildMessage(Integer chatId, BotDialog dialog) throws BGException {
        if (dialog == null) {
            logger.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043e\u0442\u0432\u0435\u0442\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0447\u0430\u0442\u0430: " + chatId + " \u041f\u0440\u0438\u0447\u0438\u043d\u0430: BotDialog == null");
            return this.buildErrorMessage(chatId);
        }
        ArrayList<BotDialogElement> buttons = new ArrayList<BotDialogElement>();
        ArrayList<BotDialogElement> attachments = new ArrayList<BotDialogElement>();
        Message message = new Message();
        for (BotDialogElement element : dialog.getDialogElements()) {
            switch (element.getElementType()) {
                case TEXT: {
                    this.setTextInMessage(message, element);
                    break;
                }
                case LINK: {
                    this.setLinkInMessage(message, element);
                    break;
                }
                case BUTTON: {
                    buttons.add(element);
                    break;
                }
                case ATTACHMENT: {
                    attachments.add(element);
                }
            }
        }
        this.setKeyboard(message, buttons);
        this.setAttachments(message, attachments);
        message.setRandomId(Integer.valueOf(new Random().nextInt(10000)));
        return message;
    }

    private void setTextInMessage(Message message, BotDialogElement element) {
        Object text = message.getText();
        text = Utils.notBlankString((String)text) ? (String)text + "\n" : "";
        text = (String)text + element.getJSONConfig().optString("text");
        message.setText((String)text);
    }

    private void setAttachments(Message message, List<BotDialogElement> attachments) {
        Object text = message.getText();
        StringBuilder sb = new StringBuilder("{$attachments:");
        for (int i = 0; i < attachments.size(); ++i) {
            sb.append(attachments.get(i).getId());
            if (i == attachments.size() - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        text = (String)text + sb.toString();
        message.setText((String)text);
    }

    private void setLinkInMessage(Message message, BotDialogElement element) {
        String text = element.getJSONConfig().optString("linkTitle", "");
        String link = element.getJSONConfig().optString("text", "");
        if (Utils.isBlankString((String)link)) {
            return;
        }
        if (Utils.isBlankString((String)text)) {
            text = link;
        }
        message.setText("<a href='" + link + "'>" + text + "</a>");
    }

    private void setKeyboard(Message message, List<BotDialogElement> buttonElements) {
        if (Utils.isEmptyCollection(buttonElements)) {
            message.setKeyboard(null);
            return;
        }
        boolean isInline = buttonElements.stream().anyMatch(el -> el.getJSONConfig().optBoolean("isInline"));
        for (BotDialogElement element : buttonElements) {
            if (element.getJSONConfig().optBoolean("isInline")) continue;
            isInline = false;
        }
        int buttonInLineSize = this.runtimeBot.getBotConfig().getInt("keyboard.buttoninline.count", 2);
        Keyboard keyboard = new Keyboard();
        keyboard.setInline(Boolean.valueOf(isInline));
        if (!isInline) {
            keyboard.setOneTime(Boolean.valueOf(true));
        }
        ArrayList buttons = new ArrayList();
        ArrayList<KeyboardButton> line = new ArrayList<KeyboardButton>();
        int buttonInRowCount = 0;
        for (int x = 0; x < buttonElements.size(); ++x) {
            String textOnButton = buttonElements.get(x).getJSONConfig().optString("text", "");
            KeyboardButton keyboardButton = new KeyboardButton();
            keyboardButton.setAction(new KeyboardButtonAction().setLabel(textOnButton).setType(TemplateActionTypeNames.TEXT));
            line.add(keyboardButton);
            if (++buttonInRowCount == buttonInLineSize) {
                buttons.add(line);
                line = new ArrayList();
                buttonInRowCount = 0;
                continue;
            }
            if (x != buttonElements.size() - 1) continue;
            buttons.add(line);
        }
        keyboard.setButtons(buttons);
        message.setKeyboard(keyboard);
    }

    @Override
    protected Message buildMessage(Integer chatId, String messageText) {
        return new Message().setText(messageText).setRandomId(Integer.valueOf(new Random().nextInt(10000)));
    }

    @Override
    protected Message buildErrorMessage(Integer chatId) throws BGException {
        return this.buildErrorMessage(chatId, "");
    }

    @Override
    protected Message buildErrorMessage(Integer chatId, String text) throws BGException {
        return this.buildErrorMessage(chatId, text, false);
    }

    @Override
    protected Message buildErrorMessage(Integer chatId, String text, boolean useCustomErrorDialog) throws BGException {
        if (useCustomErrorDialog && this.errorDialog != null) {
            return this.buildMessage(chatId, this.errorDialog);
        }
        return new Message().setText("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430").setRandomId(Integer.valueOf(new Random().nextInt(10000)));
    }
}

