/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.contract;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.modules.bill.client.bean.BillUtils;
import ru.bitel.bgbilling.modules.bill.common.bean.Attribute;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class BillAttrEditor
extends BGPanel {
    private JPanel editorPanel = new JPanel(new GridBagLayout());
    private BillAttrTableModel model = new BillAttrTableModel(BillAttrTableModel.class.getName());
    private BGUTable table = new BGUTable((TableModel)((Object)this.model));
    private JTextField attrValue = new JTextField(20);
    private BGUList<AttributeType> attrName = new BGUList();
    private BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
    private BGControlPanelPeriod period = new BGControlPanelPeriod();
    private BGUComboBox<IdTitle> typeAttributeComboBox = new BGUComboBox();
    private BGUComboBox<EntitySpecAttrType> contractTypeParamComboBox = new BGUComboBox(false);
    private BGUList<ContractParameterGroupAttr> contractParamList = new BGUList();
    JPanel contractParamPanel = new JPanel(new GridBagLayout());
    private BGUComboBox<IdTitle> organizationComboBox = new BGUComboBox();
    private BGUComboBox<IdTitle> bankAccountComboBox = new BGUComboBox();
    private JCheckBox useSuperContract = new JCheckBox("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441\u0443\u043f\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0435\u0441\u043b\u0438 \u0441\u0432\u043e\u0439 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
    private Map<String, AttributeType> attributeTypeMap = new HashMap<String, AttributeType>();
    private Map<Integer, ContractParameterGroupAttr> contractPrefMap = new HashMap<Integer, ContractParameterGroupAttr>();
    private Map<Integer, List<ContractParameterGroupAttr>> contractPrefListMap = new HashMap<Integer, List<ContractParameterGroupAttr>>();
    private Contract contract = null;
    private Attribute currentAttribute = null;
    private BillService billService = null;
    private ContractService contractService = null;
    private CardLayout valueCardLayout = new CardLayout();
    private JPanel valuePanel = new JPanel(this.valueCardLayout);

    public BillAttrEditor() {
        this.jbInit();
        this.editorPanel.setVisible(false);
    }

    private void jbInit() {
        this.attrName.getSelectionModel().setSelectionMode(0);
        Dimension dimension = new Dimension(300, 150);
        JScrollPane scrollPane = new JScrollPane((Component)this.attrName);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430 "));
        panel.add((Component)new JLabel("\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.getTypePanel(), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.period, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.getValuePanel(), new GridBagConstraints(1, 0, 1, 4, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 4), 0, 0));
        this.editorPanel.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.okCancelPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.getBankAccountPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editorPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.okCancelPanel.addActionListener(e -> {
            if (e.getActionCommand().equals("ok")) {
                this.save();
            } else {
                this.editorPanel.setVisible(false);
            }
        });
        this.table.setSelectionMode(0);
        this.table.setModel((TableModel)((Object)this.model));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BillAttrEditor.this.editItem();
                }
            }
        });
        this.editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                BillAttrEditor.this.setData();
            }
        });
        this.typeAttributeComboBox.addActionListener(e -> {
            boolean constantType = ((IdTitle)this.typeAttributeComboBox.getSelectedItem()).getId() == 1;
            this.valueCardLayout.show(this.valuePanel, constantType ? "value" : "param");
            if (!constantType && this.contractParamList.getModel().getSize() == 0) {
                this.contractTypeParamComboBox.setSelectedIndex(0);
                this.setContractParamList();
            }
        });
        this.contractTypeParamComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setContractParamList();
            }
        });
    }

    public ClientContext getContext() {
        return super.getContext();
    }

    private void setContractParamList() {
        try {
            EntitySpecAttrType selectType = null;
            if (((IdTitle)this.typeAttributeComboBox.getSelectedItem()).getId() == 2 && (selectType = (EntitySpecAttrType)this.contractTypeParamComboBox.getSelectedItem()) != null) {
                List<ContractParameterGroupAttr> list = this.contractPrefListMap.get(selectType.getCode());
                if (list == null) {
                    list = this.getContractParameterPrefList(selectType.getCode());
                }
                this.contractParamList.setData(list);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private JPanel getTypePanel() {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f"), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.typeAttributeComboBox, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getValuePanel() {
        Dimension dimension = new Dimension(500, 180);
        this.contractParamPanel.setMinimumSize(dimension);
        this.contractParamPanel.setPreferredSize(dimension);
        this.contractParamPanel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.contractParamPanel.add((Component)new JScrollPane((Component)this.contractParamList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.contractParamPanel.add((Component)this.useSuperContract, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.attrValue, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.valuePanel.add((Component)panel, "value");
        panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.contractTypeParamComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.contractParamPanel, new GridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        this.valuePanel.add((Component)panel, "param");
        return this.valuePanel;
    }

    private JPanel getBankAccountPanel() {
        this.organizationComboBox.addItemListener(e -> {
            int selectedOrganizationId = ((IdTitle)e.getItem()).getId();
            try {
                if (e.getStateChange() == 1) {
                    this.getBillService().setOrganization(this.getContractId(), selectedOrganizationId);
                    BillUtils.setBankAccountComboBoxData(this.bankAccountComboBox, this.getBillService(), this.getContractId(), selectedOrganizationId);
                }
            }
            catch (BGException e1) {
                e1.printStackTrace();
            }
        });
        this.bankAccountComboBox.addItemListener(e -> {
            int selectedBabkAccountId = ((IdTitle)e.getItem()).getId();
            try {
                if (e.getStateChange() == 1) {
                    this.getBillService().setBankAccount(this.getContractId(), selectedBabkAccountId);
                }
            }
            catch (BGException e1) {
                e1.printStackTrace();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f, \u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442 "));
        panel.add((Component)this.organizationComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.bankAccountComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setData() {
        try {
            this.contract = this.getContractService().contractGet(this.getContractId());
            this.useSuperContract.setVisible(this.contract.isSub());
            Async.ofWithTry(() -> {
                BillService billService = (BillService)this.getContext().getWebService(BillService.class);
                List attrTypeList = billService.attributeTypeList();
                this.attrName.setData(attrTypeList);
                for (AttributeType type : attrTypeList) {
                    this.attributeTypeMap.put(type.getName(), type);
                }
                this.model.setData(billService.attributeList(this.getContractId()));
            });
            if (this.typeAttributeComboBox.getModel().getSize() == 0) {
                ArrayList<IdTitle> list = new ArrayList<IdTitle>();
                list.add(new IdTitle(1, "\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430"));
                list.add(new IdTitle(2, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
                this.typeAttributeComboBox.setData(list);
                ArrayList<EntitySpecAttrType> listParam = new ArrayList<EntitySpecAttrType>();
                listParam.add(EntitySpecAttrType.TEXT);
                listParam.add(EntitySpecAttrType.ADDRESS);
                listParam.add(EntitySpecAttrType.EMAIL);
                listParam.add(EntitySpecAttrType.BOOLEAN);
                listParam.add(EntitySpecAttrType.LIST);
                listParam.add(EntitySpecAttrType.MULTILIST);
                listParam.add(EntitySpecAttrType.PHONE);
                this.contractTypeParamComboBox.setData(listParam);
            }
            IdTitle idTitle = BillUtils.setOrganizationComboBoxData(this.organizationComboBox, this.getBillService(), this.getContractId());
            BillUtils.setBankAccountComboBoxData(this.bankAccountComboBox, this.getBillService(), this.getContractId(), idTitle.getId());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void deleteItem() {
        try {
            Attribute attribute = (Attribute)this.model.getSelectedRow();
            if (attribute != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                ((BillService)this.getContext().getWebService(BillService.class)).attributeDelete(this.getContractId(), attribute.getId());
                if (this.editorPanel.isVisible()) {
                    this.editorPanel.setVisible(false);
                } else {
                    this.setData();
                }
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void editItem() {
        this.currentAttribute = (Attribute)this.model.getSelectedRow();
        if (this.currentAttribute != null) {
            this.startEdit();
        }
    }

    public void newItem() {
        this.currentAttribute = null;
        this.startEdit();
    }

    private ContractParameterGroupAttr getContractParamPref(int idPref) throws BGException {
        ContractParameterGroupAttr pref = this.contractPrefMap.get(idPref);
        if (pref == null && (pref = ((ContractParameterService)this.getContext().getPort(ContractParameterService.class, 0)).contractParameterGroupAttrGet(idPref)) != null) {
            this.getContractParameterPrefList(pref.getType());
            pref = this.contractPrefMap.get(idPref);
        }
        return pref;
    }

    private List<ContractParameterGroupAttr> getContractParameterPrefList(int prefId) throws BGException {
        List list = this.contractPrefListMap.get(prefId);
        if (list == null) {
            ClientContext clientContext = new ClientContext("kernel", 0, this.getContext().getContractId(), null);
            list = ((ContractParameterService)clientContext.getPort(ContractParameterService.class, 0)).contractParameterGroupAttrList();
            list = list.stream().filter(e -> e.getType() == prefId).collect(Collectors.toList());
            for (ContractParameterGroupAttr pref : list) {
                this.contractPrefMap.put(pref.getId(), pref);
            }
            this.contractPrefListMap.put(prefId, list);
        }
        return list;
    }

    private void save() {
        try {
            boolean isParam = ((IdTitle)this.typeAttributeComboBox.getSelectedItem()).getId() == 2;
            String value = this.attrValue.getText();
            AttributeType type = (AttributeType)this.attrName.getSelectedValue();
            if (type == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u0438\u043f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430!");
                return;
            }
            Attribute attr = new Attribute(this.currentAttribute != null ? this.currentAttribute.getId() : 0, this.getContractId(), type.getName(), value, this.period.getPeriod());
            if (!isParam && Utils.isEmptyString((String)value.trim())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                return;
            }
            if (isParam) {
                ContractParameterGroupAttr parameterPref = (ContractParameterGroupAttr)this.contractParamList.getSelectedValue();
                if (parameterPref == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!");
                    return;
                }
                attr.setContractParamPrefId(parameterPref.getId());
                attr.setUseSuperContract(this.contract.isSub() && this.useSuperContract.isSelected());
            }
            ((BillService)this.getContext().getWebService(BillService.class)).attributeUpdate(this.getContractId(), attr);
            this.editorPanel.setVisible(false);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void startEdit() {
        this.editorPanel.setVisible(true);
        try {
            int selectType = 0;
            boolean useSuper = false;
            if (this.currentAttribute != null) {
                ContractParameterGroupAttr pref;
                this.attrName.setSelectedValue((Object)this.attributeTypeMap.get(this.currentAttribute.getName()), true);
                int contractParamPrefId = this.currentAttribute.getContractParamPrefId();
                selectType = contractParamPrefId > 0 ? 1 : 0;
                this.typeAttributeComboBox.setSelectedIndex(selectType);
                if (contractParamPrefId > 0 && (pref = this.getContractParamPref(contractParamPrefId)) != null) {
                    this.contractTypeParamComboBox.setSelectedItem((Object)pref.getType());
                    this.setContractParamList();
                    this.contractParamList.setSelectedValue((Object)pref, true);
                    useSuper = this.currentAttribute.isUseSuperContract();
                    this.contractTypeParamComboBox.invalidate();
                    this.contractTypeParamComboBox.repaint();
                    this.contractParamList.invalidate();
                    this.contractParamList.repaint();
                }
            }
            this.useSuperContract.setSelected(useSuper);
            this.attrValue.setText(this.currentAttribute != null ? this.currentAttribute.getValue() : "");
            this.period.setPeriod(this.currentAttribute != null ? this.currentAttribute.getPeriod() : null);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private BillService getBillService() {
        if (this.billService == null) {
            this.billService = (BillService)this.getContext().getPort(BillService.class, this.getModuleId());
        }
        return this.billService;
    }

    private ContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = (ContractService)this.getContext().getPort(ContractService.class, 0);
        }
        return this.contractService;
    }

    class BillAttrTableModel
    extends BGTableModel<Attribute> {
        public BillAttrTableModel(String name) {
            super(name, Attribute.class);
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", 40, 50, 100, "id", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442", 40, 130, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 40, 130, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", Period.class, 40, 130, -1, "period", true);
        }

        public Object getValue(Attribute val, int column) throws BGException {
            ContractParameterGroupAttr pref;
            int contractParamPrefId;
            if (column == 1) {
                AttributeType type = BillAttrEditor.this.attributeTypeMap.get(val.getName());
                return type != null ? type.getTitle() : "- \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e -";
            }
            if (column == 2 && (contractParamPrefId = val.getContractParamPrefId()) > 0 && (pref = BillAttrEditor.this.getContractParamPref(contractParamPrefId)) != null) {
                return "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + pref.getTypeName() + ": " + pref.getTitle();
            }
            return super.getValue((Object)val, column);
        }
    }
}

