/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.task;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.softline.common.SoftLineUtils;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineProduct;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionSuspendReason;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService;
import ru.bitel.bgbilling.modules.softline.server.bean.SoftlineProductDao;
import ru.bitel.common.Utils;

public class SubscriptionCheckActivateDailyTask
extends TaskBase {
    private static Logger logger = LogManager.getLogger();

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try {
            ServerContext serverContext = (ServerContext)ServerContext.get();
            SoftLineSubscriptionService subscriptionService = (SoftLineSubscriptionService)serverContext.getService(SoftLineSubscriptionService.class, this.getModuleId());
            List activeSubscriptions = subscriptionService.searchSubscriptions(null, null, -1, -1, SoftLineSubscriptionStatus.ACTIVE, -1).getList();
            if (Utils.isEmptyCollection((Collection)activeSubscriptions)) {
                return;
            }
            Connection con = this.setup.getDBConnectionFromPool();
            SoftlineProductDao productDao = new SoftlineProductDao(con, this.getModuleId());
            logger.info("\u0412\u0441\u0435\u0433\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f = " + activeSubscriptions.size());
            for (SoftLineSubscription subscription : activeSubscriptions) {
                if (subscription.getSuspendReason() != null && subscription.getSuspendReason() == SoftLineSubscriptionSuspendReason.USER_REFUSE) continue;
                SoftLineProduct productOfSubscription = (SoftLineProduct)productDao.get(subscription.getProductId());
                if ((subscription.getEndDate().before(new Date()) || SoftLineUtils.checkTodayDate((Date)subscription.getEndDate())) && SoftLineUtils.checkActivation((Connection)con, (SoftLineSubscription)subscription, (SoftLineProduct)productOfSubscription)) {
                    logger.info("\u041f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438: [subscriptionId=" + subscription.getId() + ", productId=" + subscription.getProductId() + "]");
                    SoftLineUtils.prolongationDateEndSubscription((SoftLineSubscription)subscription, (SoftLineProduct)productOfSubscription);
                    SoftLineUtils.addContractAccount((Connection)con, (int)this.getModuleId(), (SoftLineSubscription)subscription, (Date)new Date());
                    subscriptionService.updateSubscription(subscription);
                    continue;
                }
                logger.info("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438: [subscriptionId=" + subscription.getId() + ", productId=" + subscription.getProductId() + "]");
            }
            con.close();
        }
        catch (SQLException | BGException e) {
            logger.error(e.getMessage());
        }
    }

    public String getDescription() {
        return "\u0415\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a";
    }
}

