/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paymaster.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.modules.paymaster.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paymaster.server.servlet.ModuleExecutor;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.SerialUtils;

@WebServlet(name="PayMasterInvoiceApi", urlPatterns={"/paymasterInvoiceConfirmation/*"})
public class ModuleExecutorInvoiceConfirmation
extends ModuleExecutor {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(ModuleExecutorInvoiceConfirmation.class);
    private final Logger log = LogManager.getLogger();

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int moduleId = 0;
        try {
            moduleId = ModuleExecutorInvoiceConfirmation.getModuleId((HttpServletRequest)request);
        }
        catch (BGMessageException ex) {
            this.log.error((Object)ex);
            this.doResponse(response, "NO");
            return;
        }
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        if (moduleSetup == null) {
            this.log.error("moduleSetup = null");
            this.doResponse(response, "NO");
            return;
        }
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            String paymentNo = request.getParameter("LMI_PAYMENT_NO");
            if (this.log.isDebugEnabled()) {
                this.log.debug("LMI_PAYMENT_NO = " + paymentNo);
            }
            int contractId = -1;
            String searchMode = request.getParameter("search_mode");
            if ("contract".equals(searchMode)) {
                Contract contract = this.getContract(paymentNo, con);
                if (contract == null) {
                    this.log.error("Contract == null!");
                    this.doResponse(response, "NO");
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("contractId = " + contract.getId());
                }
                contractId = contract.getId();
            } else {
                Transaction transaction = this.getTransaction(paymentNo, moduleId, con);
                if (transaction == null) {
                    this.log.error("Transaction == null!");
                    this.doResponse(response, "NO");
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("transactionId = " + transaction.getId());
                }
                contractId = transaction.getContractId();
            }
            int paymentTypeId = moduleSetup.getInt("paymaster.payment.type.id", -1);
            String responseText = this.invoiceConfirmation(con, moduleId, contractId, paymentTypeId);
            if (this.log.isDebugEnabled()) {
                this.log.debug("responseText = " + responseText);
            }
            this.doResponse(response, responseText);
        }
        catch (SQLException ex) {
            logger.error((Object)ex, (Throwable)ex);
            this.doResponse(response, "NO");
            return;
        }
    }
}

