/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.news.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.StringReader;
import java.util.Date;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.news.common.bean.NewsFilter;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;

public class News
extends IdTitle
implements Comparable<News> {
    private String body = null;
    private Date date = null;
    private Document doc = null;
    private NewsFilter filter = NewsFilter.NO;
    private String filterData = null;
    private String text = null;

    @Override
    public int compareTo(News news) {
        return this.date.compareTo(news.getDate());
    }

    @XmlAttribute
    public String getBody() {
        return this.body;
    }

    @XmlAttribute
    public Date getDate() {
        return this.date;
    }

    @XmlTransient
    public Document getDocument() throws BGException {
        if (this.doc == null) {
            this.doc = XMLUtils.newDocument();
            Element item = this.doc.createElement("item");
            item.setAttribute("id", String.valueOf(this.id));
            item.setAttribute("date", TimeUtils.format((Date)this.date, (String)"dd.MM.yyyy"));
            item.setAttribute("title", this.title);
            Document newsDoc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(this.body.replaceAll("[\r\n]", " "))), (XMLUtils.ErrorShowType)XMLUtils.ErrorShowType.SILENT);
            if (newsDoc != null) {
                Node node = this.doc.importNode(newsDoc.getDocumentElement(), true);
                item.appendChild(node);
            } else {
                StringTokenizer st = new StringTokenizer(this.body, "\r\n");
                while (st.hasMoreTokens()) {
                    Element div = this.doc.createElement("div");
                    div.appendChild(this.doc.createTextNode(st.nextToken()));
                    item.appendChild(div);
                }
            }
            this.doc.appendChild(item);
        }
        return this.doc;
    }

    @XmlAttribute
    public NewsFilter getFilter() {
        return this.filter;
    }

    @XmlElement
    public String getFilterData() {
        return this.filterData;
    }

    @XmlAttribute
    public String getText() {
        return this.text;
    }

    public void setBody(String text) {
        this.body = text;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFilter(NewsFilter filter) {
        this.filter = filter;
    }

    public void setFilterData(String filterData) {
        this.filterData = filterData;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return "[ " + TimeUtils.formatDate((Date)this.date) + " ] " + this.title;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private News news = new News();

        private Builder() {
        }

        public Builder setId(int id) {
            this.news.id = id;
            return this;
        }

        public Builder setTitle(String title) {
            this.news.title = title;
            return this;
        }

        public Builder setBody(String text) {
            this.news.body = text;
            return this;
        }

        public Builder setDate(Date date) {
            this.news.date = date;
            return this;
        }

        public Builder setFilter(NewsFilter filter) {
            this.news.filter = filter;
            return this;
        }

        public Builder setFilterData(String filterData) {
            this.news.filterData = filterData;
            return this;
        }

        public Builder setText(String text) {
            this.news.text = text;
            return this;
        }

        public News build() {
            try {
                News news = this.news;
                return news;
            }
            finally {
                this.news = null;
            }
        }
    }
}

