/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccount;
import ru.bitel.common.dao.AbstractDao;

public class MangoAccountDao
extends AbstractDao<MangoAccount> {
    public MangoAccountDao(Connection con, int moduleId) {
        super(con, moduleId, "mango_contract_account");
    }

    public MangoAccount getByContractId(int contractId) throws BGException {
        return (MangoAccount)this.get("contractId=?", new Object[]{contractId});
    }

    public MangoAccount getByAccountId(int accountId) throws BGException {
        return (MangoAccount)this.get("accountId=?", new Object[]{accountId});
    }

    public MangoAccount getByControl(String control) throws BGException {
        return (MangoAccount)this.get("control=?", new Object[]{control});
    }

    protected MangoAccount getFromRS(ResultSet rs) throws SQLException, BGException {
        MangoAccount mangoAccount = new MangoAccount();
        mangoAccount.setContractId(rs.getInt("contractId"));
        mangoAccount.setAccountId(rs.getInt("accountId"));
        mangoAccount.setControl(rs.getString("control"));
        mangoAccount.setPassword(rs.getString("pwd"));
        return mangoAccount;
    }

    protected void updateImpl(MangoAccount mangoAccount) throws BGException, SQLException {
        if (mangoAccount == null) {
            throw new BGIllegalArgumentException();
        }
        PreparedStatement ps = null;
        String query = "INSERT INTO " + this.tableName + "( contractId, accountId, control, pwd ) VALUES ( ?, ?, ?, ? ) ON DUPLICATE KEY UPDATE control=?, pwd=? ";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, mangoAccount.getContractId());
        ps.setInt(2, mangoAccount.getAccountId());
        ps.setString(3, mangoAccount.getControl());
        ps.setString(4, mangoAccount.getPassword());
        ps.setString(5, mangoAccount.getControl());
        ps.setString(6, mangoAccount.getPassword());
        ps.executeUpdate();
    }
}

