/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.services.ServicePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.GetDetailPanel;
import ru.bitel.bgbilling.modules.ipn.client.GraphPanel;
import ru.bitel.bgbilling.modules.ipn.client.PrintReportPanel;
import ru.bitel.bgbilling.modules.ipn.client.TablePanel;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class ServiceReportPanel
extends ServicePanel {
    int year;
    int month;
    int day;
    boolean loadList = true;
    private Color color = Color.white;
    private BGControlPanelListSelect servicePanel = new BGControlPanelListSelect();
    private JPanel dayPanel = new JPanel();
    private GridLayout dayPanelLayout = new GridLayout(0, 7);
    private JPanel yearPanel = new JPanel();
    private JPanel monthPanel = new JPanel();
    private JPanel dayLabelPanel = new JPanel();
    private GraphPanel graphPanel = new GraphPanel();
    private TablePanel tablePanel = new TablePanel();
    private PrintReportPanel printReportPanel = new PrintReportPanel();
    private GetDetailPanel detailCreatePanel = new GetDetailPanel();
    private BGControlPanelListSelect addressPane = new BGControlPanelListSelect();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JTabbedPane workspacePane = new JTabbedPane();
    private String selectedIds = "";

    public ServiceReportPanel() {
        this.init();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(int cid, int mid) {
        super.init(cid, mid);
        this.printReportPanel.init(cid, mid);
        this.detailCreatePanel.init(this.module, cid, mid);
    }

    private void init() {
        int i;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this.graphPanel);
        Font font = new Font("Dialog", 0, 10);
        Font font9 = font.deriveFont(9.0f);
        Insets insets = new Insets(0, 0, 0, 0);
        ActionListener yal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceReportPanel.this.yearButton_actionPerformed(e);
            }
        };
        int yy = new GregorianCalendar().get(1);
        for (int i2 = 3; i2 >= 0; --i2) {
            JButton button = new JButton("" + (yy - i2));
            button.setActionCommand("" + (yy - i2));
            if (i2 == 0) {
                button.setBackground(this.color);
            }
            button.setFont(font);
            button.setMargin(insets);
            button.addActionListener(yal);
            this.yearPanel.add(button);
        }
        this.year = yy;
        ActionListener mal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceReportPanel.this.monthButton_actionPerformed(e);
            }
        };
        int mm = new GregorianCalendar().get(2) + 1;
        for (i = 1; i < 13; ++i) {
            JButton button = new JButton(i < 10 ? "0" + i : "" + i);
            button.setToolTipText(TimeUtils.monthNames[i - 1]);
            button.setActionCommand("" + i);
            if (i == mm) {
                button.setBackground(this.color);
            }
            button.setFont(font);
            button.setMargin(insets);
            button.addActionListener(mal);
            this.monthPanel.add(button);
        }
        this.month = mm;
        for (i = 0; i < 7; ++i) {
            JLabel label = new JLabel(TimeUtils.weekDayName[i]);
            label.setFont(font);
            label.setHorizontalAlignment(0);
            this.dayLabelPanel.add(label);
        }
        ActionListener dal = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceReportPanel.this.dayButton_actionPerformed(e);
            }
        };
        for (int i3 = 0; i3 < 42; ++i3) {
            JButton button = new JButton("  ");
            button.setFont(font9);
            button.setVisible(false);
            button.setMargin(insets);
            button.addActionListener(dal);
            this.dayPanel.add(button);
        }
        this.buildMonth();
        this.day = 0;
    }

    private void jbInit() throws Exception {
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JToggleButton scaleValue_1 = new JToggleButton();
        JToggleButton scaleValue_2 = new JToggleButton();
        JToggleButton scaleValue_3 = new JToggleButton();
        JToggleButton scaleValue_4 = new JToggleButton();
        Insets insets = new Insets(0, 14, 0, 14);
        scaleValue_1.setMargin(insets);
        scaleValue_2.setMargin(insets);
        scaleValue_3.setMargin(insets);
        scaleValue_4.setMargin(insets);
        GridLayout gridLayout1 = new GridLayout();
        GridLayout gridLayout2 = new GridLayout();
        GridLayout gridLayout3 = new GridLayout();
        GridLayout gridLayout5 = new GridLayout();
        this.setLayout(new GridBagLayout());
        jPanel2.setLayout(new GridBagLayout());
        this.dayPanel.setLayout(this.dayPanelLayout);
        this.dayLabelPanel.setLayout(gridLayout3);
        this.monthPanel.setLayout(gridLayout2);
        this.yearPanel.setLayout(gridLayout1);
        gridLayout1.setColumns(4);
        gridLayout1.setRows(1);
        gridLayout2.setRows(2);
        gridLayout2.setColumns(6);
        gridLayout3.setColumns(7);
        jPanel6.setLayout(new GridBagLayout());
        jPanel3.setLayout(gridLayout5);
        this.graphPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 200));
        this.graphPanel.setMinimumSize(new Dimension(550, 200));
        this.graphPanel.setPreferredSize(new Dimension(550, 200));
        this.servicePanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        PropertyChangeListener pl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ServiceReportPanel.this.bGControlPanel_08_propertyChange(e);
            }
        };
        this.servicePanel.addPropertyChangeListener(pl);
        this.addressPane.addPropertyChangeListener(pl);
        gridLayout5.setRows(2);
        gridLayout5.setColumns(1);
        jPanel5.setLayout(new GridBagLayout());
        JSplitPane jSplitPane1 = new JSplitPane();
        jSplitPane1.setDividerSize(5);
        BGSwingUtilites.wrapBorder((JPanel)jPanel7, (String)" \u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f ");
        jPanel7.setLayout(new GridBagLayout());
        scaleValue_1.setActionCommand("1");
        scaleValue_1.setText("\u0431\u0430\u0439\u0442");
        scaleValue_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceReportPanel.this.scaleValue_1_actionPerformed(e);
            }
        });
        scaleValue_2.setActionCommand("1024");
        scaleValue_2.setText("\u041a\u0431");
        scaleValue_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceReportPanel.this.scaleValue_2_actionPerformed(e);
            }
        });
        scaleValue_3.setActionCommand("1048576");
        scaleValue_3.setSelected(true);
        scaleValue_3.setText("\u041c\u0431");
        scaleValue_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceReportPanel.this.scaleValue_3_actionPerformed(e);
            }
        });
        scaleValue_4.setActionCommand("1073741824");
        scaleValue_4.setText("\u0413\u0431");
        scaleValue_4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceReportPanel.this.scaleValue_4_actionPerformed(e);
            }
        });
        jPanel2.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        this.yearPanel.setBorder(null);
        this.monthPanel.setBorder(null);
        this.addressPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.add(jSplitPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jSplitPane1.setDividerLocation(300);
        jSplitPane1.setLeftComponent(jPanel5);
        jPanel2.add((Component)this.yearPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        jPanel2.add((Component)this.monthPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        jPanel2.add((Component)jPanel6, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        jPanel6.add((Component)this.dayLabelPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel6.add((Component)this.dayPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel7.add((Component)scaleValue_1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel7.add((Component)scaleValue_2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel7.add((Component)scaleValue_3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel7.add((Component)scaleValue_4, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel showReportPanel = new JPanel(new GridBagLayout());
        showReportPanel.add((Component)this.graphPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        showReportPanel.add((Component)this.tablePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        showReportPanel.add((Component)((Object)this.detailCreatePanel), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.workspacePane.addTab("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440", showReportPanel);
        this.workspacePane.addTab("\u041f\u0435\u0447\u0430\u0442\u044c", (Component)((Object)this.printReportPanel));
        this.workspacePane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component selectedComponent = ServiceReportPanel.this.workspacePane.getSelectedComponent();
                if (selectedComponent instanceof BGPanel) {
                    ((BGPanel)selectedComponent).trySetData();
                } else {
                    ServiceReportPanel.this.setData();
                }
            }
        });
        jSplitPane1.setRightComponent(this.workspacePane);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(scaleValue_1);
        buttonGroup1.add(scaleValue_2);
        buttonGroup1.add(scaleValue_3);
        buttonGroup1.add(scaleValue_4);
        JButton okButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceReportPanel.this.setData();
            }
        });
        jPanel5.add((Component)jPanel7, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)okButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)this.jTabbedPane1, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabbedPane1.add((Component)this.servicePanel, "\u0423\u0441\u043b\u0443\u0433\u0438");
        this.jTabbedPane1.add((Component)this.addressPane, "\u0410\u0434\u0440\u0435\u0441\u0430");
        this.addressPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("itemChange".equals(evt.getPropertyName())) {
                    ServiceReportPanel.this.selectedIds = ServiceReportPanel.this.addressPane.getListValues();
                }
            }
        });
    }

    private void setAddressRanges() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAction("GetAddressesList");
        request.setAttribute("year", String.valueOf(this.year));
        request.setAttribute("month", String.valueOf(this.month));
        request.setAttribute("day", String.valueOf(this.day));
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            Element listAddress = XMLUtils.selectElement((Node)doc, (String)"//listAddress");
            ClientUtils.buildList((BGControlPanelListSelect)this.addressPane, (Node)listAddress);
            this.addressPane.setListValues(this.selectedIds);
            this.detailCreatePanel.setAddressList(doc);
        }
    }

    public void setData() {
        String sid = this.servicePanel.getListValues();
        String aid = this.addressPane.getListValues();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetStatData");
        request.setAttribute("list", this.loadList ? "1" : "0");
        request.setAttribute("sid", sid);
        request.setAttribute("aid", aid);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAttribute("year", String.valueOf(this.year));
        request.setAttribute("month", String.valueOf(this.month));
        request.setAttribute("day", String.valueOf(this.day));
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            if (this.loadList) {
                this.fl = true;
                Node listServices = XMLUtils.selectNode((Node)doc, (String)"//listServices");
                ClientUtils.buildList((BGControlPanelListSelect)this.servicePanel, (Node)listServices);
                this.setAddressRanges();
                this.loadList = false;
                this.fl = false;
            }
            Node statNode = XMLUtils.selectNode((Node)doc, (String)"//stat");
            Element labelsNode = XMLUtils.selectElement((Node)doc, (String)"//labels");
            int items = -1;
            try {
                String tmp = XMLUtils.getAttribute((Element)labelsNode, (String)"items", null);
                items = Integer.parseInt(tmp);
            }
            catch (Exception e) {
                items = -1;
            }
            long[] grafDataValue = null;
            String[] labels = null;
            NodeList list = null;
            if (items > 0) {
                NamedNodeMap att;
                Node item;
                int j;
                grafDataValue = new long[items];
                list = statNode.getChildNodes();
                for (j = 0; j < list.getLength(); ++j) {
                    item = list.item(j);
                    if (!item.hasAttributes()) continue;
                    att = item.getAttributes();
                    try {
                        int id = Integer.parseInt(att.getNamedItem("id").getNodeValue());
                        long value = Long.parseLong(att.getNamedItem("value").getNodeValue());
                        if (id <= 0 || id > items) continue;
                        grafDataValue[id - 1] = value;
                        continue;
                    }
                    catch (Exception id) {
                        // empty catch block
                    }
                }
                labels = new String[items];
                list = labelsNode.getChildNodes();
                for (j = 0; j < list.getLength(); ++j) {
                    item = list.item(j);
                    if (!item.hasAttributes()) continue;
                    att = item.getAttributes();
                    try {
                        int id = Integer.parseInt(att.getNamedItem("id").getNodeValue());
                        String text = att.getNamedItem("text").getNodeValue();
                        if (id <= 0 || id > items || text == null) continue;
                        labels[id - 1] = text;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.graphPanel.setData(items, grafDataValue, labels);
                this.tablePanel.setData(items, grafDataValue, labels);
                this.printReportPanel.setData(sid, aid, this.year, this.month, this.day);
            }
        }
    }

    private void yearButton_actionPerformed(ActionEvent e) {
        int i;
        for (i = 0; i < this.yearPanel.getComponentCount(); ++i) {
            ((JButton)this.yearPanel.getComponent(i)).setBackground(UIManager.getColor("Panel.background"));
        }
        for (i = 0; i < this.monthPanel.getComponentCount(); ++i) {
            ((JButton)this.monthPanel.getComponent(i)).setBackground(UIManager.getColor("Panel.background"));
        }
        for (i = 0; i < this.dayPanel.getComponentCount(); ++i) {
            this.dayPanel.getComponent(i).setVisible(false);
        }
        this.year = Utils.parseInt((String)e.getActionCommand(), (int)new GregorianCalendar().get(1));
        this.month = 0;
        this.day = 0;
        this.setAddressRanges();
        this.updateYearButtons(e.getActionCommand());
        this.setData();
    }

    private void updateYearButtons(String command) {
        int buttonNumber = -1;
        for (int i = 0; i < this.yearPanel.getComponentCount(); ++i) {
            JButton yearButton = (JButton)this.yearPanel.getComponent(i);
            if (!yearButton.getActionCommand().equals(command)) continue;
            buttonNumber = i;
        }
        String yy = String.valueOf(new GregorianCalendar().get(1));
        String buttonCommand = ((JButton)this.yearPanel.getComponent(3)).getActionCommand();
        if (buttonNumber == 3 && yy.equals(buttonCommand)) {
            ((JButton)this.yearPanel.getComponent(3)).setBackground(this.color);
            return;
        }
        int countYear = buttonNumber - 2;
        for (int i = 0; i < this.yearPanel.getComponentCount(); ++i) {
            JButton yearButton = (JButton)this.yearPanel.getComponent(i);
            yearButton.setActionCommand(String.valueOf(Utils.parseInt((String)yearButton.getActionCommand()) + countYear));
            yearButton.setText(String.valueOf(Utils.parseInt((String)yearButton.getText()) + countYear));
        }
        ((JButton)this.yearPanel.getComponent(2)).setBackground(this.color);
    }

    private void monthButton_actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.monthPanel.getComponentCount(); ++i) {
            ((JButton)this.monthPanel.getComponent(i)).setBackground(UIManager.getColor("Panel.background"));
        }
        ((JButton)e.getSource()).setBackground(this.color);
        this.month = Utils.parseInt((String)e.getActionCommand(), (int)0);
        this.buildMonth();
        this.day = 0;
        this.setAddressRanges();
        this.setData();
    }

    private void dayButton_actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.dayPanel.getComponentCount(); ++i) {
            ((JButton)this.dayPanel.getComponent(i)).setBackground(UIManager.getColor("Panel.background"));
        }
        ((JButton)e.getSource()).setBackground(this.color);
        this.day = Utils.parseInt((String)e.getActionCommand(), (int)0);
        this.setAddressRanges();
        this.setData();
    }

    private void buildMonth() {
        try {
            int yy = this.year;
            int mm = this.month - 1;
            GregorianCalendar calendar = new GregorianCalendar(yy, mm, 1);
            int DAY_OF_WEEK = calendar.get(7);
            if (DAY_OF_WEEK == 1) {
                ((Calendar)calendar).add(5, -7);
            } else {
                ((Calendar)calendar).add(5, 1 - DAY_OF_WEEK);
            }
            for (int i = 0; i < this.dayPanel.getComponentCount(); ++i) {
                ((Calendar)calendar).add(5, 1);
                JButton button = (JButton)this.dayPanel.getComponent(i);
                button.setVisible(false);
                button.setBackground(UIManager.getColor("Panel.background"));
                if (calendar.get(2) != mm) continue;
                button.setVisible(true);
                int dd = calendar.get(5);
                button.setText(dd < 10 ? "0" + dd : "" + dd);
                button.setActionCommand("" + dd);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setUnit(String value) {
        int unit = 1;
        try {
            unit = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.graphPanel.setUnit(unit);
        this.tablePanel.setUnit(unit);
        this.printReportPanel.setUnit(unit);
    }

    private void bGControlPanel_08_propertyChange(PropertyChangeEvent e) {
        if ("itemChange".equals(e.getPropertyName())) {
            this.setData();
        }
    }

    private void scaleValue_1_actionPerformed(ActionEvent e) {
        this.setUnit(e.getActionCommand());
        this.setData();
    }

    private void scaleValue_2_actionPerformed(ActionEvent e) {
        this.setUnit(e.getActionCommand());
        this.setData();
    }

    private void scaleValue_3_actionPerformed(ActionEvent e) {
        this.setUnit(e.getActionCommand());
        this.setData();
    }

    private void scaleValue_4_actionPerformed(ActionEvent e) {
        this.setUnit(e.getActionCommand());
        this.setData();
    }
}

