/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import bitel.billing.module.common.BGControlPanelMonthAndDays;
import bitel.billing.module.common.BGFileFilter;
import bitel.billing.module.common.BGToggleButton;
import bitel.billing.module.common.table.BGTable;
import jakarta.activation.DataHandler;
import jakarta.xml.ws.Holder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.inet.client.GraphPanel;
import ru.bitel.bgbilling.modules.inet.client.monitor.ServiceConnectionsForm;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLogAccount;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficAccount;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficAccountDetail;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.bgbilling.modules.inet.common.service.RequestLogService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGEmailDialog;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.GroupParent;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public class ServiceReportPanel
extends BGUPanel
implements GroupParent {
    protected int show_mode = 0;
    protected final int SESSION_SHOW_MODE = 0;
    protected final int BALANCE_SHOW_MODE = 1;
    protected final int DIR_SHOW_MODE = 2;
    private final int MAX_LABEL_LENGTH = 100;
    private final InetSessionLogModel model = new InetSessionLogModel();
    protected BGControlPanelMonthAndDays periodPanel = new BGControlPanelMonthAndDays();
    private BGToggleButton sessionToggleButton = new BGToggleButton();
    private BGToggleButton sessionLogToggleButton = new BGToggleButton();
    JToggleButton rub = new JToggleButton("\u0420\u0443\u0431\u043b\u0438");
    private ButtonGroup buttonGroup = new ButtonGroup();
    private CardLayout cardLayout = new CardLayout();
    private JLabel timeSumLabel = new JLabel();
    private JLabel trafficsLabel = new JLabel();
    private JLabel servicesLabel = new JLabel();
    private JLabel servicesByteLabel = new JLabel();
    private BGTextField timeSum = new BGTextField();
    private BGTextField traffics = new BGTextField();
    private BGTextField serviceField = new BGTextField();
    private BGTextField serviceByteField = new BGTextField();
    private BGTextField moneySum = new BGTextField();
    private BGTextField sessionsCount = new BGTextField(20);
    protected BGUTable sessionTable = new BGUTable((TableModel)((Object)this.model));
    private BGTable accountTable = new BGTable();
    private GraphPanel graphPanel = new GraphPanel();
    JTabbedPane rightPane = new JTabbedPane();
    private List<double[]> toGraph = new ArrayList<double[]>();
    private List<String> legend = new ArrayList<String>();
    private String[] graphLabels;
    private List<TrafficAmount> graphTraffs;
    protected BGUCheckList<InetServ> service = new BGUCheckList(false);
    protected BGUCheckList<TrafficType> traficType = new BGUCheckList(false);
    protected BGUCheckList<Service> services = new BGUCheckList(false);
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JPanel unitPanel = null;
    boolean AccountSetColumn = false;
    boolean SessionSetColumn = false;
    private List<TrafficType> trafficTypes = new ArrayList<TrafficType>();
    private List<Service> servlist = new ArrayList<Service>();
    private int unit = 1;
    Map<Integer, InetDevice> deviceMap = new HashMap<Integer, InetDevice>();
    Map<Integer, InetServ> serviceMap = new HashMap<Integer, InetServ>();
    private InetSessionService sessionService;
    private InetServService servService;
    private InetDeviceService deviceService;
    private ModuleService moduleService;
    AbstractBGUPanel.MenuAction inetSessionClose;
    AbstractBGUPanel.MenuAction inetSessionFinish;
    AbstractBGUPanel.MenuAction inetSessionDetail;
    protected BGUComboBox<InetServ> serviceCombo = new BGUComboBox();
    protected BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();

    public ServiceReportPanel() {
    }

    public ServiceReportPanel(ClientContext context) {
        super(context);
    }

    protected void jbInit() {
        this.sessionService = (InetSessionService)((ClientContext)this.getContext()).getPort(InetSessionService.class);
        this.servService = (InetServService)((ClientContext)this.getContext()).getPort(InetServService.class);
        this.deviceService = (InetDeviceService)((ClientContext)this.getContext()).getPort(InetDeviceService.class);
        this.moduleService = (ModuleService)((ClientContext)this.getContext()).getWebService(ModuleService.class, 0);
        this.setLayout(new BorderLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.createLeftPanel(), (Component)this.createRightPanel(), 300L), "Center");
    }

    private void updateTableModel() {
        this.model.reinitColumns();
    }

    private void setData() throws BGException {
        Result result;
        int contractId = ((ClientContext)this.getContext()).getContractId();
        this.servlist = this.moduleService.serviceList(((ClientContext)this.getContext()).getModuleId());
        Set selected = this.service.getSelected();
        List serviceList = this.servService.inetServList(contractId, null);
        this.service.setData(serviceList);
        this.service.setSelected((Collection)selected);
        this.serviceMap = new HashMap<Integer, InetServ>();
        for (Object serv : serviceList) {
            this.serviceMap.put(serv.getId(), (InetServ)serv);
        }
        this.serviceCombo.setData(serviceList);
        Set selectedTypes = this.traficType.getSelected();
        this.trafficTypes.clear();
        for (TrafficType type : this.servService.trafficTypeList()) {
            if (type.getId() == 0) continue;
            this.trafficTypes.add(type);
        }
        this.traficType.setData(this.trafficTypes);
        this.traficType.setSelected((Collection)selectedTypes);
        Set<Integer> requestTrafsIds = this.getRequestTrafficIds();
        Page page = new Page(this.pagePanel.getPageIndex(), this.pagePanel.getPageSize());
        Set selectedServices = this.services.getSelected();
        this.services.setData(this.servlist);
        this.services.setSelected((Collection)selectedServices);
        Set<Integer> requestServiceIds = this.getRequestServiceIds();
        this.graphTraffs = null;
        Period period = this.periodPanel.getPeriod();
        this.inetSessionClose.setEnabled(this.sessionToggleButton.isSelected());
        this.inetSessionFinish.setEnabled(this.sessionToggleButton.isSelected());
        if (this.sessionToggleButton.isSelected()) {
            result = this.sessionService.inetSessionAliveContractList(contractId, this.service.getSelectedIds(), null, null, requestTrafsIds, requestServiceIds, page);
        } else {
            result = this.sessionService.inetSessionLogContractList(contractId, this.service.getSelectedIds(), period.getDateFrom(), period.getDateTo(), requestTrafsIds, requestServiceIds, page);
            boolean byDay = !TimeUtils.dateEqual((Date)period.getDateFrom(), (Date)period.getDateTo());
            this.graphTraffs = this.sessionService.inetContractTraffic(contractId, this.service.getSelectedIds(), period, requestTrafsIds, this.unit, byDay);
        }
        page = result.getPage();
        this.pagePanel.setPage(page);
        this.setTotalData(this.getTrafficTypes(), (Result<InetSessionLog>)result, this.getServices(), contractId, this.service.getSelectedIds(), this.periodPanel.getPeriod(), requestServiceIds);
        this.deviceMap.clear();
        this.updateTableModel();
        List sessions = result.getList();
        this.model.setData(sessions);
    }

    public void setTotalData(List<TrafficType> trafficTypes, Result<InetSessionLog> result, List<Service> services, int contractId, Set<Integer> inetServIds, Period period, Set<Integer> serviceIds) throws BGException {
        Object trafsStr = "";
        for (int i = 0; i < trafficTypes.size(); ++i) {
            TrafficType type = trafficTypes.get(i);
            trafsStr = (String)trafsStr + type.getTitle();
            if (i == trafficTypes.size() - 1) continue;
            trafsStr = (String)trafsStr + "/";
        }
        if (((String)trafsStr).length() > 100) {
            trafsStr = ((String)trafsStr).substring(0, 100) + "....";
        }
        if (((String)trafsStr).length() > 0) {
            trafsStr = (String)trafsStr + ":";
        }
        this.trafficsLabel.setText((String)trafsStr);
        HashMap traffics = new HashMap();
        JSONObject json = new JSONObject((String)result.getAttribute("totalTraffics"));
        json.keySet().forEach(k -> traffics.put(Integer.valueOf(k), json.getLong(k)));
        trafsStr = "";
        for (int i = 0; i < trafficTypes.size(); ++i) {
            TrafficType type = trafficTypes.get(i);
            Long value = (Long)traffics.get(type.getId());
            trafsStr = value != null ? (type.getId() != 0 ? (String)trafsStr + this.getAmountValue(value) : (String)trafsStr + Utils.formatSessionTime((int)value.intValue())) : (String)trafsStr + "0";
            if (i == trafficTypes.size() - 1) continue;
            trafsStr = (String)trafsStr + "/";
        }
        this.traffics.setText((String)trafsStr);
        this.traffics.setVisible(((String)trafsStr).length() != 0);
        this.setServiceTotalData(result, services, contractId, inetServIds, period, serviceIds);
        this.sessionsCount.setText(String.valueOf(Math.round(((Integer)result.getAttribute("totalCount")).intValue())));
        this.moneySum.setText(String.valueOf((BigDecimal)result.getAttribute("totalCost")));
        Long value = (Long)traffics.get(0);
        this.timeSum.setText(Utils.formatSessionTime((int)Math.round(value != null ? (float)value.longValue() : 0.0f)));
    }

    public void setServiceTotalData(Result<InetSessionLog> result, List<Service> services, int contractId, Set<Integer> inetServIds, Period period, Set<Integer> serviceIds) throws BGException {
        Object serviceStr = "";
        for (int i = 0; i < services.size(); ++i) {
            Service service = services.get(i);
            serviceStr = (String)serviceStr + service.getTitle();
            if (i == services.size() - 1) continue;
            serviceStr = (String)serviceStr + "/";
        }
        Object serviceStrByte = serviceStr;
        if (((String)serviceStr).length() > 100) {
            serviceStr = ((String)serviceStr).substring(0, 100) + "....";
        }
        if (((String)serviceStrByte).length() > 100) {
            serviceStrByte = ((String)serviceStrByte).substring(0, 100) + "....";
        }
        if (((String)serviceStr).length() > 0) {
            serviceStr = (String)serviceStr + "(\u0440\u0443\u0431)";
        }
        if (((String)serviceStr).length() > 0) {
            serviceStrByte = (String)serviceStrByte + "(\u0431\u0430\u0439\u0442)";
        }
        if (((String)serviceStr).length() > 0) {
            serviceStr = (String)serviceStr + ":";
        }
        if (((String)serviceStrByte).length() > 0) {
            serviceStrByte = (String)serviceStrByte + ":";
        }
        this.servicesLabel.setText((String)serviceStr);
        this.servicesByteLabel.setText((String)serviceStrByte);
        TrafficAccountDetail accountSums = this.sessionService.inetSessionAccountSums(contractId, inetServIds, period, serviceIds, this.sessionToggleButton.isSelected());
        serviceStr = "";
        Object serviceByteStr = "";
        for (int i = 0; i < services.size(); ++i) {
            Service service = services.get(i);
            TrafficAccount pair = (TrafficAccount)accountSums.getAccountMap().get(service.getId());
            BigDecimal account = null;
            Long amount = null;
            serviceStr = pair != null && (account = pair.getAccount()) != null ? (String)serviceStr + account : (String)serviceStr + "0";
            serviceByteStr = pair != null && (amount = Long.valueOf(pair.getAmount())) != null ? (String)serviceByteStr + this.getAmountValue(amount) : (String)serviceByteStr + "0";
            if (i == services.size() - 1) continue;
            serviceStr = (String)serviceStr + "/";
            serviceByteStr = (String)serviceByteStr + "/";
        }
        this.serviceField.setText((String)serviceStr);
        this.serviceField.setVisible(((String)serviceStr).length() != 0);
        this.serviceByteField.setText((String)serviceByteStr);
        this.serviceByteField.setVisible(((String)serviceByteStr).length() != 0);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.setData();
            this.setGraphValue();
            this.graphPanel.setData(this.toGraph, this.legend, this.graphLabels);
        });
        new AbstractBGUPanel.MenuAction("inetSession.log", "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c RADIUS/DHCP \u043b\u043e\u0433", ClientUtils.getIcon((String)"fugue/receipt-text")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetSessionLog session = (InetSessionLog)ServiceReportPanel.this.model.getSelectedRow();
                if (session != null) {
                    JTextArea log = new JTextArea(30, 70);
                    log.setMargin(new Insets(3, 3, 3, 3));
                    JScrollPane scrollPane = new JScrollPane(log);
                    log.setText(((RequestLogService)((ClientContext)ServiceReportPanel.this.getContext()).getPort(RequestLogService.class)).inetConnectionLog(session.getDeviceId(), session.getConnectionId(), session.getConnectionStart()));
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, "RADIUS/DHCP \u043b\u043e\u0433", 1);
                }
            }
        };
        new AbstractBGUPanel.MenuAction("sessionDetailValueCopy", "\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", ClientUtils.getIcon((String)"fugue/receipt-text")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                StringSelection data = new StringSelection(String.valueOf(ServiceReportPanel.this.getActionMap().get("sessionDetailValueCopy").getValue("copyValue")));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(data, data);
            }
        };
        this.inetSessionClose = new AbstractBGUPanel.MenuAction("inetSession.close", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 (\u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c)", ClientUtils.getIcon((String)"fugue/plug-disconnect")){
            {
                this.putValue("LongDescription", "<html>\u041f\u043e\u0441\u043b\u0430\u0442\u044c PoD, \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u0447\u0435\u0440\u0435\u0437 CoA, \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u043e SNMP \u0438 \u0442.\u043f.,<br>\u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430.</html>");
            }

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetSessionLog session = (InetSessionLog)ServiceReportPanel.this.model.getSelectedRow();
                if (session != null && BGSwingUtilites.confirm((String)"\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 (\u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c)", null)) {
                    ServiceReportPanel.this.sessionService.connectionClose(session.getConnectionId());
                }
            }
        };
        this.inetSessionFinish = new AbstractBGUPanel.MenuAction("inetSession.finish", "\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c (\u0437\u0430\u0432\u0438\u0441\u0448\u0435\u0435) \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", ClientUtils.getIcon((String)"fugue/plug--minus")){
            {
                this.putValue("LongDescription", "<html>\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0432 \u0411\u0414, \u043a\u0430\u043a \u0435\u0441\u043b\u0438 \u0431\u044b \u0432\u044b\u0448\u0435\u043b \u043b\u0438\u043c\u0438\u0442 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f<br>RADIUS- \u0438\u043b\u0438 Netflow-\u043f\u0430\u043a\u0435\u0442\u0430 (connection.close.timeout).</html>");
            }

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetSessionLog session = (InetSessionLog)ServiceReportPanel.this.model.getSelectedRow();
                if (session != null && BGSwingUtilites.confirm((String)"\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c (\u0437\u0430\u0432\u0438\u0441\u0448\u0435\u0435) \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", null)) {
                    ServiceReportPanel.this.sessionService.connectionFinish(session.getContractId(), session.getConnectionId());
                }
            }
        };
        this.inetSessionDetail = new AbstractBGUPanel.MenuAction("inetSession.detail", "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e", ClientUtils.getIcon((String)"fugue/document-table")){
            {
                this.putValue("LongDescription", "<html>\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u043f\u043e \u043b\u043e\u0433\u0430\u043c Netflow/sFlow.</html>");
            }

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                block5: {
                    String email;
                    InetSessionLog session;
                    block7: {
                        block6: {
                            session = (InetSessionLog)ServiceReportPanel.this.model.getSelectedRow();
                            if (session == null) {
                                return;
                            }
                            email = (String)JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "<html>\u0412\u0432\u0435\u0434\u0438\u0442\u0435 e-mail <font color=#333333 size=-2>(\u043e\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u043f\u043e\u043b\u0435 \u043f\u0443\u0441\u0442\u044b\u043c \u0434\u043b\u044f<br/>\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043d\u0430 \u0434\u0438\u0441\u043a Accounting-\u0441\u0435\u0440\u0432\u0435\u0440\u0430)</font></html>", "\u0417\u0430\u043f\u0440\u043e\u0441 \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", 3, null, null, ServiceReportPanel.this.getUserEmail(((ClientContext)ServiceReportPanel.this.getContext()).getModule()));
                            if (email == null) break block5;
                            if (!Utils.isBlankString((String)email)) break block6;
                            email = null;
                            switch (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u043d\u0430 \u0436\u0435\u0441\u0442\u043a\u0438\u0439 \u0434\u0438\u0441\u043a Accounting-\u0441\u0435\u0440\u0432\u0435\u0440\u0430?")) {
                                case 0: {
                                    break block7;
                                }
                                case 1: {
                                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 e-mail \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                        ServiceReportPanel.this.saveUserEmail(((ClientContext)ServiceReportPanel.this.getContext()).getModule(), email);
                    }
                    ServiceReportPanel.this.sessionService.inetSessionDetail(session.getId(), session.getSessionStart(), email);
                }
            }
        };
    }

    private BGControlPanelPages createPagePanel() {
        BGControlPanelPages pagePanel = new BGControlPanelPages();
        pagePanel.init();
        pagePanel.setKey(((Object)((Object)this)).getClass().getName());
        pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.performAction("refresh");
            }
        });
        return pagePanel;
    }

    private JPanel createUnitPanel() {
        Insets insets = new Insets(0, 14, 0, 14);
        ActionListener actionListener = e -> {
            this.traficType.setEnabled(true);
            this.traficType.repaint();
            this.scaleValueActionPerformed(e);
        };
        JToggleButton byteVal = new JToggleButton("\u0431\u0430\u0439\u0442");
        byteVal.setMargin(insets);
        byteVal.setActionCommand("1");
        byteVal.setSelected(true);
        byteVal.addActionListener(actionListener);
        JToggleButton kbyteVal = new JToggleButton("\u041a\u0431");
        kbyteVal.setMargin(insets);
        kbyteVal.setActionCommand("1024");
        kbyteVal.addActionListener(actionListener);
        JToggleButton mbyteVal = new JToggleButton("\u041c\u0431");
        mbyteVal.setMargin(insets);
        mbyteVal.setActionCommand("1048576");
        mbyteVal.addActionListener(actionListener);
        JToggleButton gbVal = new JToggleButton("\u0413\u0431");
        gbVal.setMargin(insets);
        gbVal.setActionCommand("1073741824");
        gbVal.addActionListener(actionListener);
        this.rub.setMargin(insets);
        this.rub.setActionCommand("1");
        this.rub.addActionListener(e -> {
            this.traficType.clearSelection();
            this.traficType.setEnabled(false);
            this.traficType.repaint();
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(byteVal);
        buttonGroup.add(kbyteVal);
        buttonGroup.add(mbyteVal);
        buttonGroup.add(gbVal);
        buttonGroup.add(this.rub);
        this.unitPanel = new JPanel();
        BGSwingUtilites.wrapBorder((JPanel)this.unitPanel, (String)" \u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f ");
        this.unitPanel.setLayout(new GridBagLayout());
        this.unitPanel.add((Component)byteVal, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.unitPanel.add((Component)kbyteVal, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.unitPanel.add((Component)mbyteVal, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.unitPanel.add((Component)gbVal, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.unitPanel.add((Component)this.rub, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return this.unitPanel;
    }

    protected void scaleValueActionPerformed(ActionEvent e) {
        this.unit = Integer.valueOf(e.getActionCommand());
    }

    private JPanel createSummPanel() {
        Color bgColor = this.sessionsCount.getBackground();
        this.timeSumLabel.setText("\u0412\u0440\u0435\u043c\u044f:");
        this.trafficsLabel.setText("");
        this.sessionsCount.setColumns(15);
        this.sessionsCount.setEditable(false);
        this.sessionsCount.setBackground(bgColor);
        this.sessionsCount.setHorizontalAlignment(4);
        this.moneySum.setColumns(15);
        this.moneySum.setEditable(false);
        this.moneySum.setBackground(bgColor);
        this.moneySum.setHorizontalAlignment(4);
        this.timeSum.setColumns(15);
        this.timeSum.setEditable(false);
        this.timeSum.setBackground(bgColor);
        this.timeSum.setHorizontalAlignment(4);
        this.traffics.setEditable(false);
        this.serviceField.setEditable(false);
        this.serviceByteField.setEditable(false);
        JPanel traffsSumPanel = new JPanel(new GridBagLayout());
        traffsSumPanel.add((Component)this.trafficsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        traffsSumPanel.add((Component)this.traffics, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        traffsSumPanel.add((Component)this.servicesLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 0), 0, 0));
        traffsSumPanel.add((Component)this.serviceField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        traffsSumPanel.add((Component)this.servicesByteLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 0), 0, 0));
        traffsSumPanel.add((Component)this.serviceByteField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        int gridx = 0;
        JPanel sumPanel = new JPanel(new GridBagLayout());
        sumPanel.add((Component)new JLabel("\u0421\u0435\u0441\u0441\u0438\u0439:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        sumPanel.add((Component)this.sessionsCount, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        sumPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 20, 0, 0), 0, 0));
        sumPanel.add((Component)this.moneySum, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        sumPanel.add((Component)this.timeSumLabel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 20, 0, 0), 0, 0));
        sumPanel.add((Component)this.timeSum, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 5), 0, 0));
        sumPanel.add((Component)traffsSumPanel, new GridBagConstraints(0, 1, 6, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 0, 5), 0, 0));
        return sumPanel;
    }

    private JPanel createAmountPanel() {
        JPanel amountPanel = new JPanel();
        amountPanel.setLayout(new GridBagLayout());
        amountPanel.add((Component)new JScrollPane((Component)this.accountTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return amountPanel;
    }

    private JPanel getSesionPanel() {
        this.sessionTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InetSessionLog inetSessionLog;
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (inetSessionLog = (InetSessionLog)ServiceReportPanel.this.model.getSelectedRow()) != null) {
                    new SessionViewDialog("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0441\u0435\u0441\u0441\u0438\u0438", inetSessionLog).open();
                }
            }
        });
        JPanel sessionPanel = new JPanel(new GridBagLayout());
        sessionPanel.add((Component)new JScrollPane((Component)this.sessionTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 0, 3), 0, 0));
        return sessionPanel;
    }

    private JPanel createRightTablePanel() {
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.createCardPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)this.createSummPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return rightPanel;
    }

    private JPanel createRightPanel() {
        JPanel resultPannel = new JPanel(new BorderLayout());
        this.rightPane.add((Component)this.createRightTablePanel(), "\u0422\u0430\u0431\u043b\u0438\u0446\u0430");
        List session = this.model.getRows();
        for (InetSessionLog inetSessionLog : session) {
            inetSessionLog.getSessionCost();
        }
        this.rightPane.add((Component)this.graphPanel, "\u0422\u0440\u0430\u0444\u0438\u043a");
        resultPannel.add((Component)this.createTopPanel(), "North");
        resultPannel.add((Component)this.rightPane, "Center");
        this.adjustGraphVisibility();
        return resultPannel;
    }

    void setGraphValue() throws BGException {
        this.toGraph.clear();
        this.legend.clear();
        Date date = this.periodPanel.getPeriod().getDateFrom();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        List<TrafficType> ttList = this.getTrafficTypes();
        List<Service> servList = this.getServices();
        for (TrafficType trafficType : ttList) {
            this.legend.add(trafficType.getTitle());
        }
        for (Service service : servList) {
            this.legend.add(service.getTitle());
        }
        for (TrafficType trafficType : ttList) {
            double[] graphDataValue;
            if (this.sessionLogToggleButton.isSelected()) {
                boolean byDay;
                boolean bl = byDay = !TimeUtils.dateEqual((Date)this.periodPanel.getPeriod().getDateFrom(), (Date)this.periodPanel.getPeriod().getDateTo());
                if (byDay) {
                    graphItems = cal.getActualMaximum(5);
                    this.graphLabels = new String[graphItems];
                    graphDataValue = new double[graphItems];
                    for (int i = 0; i < graphItems; ++i) {
                        this.graphLabels[i] = "" + (i + 1);
                    }
                    for (TrafficAmount amount : this.graphTraffs) {
                        int currentDay = amount.getPeriodDay();
                        if (amount.getTrafficMap().get(trafficType.getId()) == null) continue;
                        int n = currentDay - 1;
                        graphDataValue[n] = graphDataValue[n] + ((Long)amount.getTrafficMap().get(trafficType.getId())).doubleValue() / (double)this.unit;
                    }
                } else {
                    graphItems = 24;
                    this.graphLabels = new String[graphItems];
                    graphDataValue = new double[graphItems];
                    for (int i = 0; i < graphItems; ++i) {
                        this.graphLabels[i] = "" + i;
                    }
                    for (TrafficAmount amount : this.graphTraffs) {
                        int currentHour = amount.getPeriodHour();
                        if (amount.getTrafficMap().get(trafficType.getId()) == null) continue;
                        int n = currentHour;
                        graphDataValue[n] = graphDataValue[n] + ((Long)amount.getTrafficMap().get(trafficType.getId())).doubleValue() / (double)this.unit;
                    }
                }
            } else {
                graphDataValue = new double[1];
            }
            this.toGraph.add(graphDataValue);
        }
    }

    private JPanel createTopPanel() {
        JButton detailButton = new JButton("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f");
        detailButton.addActionListener(e -> new SessionDetailDialog("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f", null).open());
        this.pagePanel = this.createPagePanel();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        panel.add((Component)this.getSessionButtonPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)detailButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getSessionButtonPanel() {
        this.sessionToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.sessionToggleButton.setSelected(true);
        this.sessionToggleButton.setText("\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u0438");
        this.sessionLogToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.sessionLogToggleButton.setSelected(true);
        this.sessionLogToggleButton.setText("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0439");
        ActionListener listener = e -> this.adjustGraphVisibility();
        this.sessionLogToggleButton.addActionListener(listener);
        this.sessionToggleButton.addActionListener(listener);
        this.buttonGroup.add((AbstractButton)this.sessionToggleButton);
        this.buttonGroup.add((AbstractButton)this.sessionLogToggleButton);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.sessionToggleButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 5), 0, 0));
        panel.add((Component)this.sessionLogToggleButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 2), 0, 0));
        return panel;
    }

    private JPanel createCardPanel() {
        JPanel cardPanel = new JPanel();
        cardPanel.setLayout(this.cardLayout);
        JPanel sessionPanel = this.getSesionPanel();
        JPanel amountPanel = this.createAmountPanel();
        cardPanel.add((Component)sessionPanel, "sessions");
        cardPanel.add((Component)amountPanel, "amounts");
        BGEditor editor = new BGEditor("table");
        editor.setVisible(true);
        editor.addForm((JComponent)cardPanel, (Object)"table");
        editor.addForm((JComponent)((Object)new ServiceConnectionsForm(this.model)));
        return editor;
    }

    private JPanel createLeftPanel() {
        this.periodPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        BGButtonPanel bGControlPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.PRINT_M, BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M, BGButtonPanel.GLUE, BGButtonPanel.DO_M});
        bGControlPanel.addActionListener(e -> this.contolPanelActionPerformed(e));
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)bGControlPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        leftPanel.add((Component)this.createServicePanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.createTrafficTypePanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.createServicesPanel(), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.periodPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.createUnitPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return leftPanel;
    }

    protected void contolPanelActionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("do")) {
            this.pagePanel.setPageIndex(1);
            this.performAction("refresh");
        } else if (BGButtonPanel.PRINT_M.getActionCommand().equals(actionCommand)) {
            try {
                this.sessionTable.print(JTable.PrintMode.FIT_WIDTH, null, null, true, null, true);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        } else {
            int contractId = ((ClientContext)this.getContext()).getContractId();
            Set<Integer> requestTrafsIds = this.getRequestTrafficIds();
            Set<Integer> requestServIds = this.getRequestServiceIds();
            boolean alive = this.sessionToggleButton.isSelected();
            if (BGButtonPanel.SAVE_M.getActionCommand().equals(actionCommand)) {
                BGFileChooser fc = this.getFileChooser();
                if (fc.showSaveDialog() == 0) {
                    File file = new File(this.getSelectedFilePath(fc));
                    String format = this.getSelectedExtension(fc);
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        Holder data = new Holder();
                        Date dateFrom = this.periodPanel.getPeriod().getDateFrom();
                        Date dateTo = this.periodPanel.getPeriod().getDateTo();
                        this.sessionService.inetSessionExport(contractId, this.service.getSelectedIds(), dateFrom, dateTo, requestTrafsIds, requestServIds, null, data, alive, format, null, (long)this.unit);
                        ((DataHandler)data.value).writeTo((OutputStream)fileOutputStream);
                        fileOutputStream.flush();
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0424\u0430\u0439\u043b \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            } else if (BGButtonPanel.EMAIL_M.getActionCommand().equals(e.getActionCommand())) {
                BGEmailDialog dialog = new BGEmailDialog();
                dialog.addPropertyChangeListener(evt -> {
                    if (evt.getPropertyName().equals("selectEmail")) {
                        try {
                            String emails = String.valueOf(evt.getNewValue());
                            List<String> emailsList = Arrays.asList(emails.split(","));
                            this.sessionService.inetSessionExportSendToEmail(contractId, this.service.getSelectedIds(), this.periodPanel.getPeriod(), requestTrafsIds, requestServIds, alive, null, null, (long)this.unit, emailsList);
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u0447\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                        }
                        catch (BGException ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                });
                dialog.loadEmailListFromContractParameter(((ClientContext)this.getContext()).getContractId(), 0);
                dialog.setVisible(true);
            }
        }
    }

    private JPanel createServicesPanel() {
        JPanel servicesPanel = new JPanel();
        servicesPanel.setLayout(new GridBagLayout());
        servicesPanel.setBorder((Border)new BGTitleBorder("\u0423\u0441\u043b\u0443\u0433\u0438"));
        servicesPanel.add((Component)this.services, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return servicesPanel;
    }

    private JPanel createServicePanel() {
        JPanel servicePanel = new JPanel();
        servicePanel.setLayout(new GridBagLayout());
        servicePanel.setBorder((Border)new BGTitleBorder(" \u0421\u0435\u0440\u0432\u0438\u0441 "));
        servicePanel.add((Component)this.service, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return servicePanel;
    }

    private JPanel createTrafficTypePanel() {
        JPanel traficTypePanel = new JPanel();
        traficTypePanel.setLayout(new GridBagLayout());
        traficTypePanel.setBorder((Border)new BGTitleBorder("\u0422\u0438\u043f\u044b \u0442\u0440\u0430\u0444\u0438\u043a\u0430"));
        traficTypePanel.add((Component)this.traficType, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return traficTypePanel;
    }

    protected List<TrafficType> getTrafficTypes() {
        ArrayList<TrafficType> result = new ArrayList<TrafficType>();
        if (this.traficType.getSelected().size() > 0) {
            Set selected = this.traficType.getSelected();
            for (TrafficType type : this.trafficTypes) {
                if (!selected.contains(type)) continue;
                result.add(type);
            }
        }
        return result;
    }

    protected List<Service> getServices() {
        ArrayList<Service> result = new ArrayList<Service>();
        if (this.services.getSelected().size() > 0) {
            Set selected = this.services.getSelected();
            for (Service service : this.servlist) {
                if (!selected.contains(service)) continue;
                result.add(service);
            }
        }
        return result;
    }

    private BigDecimal getAmountValue(long value) {
        BigDecimal result = new BigDecimal(value);
        if (this.unit != 1) {
            result = result.divide(new BigDecimal(this.unit), 3, RoundingMode.HALF_UP);
        }
        return result;
    }

    public static void exportToExcel(TableModel model, File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));
            PrintWriter fileWriter = new PrintWriter(bufferedWriter);
            for (int i = 0; i < model.getRowCount(); ++i) {
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    Object obj = model.getValueAt(i, j);
                    if (obj != null) {
                        fileWriter.print(obj.toString());
                    }
                    fileWriter.print(";");
                }
                fileWriter.println();
            }
            fileWriter.close();
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Success. File Exported");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    private BGFileChooser getFileChooser() {
        BGFileChooser fc = new BGFileChooser((Component)((Object)this)){

            public void approveSelection() {
                int result;
                File f = this.getSelectedFile();
                if (f.exists() && (result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0424\u0430\u0439\u043b \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442, \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c?", "\u0424\u0430\u0439\u043b \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", 0)) != 0) {
                    return;
                }
                super.approveSelection();
            }
        };
        FileFilter[] ff = fc.getChoosableFileFilters();
        if (ff != null) {
            for (int i = 0; i < ff.length; ++i) {
                fc.removeChoosableFileFilter(ff[i]);
            }
        }
        BGFileFilter htmlFilter = new BGFileFilter("html|htm", "HTML File");
        BGFileFilter csvFilter = new BGFileFilter("csv", "CSV File");
        fc.addChoosableFileFilter((FileFilter)htmlFilter);
        fc.addChoosableFileFilter((FileFilter)csvFilter);
        return fc;
    }

    private String getSelectedFilePath(BGFileChooser fc) {
        String extension;
        Object path = fc.getSelectedFile().getAbsolutePath();
        if (!((String)path).endsWith(extension = this.getSelectedExtension(fc))) {
            path = (String)path + "." + extension;
        }
        return path;
    }

    private String getSelectedExtension(BGFileChooser fc) {
        String[] extensions = ((BGFileFilter)fc.getFileFilter()).getExtensions();
        String selected = null;
        if (extensions.length > 0) {
            selected = extensions[0];
        }
        return selected;
    }

    private Set<Integer> getRequestTrafficIds() {
        HashSet<Integer> requestTrafsIds = new HashSet<Integer>();
        List<TrafficType> trafficTypes = this.getTrafficTypes();
        for (int i = 0; i < trafficTypes.size(); ++i) {
            TrafficType type = trafficTypes.get(i);
            requestTrafsIds.add(type.getId());
        }
        requestTrafsIds.add(TrafficType.TIME_ID);
        return requestTrafsIds;
    }

    private Set<Integer> getRequestServiceIds() {
        HashSet<Integer> requestServIds = new HashSet<Integer>();
        List<Service> services = this.getServices();
        for (int i = 0; i < services.size(); ++i) {
            Service serv = services.get(i);
            requestServIds.add(serv.getId());
        }
        return requestServIds;
    }

    protected void adjustGraphVisibility() {
        if (this.sessionLogToggleButton.isSelected()) {
            this.rightPane.add((Component)this.graphPanel, "\u0422\u0440\u0430\u0444\u0438\u043a");
        } else {
            this.rightPane.remove(this.graphPanel);
        }
    }

    private String getDeviceTitle(int deviceId) {
        if (deviceId < 1) {
            return "";
        }
        try {
            InetDevice device = this.deviceMap.get(deviceId);
            if (device == null && !this.deviceMap.containsKey(deviceId)) {
                device = this.deviceService.inetDeviceGet(deviceId);
                this.deviceMap.put(deviceId, device);
            }
            if (device != null) {
                return device.getTitle();
            }
        }
        catch (BGException e) {
            this.deviceMap.put(deviceId, null);
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 " + e.getMessage());
        }
        return "??? [ID#" + deviceId + "]";
    }

    private String getIp(byte[] address, byte[] prefix, short prefixLength) {
        StringBuilder sb = new StringBuilder(60);
        if (address != null) {
            IpAddress.toString((byte[])address, (StringBuilder)sb);
        }
        if (prefix != null) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            IpAddress.toRFCString((byte[])prefix, (StringBuilder)sb);
            sb.append("/").append(prefixLength);
        }
        return sb.toString();
    }

    private String getSessionCost(BigDecimal sessionCost, List<InetSessionLog> children) {
        if (children != null && children.size() > 0) {
            for (InetSessionLog child : children) {
                sessionCost = sessionCost.add(child.getSessionCost());
            }
        }
        return Utils.formatBigDecimal((BigDecimal)sessionCost, (int)2);
    }

    private String getSessionTime(Long amount, int sessionTime) {
        return Utils.formatSessionTime((int)(amount != null && amount != 0L ? amount.intValue() : sessionTime));
    }

    class InetSessionLogModel
    extends BGTableModel<InetSessionLog> {
        List<TrafficType> trafficTypes;
        List<Service> services;

        public InetSessionLogModel() {
            super("inetSession");
        }

        public void reinitColumns() {
            this.trafficTypes = ServiceReportPanel.this.getTrafficTypes();
            this.services = ServiceReportPanel.this.getServices();
            super.reinitColumns();
            this.table.setModel((TableModel)((Object)new InetSessionLogModel()));
            this.table.setModel((TableModel)((Object)this));
            ((BGUTable)this.table).loadColumnProperties();
        }

        protected void initColumns() {
            if (this.trafficTypes == null) {
                this.trafficTypes = Collections.emptyList();
            }
            if (this.services == null) {
                this.services = Collections.emptyList();
            }
            this.addColumn("ConID", 50, 80, 150, "connectionId", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("SessID", 50, 80, 150, "id", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", -1, 150, -1, null, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", -1, 150, -1, "acctSessionId", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0435\u0440\u0432\u0438\u0441", -1, 220, -1, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u0435\u0430\u043b\u043c", -1, 80, -1, "realm", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421 \u043d\u043e\u043c\u0435\u0440\u0430/\u043d\u0430 \u043d\u043e\u043c\u0435\u0440", -1, 150, -1, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("IP", -1, 150, -1, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", 150, 150, 150, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", 150, 150, 150, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c", 150, 150, 150, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("C\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 100, 100, 100, "sessionCost", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 100, -1, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", -1, 100, -1, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0412\u0440\u0435\u043c\u044f", -1, 110, -1, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            for (TrafficType traf : this.trafficTypes) {
                this.addColumn(traf.getTitle(), -1, 150, 200, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            }
            for (Service service : this.services) {
                this.addColumn(service.getTitle(), -1, 150, 200, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            }
        }

        protected void initTrafficColumns() {
            if (this.trafficTypes == null) {
                this.trafficTypes = Collections.emptyList();
            }
            this.addColumn("\u0412\u0440\u0435\u043c\u044f", -1, 110, -1, null, false);
            for (TrafficType traf : this.trafficTypes) {
                this.addColumn(traf.getTitle(), -1, 150, 200, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            }
        }

        public Object getValue(InetSessionLog val, int column) throws BGException {
            Object result = null;
            switch (column) {
                case 2: {
                    result = ServiceReportPanel.this.getDeviceTitle(val.getDeviceId());
                    break;
                }
                case 4: {
                    result = Optional.ofNullable(ServiceReportPanel.this.serviceMap.get(val.getServId())).map(a -> a.getTitle()).orElse("");
                    break;
                }
                case 6: {
                    result = Utils.maskNull((String)val.getCallingStationId()) + "/" + Utils.maskNull((String)val.getCalledStationId());
                    break;
                }
                case 7: {
                    result = ServiceReportPanel.this.getIp(val.getInetAddressBytes(), val.getPrefix(), val.getPrefixLength());
                    break;
                }
                case 8: {
                    result = val.getSessionStartAsString();
                    break;
                }
                case 9: {
                    result = val.getSessionStopAsString();
                    break;
                }
                case 10: {
                    result = val.getSessionActivityAsString();
                    break;
                }
                case 11: {
                    result = ServiceReportPanel.this.getSessionCost(val.getSessionCost(), val.getChildren());
                    break;
                }
                case 12: {
                    result = val.getStatusName();
                    break;
                }
                case 13: {
                    result = val.getDeviceState() == InetServState.STATE_ENABLE.getCode() ? "\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e";
                    break;
                }
                case 14: {
                    result = ServiceReportPanel.this.getSessionTime((Long)val.getTrafficMap().get(TrafficType.TIME_ID), (int)val.getSessionTime());
                    break;
                }
                default: {
                    int columnCount = 14;
                    if (column > columnCount && column <= columnCount + this.trafficTypes.size()) {
                        TrafficType type = this.trafficTypes.get(column - (columnCount - 1) - 2);
                        Long amount = (Long)val.getTrafficMap().get(type.getId());
                        long amountSum = amount != null ? amount : 0L;
                        List children = val.getChildren();
                        if (children != null && children.size() > 0) {
                            for (InetSessionLog child : children) {
                                amount = (Long)child.getTrafficMap().get(type.getId());
                                if (amount == null) continue;
                                amountSum += amount.longValue();
                            }
                        }
                        result = ServiceReportPanel.this.getAmountValue(amountSum);
                        break;
                    }
                    if (column > columnCount + this.trafficTypes.size() && column <= columnCount + this.trafficTypes.size() + this.services.size()) {
                        List children;
                        Service serv = this.services.get(column - (columnCount + this.trafficTypes.size()) - 1);
                        Long amountSum = 0L;
                        BigDecimal accountSum = BigDecimal.ZERO;
                        InetSessionLogAccount isla = (InetSessionLogAccount)val.getAccountMap().get(serv.getId());
                        BigDecimal amount = null;
                        BigDecimal account = null;
                        if (isla != null) {
                            amount = BigDecimal.valueOf(isla.getAmount());
                            account = isla.getAccount();
                        }
                        if (amount != null) {
                            amountSum = amount.longValue();
                        }
                        if (account != null) {
                            accountSum = account;
                        }
                        if ((children = val.getChildren()) != null && children.size() > 0) {
                            for (InetSessionLog child : children) {
                                InetSessionLogAccount ac = (InetSessionLogAccount)child.getAccountMap().get(serv.getId());
                                if (ac == null) continue;
                                amountSum = amountSum + ac.getAmount();
                                accountSum = accountSum.add(ac.getAccount());
                            }
                        }
                        if (!ServiceReportPanel.this.rub.isSelected()) {
                            result = ServiceReportPanel.this.getAmountValue(amountSum);
                            break;
                        }
                        result = accountSum;
                        break;
                    }
                    result = super.getValue((Object)val, column);
                }
            }
            return result;
        }
    }

    class SessionDetailDialog
    extends BGEditorDialog<String> {
        protected BGTextField email;
        private BGUComboBox<IdTitle> where;

        public SessionDetailDialog(String title, String data) {
            super(title, (Object)data);
            this.email = new BGTextField();
            this.where = new BGUComboBox();
        }

        public void doDialogPanel() {
            ArrayList<IdTitle> whereList = new ArrayList<IdTitle>();
            whereList.add(new IdTitle(0, "\u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430 \u0434\u0438\u0441\u043a Accounting-\u0441\u0435\u0440\u0432\u0435\u0440\u0430"));
            whereList.add(new IdTitle(1, "\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043d\u0430 e-mail"));
            this.where.setData(whereList);
            this.where.addActionListener(e -> this.email.setEnabled(this.where.getSelectedIndex() != 0));
            this.email.setText(ServiceReportPanel.this.getUserEmail(((ClientContext)ServiceReportPanel.this.getContext()).getModule()));
            this.email.setHorizontalAlignment(0);
            this.email.setEnabled(false);
            this.panel.add((Component)new JLabel("\u0421\u0435\u0440\u0432\u0438\u0441:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)ServiceReportPanel.this.serviceCombo, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)ServiceReportPanel.this.period, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u0443\u0434\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.where, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("E-mail:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.email, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            InetServ serv = (InetServ)ServiceReportPanel.this.serviceCombo.getSelectedItem();
            if (serv == null) {
                return false;
            }
            Date dateFrom = ServiceReportPanel.this.period.getDateFrom();
            Date dateTo = ServiceReportPanel.this.period.getDateTo();
            if (dateFrom == null || dateTo == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0438\u043e\u0434");
                return false;
            }
            String email = null;
            if (this.where.getSelectedIndex() != 0) {
                email = this.email.getText();
                if (Utils.isBlankString((String)email)) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 e-mail \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
                    return false;
                }
                ServiceReportPanel.this.saveUserEmail(((ClientContext)ServiceReportPanel.this.getContext()).getModule(), email);
            }
            ServiceReportPanel.this.sessionService.inetSessionPeriodDetail(serv.getId(), dateFrom, dateTo, email);
            return true;
        }
    }

    class SessionViewTableModel
    extends BGTableModel<KeyValue> {
        public SessionViewTableModel() {
            super(SessionViewTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 250, 250, 250, "key", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, 140, -1, "value", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class SessionViewDialog
    extends BGEditorDialog<InetSessionLog> {
        private JPopupMenu popupMenu;
        private SessionViewTableModel tableModel;

        public SessionViewDialog(String title, InetSessionLog data) {
            super(title, (Object)data);
            this.popupMenu = new JPopupMenu();
            this.tableModel = new SessionViewTableModel();
        }

        public void doDialogPanel() {
            final BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
            table.setSelectionMode(0);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        Action action = ServiceReportPanel.this.getActionMap().get("sessionDetailValueCopy");
                        action.putValue("copyValue", ((KeyValue)SessionViewDialog.this.tableModel.getSelectedRow()).getValue());
                        if (SessionViewDialog.this.popupMenu.getComponentCount() == 0) {
                            SessionViewDialog.this.popupMenu.add(action);
                        }
                        SessionViewDialog.this.popupMenu.show((Component)table, e.getX() + 1, e.getY() + 1);
                    }
                }
            });
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)800, (int)400), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            ArrayList<KeyValue> params = new ArrayList<KeyValue>();
            params.add(new KeyValue("Conection ID", String.valueOf(((InetSessionLog)this.data).getConnectionId())));
            params.add(new KeyValue("Session ID", String.valueOf(((InetSessionLog)this.data).getId())));
            params.add(new KeyValue("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", ServiceReportPanel.this.getDeviceTitle(((InetSessionLog)this.data).getDeviceId())));
            params.add(new KeyValue("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440(Acct-Session-Id)", ((InetSessionLog)this.data).getAcctSessionId()));
            params.add(new KeyValue("\u0421\u0435\u0440\u0432\u0438\u0441", Optional.ofNullable(ServiceReportPanel.this.serviceMap.get(((InetSessionLog)this.data).getServId())).map(a -> a.getTitle()).orElse("")));
            params.add(new KeyValue("\u0420\u0435\u0430\u043b\u043c", ((InetSessionLog)this.data).getRealm()));
            params.add(new KeyValue("\u0421 \u043d\u043e\u043c\u0435\u0440\u0430/\u043d\u0430 \u043d\u043e\u043c\u0435\u0440", Utils.maskNull((String)((InetSessionLog)this.data).getCallingStationId()) + "/" + Utils.maskNull((String)((InetSessionLog)this.data).getCalledStationId())));
            params.add(new KeyValue("IP", ServiceReportPanel.this.getIp(((InetSessionLog)this.data).getInetAddressBytes(), ((InetSessionLog)this.data).getPrefix(), ((InetSessionLog)this.data).getPrefixLength())));
            params.add(new KeyValue("\u041d\u0430\u0447\u0430\u043b\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f", ((InetSessionLog)this.data).getConnectionStartAsString()));
            params.add(new KeyValue("\u041d\u0430\u0447\u0430\u043b\u043e \u0441\u0435\u0441\u0441\u0438\u0438", ((InetSessionLog)this.data).getSessionStartAsString()));
            params.add(new KeyValue("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u0438", ((InetSessionLog)this.data).getSessionStopAsString()));
            params.add(new KeyValue("\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c", ((InetSessionLog)this.data).getSessionActivityAsString()));
            params.add(new KeyValue("C\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", ServiceReportPanel.this.getSessionCost(((InetSessionLog)this.data).getSessionCost(), ((InetSessionLog)this.data).getChildren())));
            params.add(new KeyValue("\u0421\u0442\u0430\u0442\u0443\u0441", ((InetSessionLog)this.data).getStatusName()));
            params.add(new KeyValue("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", ((InetSessionLog)this.data).getDeviceState() == InetServState.STATE_ENABLE.getCode() ? "\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e"));
            params.add(new KeyValue("\u0412\u0440\u0435\u043c\u044f", ServiceReportPanel.this.getSessionTime((Long)((InetSessionLog)this.data).getTrafficMap().get(TrafficType.TIME_ID), (int)((InetSessionLog)this.data).getSessionTime())));
            this.tableModel.setData(params);
        }
    }
}

