/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.task;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.hd.common.bean.Zone;
import ru.bitel.bgbilling.modules.hd.server.bean.ZoneDAO;
import ru.bitel.bgbilling.modules.hd.server.task.ZoneTaskUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;

public class UpdateSlaveServer
extends TaskBase {
    private String user = null;
    private String slaveDirectory = null;
    private String dnsPath = null;
    private String[] ourNSServers = null;
    private Connection con = null;
    private Preferences moduleSetup = null;

    protected boolean initTask() {
        this.user = this.taskSetup.get("user", null);
        this.slaveDirectory = this.taskSetup.get("slaveDirectory", "slave");
        this.dnsPath = this.taskSetup.get("dnsPath", "/var/named");
        this.con = this.setup.getDBConnectionFromPool();
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        this.ourNSServers = this.moduleSetup.get("zone.ns_secondary.list", null).split(",");
        if (this.moduleId <= 0 || this.user == null || this.slaveDirectory == null || this.dnsPath == null) {
            this.getLogger().error("Some param not found!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        try {
            ZoneDAO zoneManager = new ZoneDAO(this.con, this.moduleId);
            List<Zone> zoneList = zoneManager.getZoneList();
            this.createFiles(this.ourNSServers);
            for (Zone zone : zoneList) {
                String[] secondaryNs;
                block6: for (String ns : secondaryNs = ZoneTaskUtils.getZoneContent(zone.getConfig()).get("secondary").split(";")) {
                    for (String str : this.ourNSServers) {
                        if (!ns.equalsIgnoreCase(str)) continue;
                        String zoneEntry = this.createSlaveEntry(zone);
                        this.writeFile(str, zoneEntry);
                        continue block6;
                    }
                }
            }
            for (String server : this.ourNSServers) {
                this.updateSlaves(server);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ZoneTaskUtils.deleteTempFiles();
            ServerUtils.closeConnection((Connection)this.con);
        }
    }

    private void createFiles(String[] servers) {
        File tmp = new File(ZoneTaskUtils.ZONE_TMP_DIR);
        tmp.mkdirs();
        for (int i = 0; i < servers.length; ++i) {
            File zonesFile = new File(tmp, servers[i]);
            try {
                if (!zonesFile.createNewFile()) continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String fileName, String zoneData) {
        File tmp = new File(ZoneTaskUtils.ZONE_TMP_DIR);
        tmp.mkdirs();
        File zoneFile = new File(tmp, fileName);
        if (zoneFile.exists()) {
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(zoneFile, true));
                bw.write(zoneData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    bw.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private String createSlaveEntry(Zone zone) {
        StringBuilder result = new StringBuilder("zone ");
        result.append("\"" + zone.getZone() + "\"");
        result.append(" { type slave; ");
        String zonePath = this.slaveDirectory + "/" + zone.getZone();
        result.append("file \"" + zonePath + "\"; ");
        String primaryNs = ZoneTaskUtils.getZoneContent(zone.getConfig()).get("primary");
        result.append(" masters { " + primaryNs + "; };");
        result.append("};\n");
        return result.toString();
    }

    private void updateSlaves(String slaveServerUrl) {
        String scriptPath = ((Object)((Object)this)).getClass().getResource("./script/updater.sh").toString();
        StringBuilder command = new StringBuilder(scriptPath.substring(5, scriptPath.length()));
        ZoneTaskUtils.setExecutable(command.toString());
        command.append(" " + this.user);
        command.append(" " + slaveServerUrl);
        command.append(" " + ZoneTaskUtils.ZONE_TMP_DIR);
        command.append(" " + this.dnsPath);
        ZoneTaskUtils.executeScript(command.toString());
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c HD. \u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f slave \u0441\u0435\u0440\u0432\u0435\u0440\u0430";
    }
}

