/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.service;

import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.common.service.EmailService;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.email.common.service.EmailService")
public class EmailServiceImpl
extends AbstractService
implements EmailService {
    public Domain domainGet(int domainId) throws BGException, BGMessageException {
        try (DomainManager domainManager = new DomainManager(this.getConnection(), this.moduleId);){
            Domain domain = domainManager.get(domainId);
            return domain;
        }
    }

    public void domainDelete(int domainId) throws BGException, BGMessageException {
        try (DomainManager domainManager = new DomainManager(this.getConnection(), this.moduleId);){
            Domain domain = domainManager.get(domainId);
            domainManager.delete(domainId);
            domainManager.getServiceActivator(domain).removeDomain(domain);
        }
    }

    public int domainUpdate(Domain domain) throws BGException, BGMessageException {
        if (domain != null && Utils.isBlankString((String)domain.getName())) {
            throw new BGMessageException("\u041f\u043e\u043b\u0435 '\u0434\u043e\u043c\u0435\u043d' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.");
        }
        try (DomainManager domainManager = new DomainManager(this.getConnection(), this.moduleId);){
            domainManager.update(domain);
            domainManager.list(null).forEach(d -> {
                try {
                    domainManager.getServiceActivator((Domain)d).updateDomain((Domain)d);
                }
                catch (Exception ex) {
                    this.getLogger().error((Object)ex);
                }
            });
        }
        return domain.getId();
    }

    public List<Domain> domainList() throws BGException, BGMessageException {
        try (DomainManager domainManager = new DomainManager(this.getConnection(), this.moduleId);){
            List<Domain> list = domainManager.list(null);
            return list;
        }
    }
}

