/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.tasks;

import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.drwebn.server.mail.MailTaskRecalculator;
import ru.bitel.bgbilling.modules.drwebn.server.tasks.Calculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class Recalculator
extends RunTaskRecalculator<Calculator> {
    private String cids;
    private String comment = null;

    public Recalculator(int mid, Calendar dt, String cids, String email, String comment) {
        GregorianCalendar now = new GregorianCalendar();
        if (now.get(1) == dt.get(1) && now.get(2) == dt.get(2)) {
            dt = now;
        } else {
            dt.set(5, dt.getMaximum(5));
        }
        this.mid = mid;
        this.dt = dt;
        this.email = email;
        this.cids = cids;
        this.comment = comment;
    }

    protected void executeTask() {
        long start = System.currentTimeMillis();
        this.getLogger().info("PaymentRecalculator time: " + TimeUtils.format((Calendar)this.dt, (String)"dd.MM.yyyy HH"));
        Calculator calculator = this.createTask();
        calculator.startTask();
        long end = System.currentTimeMillis();
        if (this.email != null) {
            StringBuffer report = new StringBuffer("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 Dr.Web \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e\n").append("\u0412\u0440\u0435\u043c\u044f: ").append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
            try {
                new MailMsg((Preferences)this.setup).sendMessage(new MailTaskRecalculator().setModuleId(this.mid).setRecipients(this.email).setSubject("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 Dr.Web \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e").addTextPart("text", report.toString()));
            }
            catch (Exception ex) {
                this.getLogger().error((Object)ex);
            }
        }
    }

    protected Calculator createTask() {
        Calculator calculator = new Calculator();
        calculator.setExecutingTime(this.dt);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid + "\ncomment=" + this.comment);
        calculator.setCids(this.cids);
        calculator.setMonthMode(true);
        return calculator;
    }
}

