/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.servlet;

import jakarta.mail.internet.MimeUtility;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentDao;
import ru.bitel.bgbilling.plugins.documents.server.filestorage.DocumentsFileStorage;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebServlet(name="documentsExecutor", urlPatterns={"/docs/*"})
public class DocumentsExecutor
extends CommonExecutor {
    private static final Logger logger = LogManager.getLogger();

    public void init() throws ServletException {
        super.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String[] parts = request.getPathInfo().split("-");
        if (parts.length != 4) {
            String msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 - " + request.getPathInfo();
            logger.error(msg);
            response.sendError(400, msg);
            return;
        }
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();
             DocumentDao documentDao = new DocumentDao(con);){
            List files;
            String[] ids = parts[0].substring(1).split(":");
            if (ids.length < 1) {
                String msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 - " + parts[0];
                logger.error(msg);
                response.sendError(400, msg);
                return;
            }
            int docId = Utils.parseInt((String)ids[0], (int)-1);
            long linkCreateTime = Utils.parseLong((String)parts[1], (long)-1L);
            long linkLeastTime = Utils.parseInt((String)parts[2], (int)-1);
            LocalDateTime checkTime = LocalDateTime.ofEpochSecond(linkCreateTime + linkLeastTime, 0, OffsetDateTime.now().getOffset());
            if (linkLeastTime != 0L && checkTime.isBefore(LocalDateTime.now())) {
                String msg = "\u0421\u0441\u044b\u043b\u043a\u0430 \u0443\u0441\u0442\u0430\u0440\u0435\u043b\u0430 [\u0434\u043e " + TimeUtils.format((LocalDateTime)checkTime, (String)"dd.MM.yyyy HH:mm:ss") + "]";
                logger.error(msg);
                response.sendError(400, msg);
                return;
            }
            StringBuilder link = new StringBuilder(String.valueOf(docId));
            if (ids.length > 1) {
                int len = ids.length;
                for (int i = 1; i < len; ++i) {
                    link.append(":").append(ids[i]);
                }
            }
            link.append("-").append(linkCreateTime);
            link.append("-").append(linkLeastTime);
            Document document = documentDao.getDocument(docId);
            if (document == null || document.getFileSecret() == null) {
                String msg = "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d [#" + docId + "]";
                logger.error(msg);
                response.sendError(400, msg);
                return;
            }
            if (!parts[3].equals(Utils.getDigest((String)(link.toString() + document.getFileSecret()), (String)"UTF-8", (String)"SHA256").toLowerCase())) {
                String msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0438";
                logger.error(msg);
                response.sendError(400, msg);
                return;
            }
            DocumentsFileStorage fileStorage = new DocumentsFileStorage(con);
            if (ids.length == 1 && (files = fileStorage.getFilesListByOwner(docId)) != null && !files.isEmpty()) {
                int i = 1;
                ids = new String[files.size() + 1];
                ids[0] = String.valueOf(docId);
                for (BGServerFile bgServerFile : files) {
                    ids[i++] = String.valueOf(bgServerFile.getId());
                }
            }
            logger.debug("ids.length = {}", (Object)ids.length);
            if (ids.length == 2) {
                logger.debug("ids[1] = {}", (Object)ids[1]);
                int id = Utils.parseInt((String)ids[1]);
                BGServerFile serverFile = fileStorage.getFileById(id);
                if (serverFile == null) return;
                response.setContentType("application/octet-stream");
                response.setContentLengthLong(serverFile.getSize());
                response.setHeader("Content-Disposition", "attachment; filename=\"" + MimeUtility.encodeText((String)serverFile.getTitle(), (String)"utf8", (String)"B") + "\"");
                ServletOutputStream outputStream = response.getOutputStream();
                fileStorage.loadStream(id, (OutputStream)outputStream);
                outputStream.close();
                return;
            }
            Path path = Files.createTempFile("bg", "documents.file", new FileAttribute[0]);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(path.toFile()));
            int len = ids.length;
            for (int i = 1; i < len; ++i) {
                logger.debug("ids[{}] = {}", (Object)i, (Object)ids[i]);
                int id = Utils.parseInt((String)ids[i]);
                BGServerFile serverFile = fileStorage.getFileById(id);
                if (serverFile == null) continue;
                zipOutputStream.putNextEntry(new ZipEntry(serverFile.getTitle()));
                fileStorage.loadStream(id, zipOutputStream);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            response.setContentType("application/octet-stream");
            response.setContentLengthLong(Files.size(path));
            response.setHeader("Content-Disposition", "attachment; filename=\"" + MimeUtility.encodeText((String)(document.getTitle() + ".zip"), (String)"utf8", (String)"B") + "\"");
            ServletOutputStream outputStream = response.getOutputStream();
            Files.copy(path, (OutputStream)outputStream);
            outputStream.close();
            Files.deleteIfExists(path);
            return;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            response.sendError(500, ex.getMessage());
        }
    }
}

