/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.client;

import bitel.billing.module.common.CalendarDialog;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Page;

public class SPP_ConnectLog
extends ServicePanel {
    private Calendar date = null;
    private JLabel allRecordLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 - 0");
    private JPanel tablePanel = null;
    private CardLayout cardLayout = new CardLayout();
    private BGTable sessionTable = new BGTable();
    private BGTable errorTable = new BGTable();
    private BGButton dayButton = new BGButton();
    private BGButton addDayButton = new BGButton();
    private BGButton decDayButton = new BGButton();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JToggleButton sessionButton = new JToggleButton("\u0421\u0435\u0441\u0441\u0438\u0438", true);
    private JToggleButton errorAllButton = new JToggleButton("\u041e\u0448\u0438\u0431\u043a\u0438 (\u0432\u0441\u0435)");
    private JToggleButton errorLoginButton = new JToggleButton("\u041e\u0448\u0438\u0431\u043a\u0438 (\u043b\u043e\u0433\u0438\u043d)");
    private BGControlPanelPages pageControlPanel = new BGControlPanelPages();

    public SPP_ConnectLog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pageControlPanel.setKey(SPP_ConnectLog.class.getName());
        this.pageControlPanel.init();
        this.pageControlPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName != null && propertyName.startsWith("to")) {
                    SPP_ConnectLog.this.setData();
                }
            }
        });
        this.buttonGroup.add(this.errorAllButton);
        this.buttonGroup.add(this.errorLoginButton);
        this.buttonGroup.add(this.sessionButton);
        this.errorAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SPP_ConnectLog.this.showErrors();
            }
        });
        this.errorLoginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SPP_ConnectLog.this.showErrors();
            }
        });
        this.sessionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SPP_ConnectLog.this.showSessions();
            }
        });
        this.date = new GregorianCalendar();
        TimeUtils.clearCalendarHour((Calendar)this.date);
        this.dayButton.putClientProperty((Object)"date", (Object)this.date);
        this.dayButton.setText(TimeUtils.format((Calendar)this.date, (String)"dd.MM.yyyy"));
        this.dayButton.setToolTipText("\u0432\u044b\u0431\u043e\u0440 \u0441\u0443\u0442\u043e\u043a");
        this.dayButton.setMargin(new Insets(2, 2, 2, 2));
        this.dayButton.setSelected(false);
        this.dayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SPP_ConnectLog.this.bGButton1_actionPerformed(e);
            }
        });
        this.decDayButton.setIcon((Icon)ClientUtils.getIcon((String)"to_prev.gif"));
        this.decDayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SPP_ConnectLog.this.date.add(5, -1);
                SPP_ConnectLog.this.dayButton.setText(TimeUtils.format((Calendar)SPP_ConnectLog.this.date, (String)"dd.MM.yyyy"));
                SPP_ConnectLog.this.setPeriod(SPP_ConnectLog.this.date);
                SPP_ConnectLog.this.setData();
            }
        });
        this.addDayButton.setIcon((Icon)ClientUtils.getIcon((String)"to_next.gif"));
        this.addDayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SPP_ConnectLog.this.date.add(5, 1);
                SPP_ConnectLog.this.dayButton.setText(TimeUtils.format((Calendar)SPP_ConnectLog.this.date, (String)"dd.MM.yyyy"));
                SPP_ConnectLog.this.setPeriod(SPP_ConnectLog.this.date);
                SPP_ConnectLog.this.setData();
            }
        });
        this.errorTable.setHeader(this.rb_name, this.moduleDoc, "error");
        this.sessionTable.setHeader(this.rb_name, this.moduleDoc, "logs");
    }

    public void init(JFrame parentFrame, String module, int mid, int cid, int id, int objectId) {
        this.init(parentFrame, module, mid, cid, id, objectId);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.topPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.tablePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private JPanel topPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel modePanel = new JPanel(new GridBagLayout());
        modePanel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0436\u0438\u043c"));
        modePanel.add((Component)this.sessionButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        modePanel.add((Component)this.errorAllButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        modePanel.add((Component)this.errorLoginButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        JPanel periodPanel = new JPanel(new GridBagLayout());
        periodPanel.setBorder((Border)new BGTitleBorder("\u041f\u0435\u0440\u0438\u043e\u0434"));
        periodPanel.add((Component)this.decDayButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        periodPanel.add((Component)this.dayButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        periodPanel.add((Component)this.addDayButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        JPanel pagePanel = new JPanel(new GridBagLayout());
        pagePanel.setBorder((Border)new BGTitleBorder("\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430"));
        pagePanel.add((Component)this.pageControlPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.allRecordLabel.setFont(new Font("Dialog", 1, 14));
        panel.add((Component)modePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.allRecordLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 3, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)pagePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPanel tablePanel() {
        this.tablePanel = new JPanel(this.cardLayout);
        this.tablePanel.add((Component)new JScrollPane((Component)this.sessionTable), "session");
        this.tablePanel.add((Component)new JScrollPane((Component)this.errorTable), "error");
        return this.tablePanel;
    }

    private void bGButton1_actionPerformed(ActionEvent e) {
        Calendar date2 = (Calendar)this.dayButton.getClientProperty((Object)"date");
        CalendarDialog dialog = new CalendarDialog();
        dialog.setCalendar(date2);
        if (dialog.showDialog().equals("ok")) {
            date2 = dialog.getCalendar();
            if (date2 == null) {
                date2 = new GregorianCalendar();
                date2.add(5, -2);
                TimeUtils.clearCalendarHour((Calendar)date2);
            }
            this.dayButton.setText(TimeUtils.format((Calendar)date2, (String)"dd.MM.yyyy"));
        }
        this.setPeriod(date2);
    }

    private void setPeriod(Calendar date) {
        this.date = date;
        this.pageControlPanel.init();
        this.setData();
    }

    private void showErrors() {
        this.cardLayout.show(this.tablePanel, "error");
        this.setData();
    }

    private void showSessions() {
        this.cardLayout.show(this.tablePanel, "session");
        this.setData();
    }

    public boolean updateData() {
        return true;
    }

    public void setData() {
        this.fl = true;
        if (this.sessionButton.isSelected()) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetLogAndError");
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setPageIndex(this.pageControlPanel.getPageIndex());
            request.setPageSize(this.pageControlPanel.getPageSize());
            request.setAttribute("lid", String.valueOf(this.id));
            request.setAttribute("mode", "logs");
            request.setAttribute("date", TimeUtils.format((Calendar)this.date, (String)"dd.MM.yyyy HH:mm"));
            this.setDocument(this.getDocument(request));
        } else if (this.errorAllButton.isSelected()) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetLogAndError");
            request.setModuleId(this.getModuleId());
            request.setPageIndex(this.pageControlPanel.getPageIndex());
            request.setPageSize(this.pageControlPanel.getPageSize());
            request.setAttribute("mode", "error");
            request.setAttribute("date", TimeUtils.format((Calendar)this.date, (String)"dd.MM.yyyy HH:mm"));
            this.setDocument(this.getDocument(request));
        } else if (this.errorLoginButton.isSelected()) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetLogAndError");
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setPageIndex(this.pageControlPanel.getPageIndex());
            request.setPageSize(this.pageControlPanel.getPageSize());
            request.setAttribute("lid", String.valueOf(this.id));
            request.setAttribute("mode", "error");
            request.setAttribute("date", TimeUtils.format((Calendar)this.date, (String)"dd.MM.yyyy HH:mm"));
            this.setDocument(this.getDocument(request));
        }
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            Element table = (Element)XMLUtils.getNode((Document)doc, (String)"table");
            this.pageControlPanel.setPageInfo(table);
            this.allRecordLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 - " + Page.getRecordCount((Element)table));
            if (this.sessionButton.isSelected()) {
                this.sessionTable.updateData((Node)table);
            } else if (this.errorAllButton.isSelected() || this.errorLoginButton.isSelected()) {
                this.errorTable.updateData((Node)table);
            }
        }
    }
}

