/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.tariff;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.common.Utils;

public class PacketSetFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private Set<Integer> packets = new HashSet<Integer>();
    private int andornotModeValue = 1;
    private boolean on_contract_total = false;

    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map hashData = this.getDataInHash();
        String packets = (String)hashData.get("packets");
        if (Utils.notBlankString((String)packets)) {
            this.packets.addAll(Utils.toIntegerList((String)packets));
        }
        this.andornotModeValue = Utils.parseInt((String)((String)hashData.get("andornot_mode")), (int)-1);
        this.on_contract_total = Utils.parseBoolean((String)((String)hashData.get("on_contract_total")));
    }

    public void processRequest(TariffRequest request) {
        List _curr_card_packets = (List)request.getRequestParam("packet_list");
        if (this.on_contract_total) {
            _curr_card_packets = (List)request.getRequestParam("packet_list_oncontract");
        }
        if (_curr_card_packets != null) {
            HashSet<Integer> curr_card_packets = new HashSet<Integer>();
            for (Packet c : _curr_card_packets) {
                curr_card_packets.add(c.getId());
            }
            boolean check = false;
            switch (this.andornotModeValue) {
                case 1: {
                    check = curr_card_packets.containsAll(this.packets);
                    System.out.println("AND: 1) subscr packs: " + curr_card_packets + "; 2) tariff packs: " + this.packets + "; 1 contains all 2: " + check);
                    break;
                }
                case 2: {
                    check = !Collections.disjoint(curr_card_packets, this.packets);
                    System.out.println("OR: 1) subscr packs: " + curr_card_packets + "; 2) tariff packs: " + this.packets + "; 1 intersects 2: " + check);
                    break;
                }
                case 3: {
                    check = !curr_card_packets.containsAll(this.packets);
                    System.out.println("NOT-AND: 1) subscr packs: " + curr_card_packets + "; 2) tariff packs: " + this.packets + "; not (1 contains all 2): " + check);
                    break;
                }
                case 4: {
                    check = Collections.disjoint(curr_card_packets, this.packets);
                    System.out.println("NOT-OR: 1) subscr packs: " + curr_card_packets + "; 2) tariff packs: " + this.packets + "; 1 no intersects 2: " + check);
                }
            }
            if (check) {
                this.processForChilds(request);
            }
        }
    }
}

