/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ActionDealerPaymentList
extends ActionBase {
    public void doAction() throws SQLException {
        DecimalFormat df = new DecimalFormat("########0.00");
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        int mid = this.getIntParameter("mid", -1);
        String format = this.getParameter("format", "list");
        if (format != null && "list".equalsIgnoreCase(format)) {
            Date date = new Date();
            Date date1 = this.getDateParameter("date1", date);
            Date date2 = this.getDateParameter("date2", date);
            Integer dealerId = (Integer)this.session.getAttribute("user_id");
            List<Integer> paymentIds = null;
            if (dealerId > 0) {
                paymentIds = this.getPaymentIds(mid, dealerId);
            }
            Element payments = this.createElement(this.rootNode, "payments");
            if (paymentIds != null && paymentIds.size() > 0) {
                int index = 1;
                float summa = 0.0f;
                String query = "SELECT t1.id, dt, t2.title, summa, t1.comment FROM contract_payment as t1, contract as t2 WHERE t1.cid=t2.id AND pt IN ( " + Utils.toString(paymentIds) + " ) AND dt>=? AND dt<=? ORDER BY t1.id";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date1));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date2));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    float sum = rs.getFloat(4);
                    Element payment = this.createElement(payments, "payment");
                    payment.setAttribute("id", rs.getString(1));
                    payment.setAttribute("dt", sdf.format(rs.getDate(2)));
                    payment.setAttribute("title", rs.getString(3));
                    payment.setAttribute("summa", df.format(sum));
                    payment.setAttribute("comment", rs.getString(5));
                    summa += sum;
                }
                rs.close();
                ps.close();
                payments.setAttribute("summa", df.format(summa));
                payments.setAttribute("date1", TimeUtils.formatDate((Date)date1));
                payments.setAttribute("date2", TimeUtils.formatDate((Date)date2));
            }
        } else {
            Page page = this.getPage();
            Period period = this.getPeriod();
            int did = this.getIntParameter("did", 0);
            List<Integer> paymentIds = null;
            if (did > 0) {
                paymentIds = this.getPaymentIds(mid, did);
            }
            Element table = this.createElement(this.rootNode, "table");
            Element data = this.createElement(table, "data");
            if (paymentIds != null && paymentIds.size() > 0) {
                String ptInValues = Utils.toString(paymentIds);
                int index = 1;
                String query = "SELECT t1.id, t2.title, t2.comment, dt, summa, t3.title, t1.comment FROM contract_payment as t1, contract as t2, contract_payment_types as t3 WHERE t1.cid=t2.id AND t1.pt=t3.id AND pt IN ( " + ptInValues + " )" + (period.getDateFrom() != null ? " AND dt>=?" : "") + (period.getDateTo() != null ? " AND dt<=?" : "") + " ORDER BY dt" + page.sqlLimit();
                PreparedStatement ps = this.con.prepareStatement(query);
                if (period.getDateFrom() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    Element row = this.createElement(data, "row");
                    row.setAttribute("f0", rs.getString("t1.id"));
                    row.setAttribute("f1", rs.getString("t2.title"));
                    row.setAttribute("f2", rs.getString("t2.comment"));
                    row.setAttribute("f3", sdf.format(rs.getDate("dt")));
                    row.setAttribute("f4", df.format(rs.getFloat("summa")));
                    row.setAttribute("f5", rs.getString("t3.title"));
                    row.setAttribute("f6", rs.getString("t1.comment"));
                }
                rs.close();
                ps.close();
                index = 1;
                int records = 0;
                float summa = 0.0f;
                query = "SELECT count(*), sum(summa) FROM contract_payment WHERE pt IN ( " + ptInValues + " )" + (period.getDateFrom() != null ? " AND dt>=?" : "") + (period.getDateTo() != null ? " AND dt<=?" : "");
                ps = this.con.prepareStatement(query);
                if (period.getDateFrom() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    records = rs.getInt(1);
                    summa = rs.getFloat(2);
                }
                rs.close();
                ps.close();
                page.setRecordCount(records);
                table.setAttribute("summa", df.format(summa));
                table.setAttribute("allRecord", String.valueOf(records));
                this.setPageAttribute(table, page);
            }
        }
    }

    private List<Integer> getPaymentIds(int mid, int id) throws SQLException {
        List list = null;
        String tableName = "card_dealer_" + mid;
        if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
            String query = "SELECT pt FROM " + tableName + " WHERE id=" + id;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                list = Utils.toIntegerList((String)rs.getString(1));
            }
            rs.close();
            st.close();
        }
        return list;
    }
}

