/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelContractTariff;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;

public class RunTelContractTariffDao
extends AbstractIdDao<RunTelContractTariff> {
    public RunTelContractTariffDao(Connection con, int moduleId) {
        super(con, moduleId, "runtel_tariff_contract");
    }

    public List<RunTelContractTariff> getRunTelContractTariffs(LocalDateTime date) throws BGException {
        Timestamp timestamp = Timestamp.valueOf(date);
        return this.list("((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "id", new Object[]{timestamp, timestamp});
    }

    public List<RunTelContractTariff> getRunTelContractTariffs(Period period) throws BGException {
        Date sqlDateFrom = TimeUtils.convertDateToSqlDate((java.util.Date)period.getDateFrom());
        if (period.getDateTo() == null) {
            return this.list("( `date_to` IS NULL OR `date_to` >= ? )", "id", new Object[]{sqlDateFrom});
        }
        Date sqlDateTo = TimeUtils.convertDateToSqlDate((java.util.Date)period.getDateTo());
        return this.list("((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "id", new Object[]{sqlDateTo, sqlDateFrom});
    }

    public List<RunTelContractTariff> getRunTelContractTariffs(int contractId, PeriodWithTime period) throws BGException {
        if (period == null) {
            period = new PeriodWithTime();
        }
        Date sqlDateFrom = TimeUtils.convertDateToSqlDate((java.util.Date)period.getDateFrom());
        Date sqlDateTo = TimeUtils.convertDateToSqlDate((java.util.Date)period.getDateTo());
        if (period.getDateFrom() == null && period.getDateTo() == null) {
            return this.list("contract_id=?", "date_from", new Object[]{contractId});
        }
        if (period.getDateTo() == null) {
            return this.list("contract_id=? AND ( `date_to` IS NULL OR `date_to` >= ? )", "date_from", new Object[]{contractId, sqlDateFrom});
        }
        if (period.getDateFrom() == null) {
            return this.list("contract_id=? AND ( `date_from` IS NULL OR `date_from` <= ? )", "date_from", new Object[]{contractId, sqlDateTo});
        }
        return this.list("contract_id=? AND ((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "date_from", new Object[]{contractId, sqlDateTo, sqlDateFrom});
    }

    public LocalDateTime getOnDate(int contractId) throws BGException {
        LocalDateTime dateTime = null;
        List contractTariffs = this.list("contract_id=? AND ( `date_to` IS NULL OR `date_to` >= CURDATE() )", "date_from", new Object[]{contractId});
        if (!contractTariffs.isEmpty()) {
            dateTime = ((RunTelContractTariff)contractTariffs.get(0)).getPeriod().getLocalDateTimeFrom();
        } else {
            contractTariffs = this.list("contract_id=?", "date_from", new Object[]{contractId});
            if (!contractTariffs.isEmpty()) {
                dateTime = ((RunTelContractTariff)contractTariffs.get(contractTariffs.size() - 1)).getPeriod().getLocalDateTimeFrom();
            }
        }
        return dateTime;
    }

    public RunTelContractTariff get(int contractId, LocalDate date) throws BGException {
        try {
            Date sqlDate = Date.valueOf(date);
            List list = this.list("contract_id=? AND  ((`date_from` IS NULL OR `date_from` <= ?) AND (`date_to` IS NULL OR `date_to` >= ?) )", "id", new Object[]{contractId, sqlDate, sqlDate});
            return list.isEmpty() ? null : (RunTelContractTariff)list.get(0);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        return super.delete("id=? AND date_from > CURDATE()", new Object[]{id});
    }

    protected RunTelContractTariff getFromRS(ResultSet rs) throws SQLException, BGException {
        RunTelContractTariff runTelContractTariff = new RunTelContractTariff();
        runTelContractTariff.setId(rs.getInt("id"));
        runTelContractTariff.setContractId(rs.getInt("contract_id"));
        runTelContractTariff.setTariffId(rs.getInt("tariff_id"));
        runTelContractTariff.setPeriod(new PeriodWithTime((java.util.Date)rs.getTimestamp("date_from"), (java.util.Date)rs.getTimestamp("date_to")));
        runTelContractTariff.setConfig(rs.getString("config"));
        return runTelContractTariff;
    }

    protected void updateImpl(RunTelContractTariff runTelContractTariff) throws BGException, SQLException {
        boolean insert = runTelContractTariff.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET contract_id=?, tariff_id=?, date_from=?, date_to=?, config=?" + (insert ? "" : " WHERE id=?");
        int parameterIndex = 1;
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        ps.setInt(parameterIndex++, runTelContractTariff.getContractId());
        ps.setInt(parameterIndex++, runTelContractTariff.getTariffId());
        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((java.util.Date)runTelContractTariff.getPeriod().getDateFrom()));
        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((java.util.Date)runTelContractTariff.getPeriod().getDateTo()));
        ps.setString(parameterIndex++, runTelContractTariff.getConfig());
        if (!insert) {
            ps.setInt(parameterIndex++, runTelContractTariff.getId());
        }
        ps.executeUpdate();
        if (insert) {
            runTelContractTariff.setId(ServerUtils.lastInsertId((Connection)this.con));
        }
        ps.close();
    }

    public void updateDateTo(int contractTariffId, LocalDateTime dateTo) throws BGException, SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET date_to=?  WHERE id=?");){
            int parameterIndex = 1;
            ps.setTimestamp(parameterIndex++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)dateTo));
            ps.setInt(parameterIndex++, contractTariffId);
            ps.executeUpdate();
        }
    }

    public Map<Integer, RunTelContractTariff> getLastRunTelContractTariffs() throws BGException {
        RunTelContractTariff tariff;
        ResultSet rs;
        int index;
        PreparedStatement ps;
        LocalDate now = LocalDate.now();
        HashMap<Integer, RunTelContractTariff> tariffMap = new HashMap<Integer, RunTelContractTariff>();
        String query = "SELECT * FROM " + this.tableName + " INNER JOIN (SELECT contract_id, max(date_to) as date_to FROM " + this.tableName + " WHERE date_to is not null AND date_from < ? GROUP BY contract_id ) latest USING ( contract_id, date_to )";
        try {
            ps = this.con.prepareStatement(query);
            try {
                index = 1;
                ps.setTimestamp(index, TimeUtils.convertLocalDateToTimestamp((LocalDate)now));
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        tariff = this.getFromRS(rs);
                        tariffMap.put(tariff.getContractId(), tariff);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        query = "SELECT * FROM " + this.tableName + " WHERE date_to is null AND date_from < ?";
        try {
            ps = this.con.prepareStatement(query);
            try {
                index = 1;
                ps.setTimestamp(index, TimeUtils.convertLocalDateToTimestamp((LocalDate)now));
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        tariff = this.getFromRS(rs);
                        tariffMap.put(tariff.getContractId(), tariff);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return tariffMap;
    }
}

