/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.task;

import java.time.LocalDate;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractService;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallment;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallmentStatus;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMCalculatorUtils;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMContractServiceManager;
import ru.bitel.bgbilling.modules.rscm.server.event.RSCMContractServiceUpdateEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.sql.ConnectionSet;

public class RSCMInstallmentTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
             BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());
             BalanceUtils balanceUtils = new BalanceUtils(connectionSet.getConnection());
             RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(connectionSet.getConnection(), this.moduleId);){
            for (RSCMContractServiceInstallment contractServiceInstallment : rscmContractServiceManager.getContractServiceInstallmentList()) {
                JSONArray contractServiceIds;
                boolean amountLast;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)contractServiceInstallment);
                }
                if (!contractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.NEW) && !contractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.IN_PROGRESS)) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("status {} -> SKIP", (Object)contractServiceInstallment.getStatus());
                    continue;
                }
                LocalDate dateNext = contractServiceInstallment.getDateNext();
                if (dateNext == null || dateNext.isAfter(LocalDate.now())) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("next date {} -> SKIP", (Object)dateNext);
                    continue;
                }
                JSONObject jsonObject = new JSONObject(contractServiceInstallment.getInstallment());
                JSONArray paymentsArray = jsonObject.optJSONArray("paymentsArray");
                int number = contractServiceInstallment.getPaymentCount() + 1;
                int amountDown = contractServiceInstallment.getAmountDown();
                if (amountDown == 0) {
                    amountDown = 100;
                }
                int amountUp = paymentsArray.getInt(number - 1) * contractServiceInstallment.getAmountUp() / amountDown;
                boolean bl = amountLast = number == paymentsArray.length();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("number = {}; amountUp = {}; amountDown = {}; amountLast = {}", (Object)number, (Object)amountUp, (Object)amountDown, (Object)amountLast);
                }
                RSCMContractService contractService = RSCMContractService.builder().setContractId(contractServiceInstallment.getContractId()).setServiceId(contractServiceInstallment.getServiceId()).setInstallmentId(contractServiceInstallment.getId()).setDate(dateNext).setAmountUp(amountUp).setAmountDown(amountDown).setLast(amountLast).setComment(String.format("\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430. \u0412\u0437\u043d\u043e\u0441 [\u0447\u0430\u0441\u0442\u0435\u0439: %s/%s] => %s \u0438\u0437 %s ", amountUp, amountDown, number, paymentsArray.length())).build();
                rscmContractServiceManager.updateContractService(contractService);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("number = {}; paymentsArray.length() = {}", (Object)number, (Object)paymentsArray.length());
                }
                contractServiceInstallment.setPaymentCount(number);
                contractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.IN_PROGRESS);
                if (number == paymentsArray.length()) {
                    contractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.COMPLETED);
                    contractServiceInstallment.setDateNext(null);
                } else {
                    String paymentMode = jsonObject.optString("paymentMode", "month");
                    contractServiceInstallment.setDateNext(RSCMCalculatorUtils.getInstallmentPaymentNextDate(dateNext, paymentMode));
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("set status = {}", (Object)contractServiceInstallment.getStatus());
                    this.getLogger().debug("set next date = {}", (Object)contractServiceInstallment.getDateNext());
                }
                if ((contractServiceIds = jsonObject.optJSONArray("contractServiceIds")) == null) {
                    contractServiceIds = new JSONArray();
                    jsonObject.put("contractServiceIds", (Object)contractServiceIds);
                }
                contractServiceIds.put(contractService.getId());
                contractServiceInstallment.setInstallment(jsonObject.toString());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("installment = {}", (Object)contractServiceInstallment.getInstallment());
                }
                rscmContractServiceManager.updateRSCMContractServiceInstallment(contractServiceInstallment);
                EventProcessor.getInstance().publish((Event)new RSCMContractServiceUpdateEvent(0, this.moduleId, contractService.getContractId(), contractService));
                rscmContractServiceManager.hotCalc(contractService.getContractId(), contractService.getDate(), connectionSet);
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
            this.error = e;
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c RSCM. \u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430, \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0435\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }
}

