/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rentsoft.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftProduct;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class RentsoftProductManager
extends AbstractIdDao<RentsoftProduct> {
    public RentsoftProductManager(Connection con, int mid) {
        super(con, mid, "rentsoft_product");
    }

    public List<RentsoftProduct> getList() throws BGException {
        return this.list("", "serviceName", new Object[0]);
    }

    protected void updateImpl(RentsoftProduct b) throws BGException, SQLException {
        String query = null;
        PreparedStatement ps = null;
        query = b.getId() <= 0 ? "INSERT INTO " + this.tableName + "(serviceKey, serviceName) VALUES(?,?)" : "UPDATE " + this.tableName + " SET serviceKey=?, serviceName=? WHERE id=?";
        ps = this.con.prepareStatement(query, 1);
        ps.setString(1, b.getServiceKey());
        ps.setString(2, b.getServiceName());
        if (b.getId() > 0) {
            ps.setInt(3, b.getId());
        }
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
    }

    protected RentsoftProduct getFromRS(ResultSet rs) throws SQLException, BGException {
        RentsoftProduct result = new RentsoftProduct();
        result.setId(rs.getInt("id"));
        result.setServiceKey(rs.getString("serviceKey"));
        result.setServiceName(rs.getString("serviceName"));
        return result;
    }

    public RentsoftProduct getByServiceKey(String serviceKey) {
        RentsoftProduct result = null;
        try {
            result = (RentsoftProduct)this.get("serviceKey=?", new Object[]{serviceKey});
        }
        catch (BGException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void safeUpdate(RentsoftProduct product) {
        try {
            this.update(product);
        }
        catch (BGException e) {
            e.printStackTrace();
        }
    }
}

