/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductHistory;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.bgbilling.modules.megafon.server.MegafonCheckOrderStatus;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiClient;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonKassaApiClient;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractOptionDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractProductDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractProductHistoryDao;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService")
public class MegafonContractServiceImpl
extends AbstractService
implements MegafonContractService {
    private MegafonContractProductDao contractProductDao;
    private MegafonContractProductHistoryDao productHistoryDao;

    @PostConstruct
    public void init() {
        this.contractProductDao = new MegafonContractProductDao(this.getConnection(), this.moduleId);
        this.productHistoryDao = new MegafonContractProductHistoryDao(this.getConnection(), this.moduleId);
    }

    public SearchResult<MegafonContractProduct> getContractProductList(Page page, int contractId, MegafonContractProductStatus status) throws Exception {
        if (page == null) {
            page = new Page();
        }
        StringBuilder filter = new StringBuilder(contractId > 0 ? "contract_id=?" : "");
        filter.append(status != null ? " AND status=?" : "");
        Result<MegafonContractProduct> result = this.contractProductDao.list(page, filter.toString(), "id", contractId, status != null ? Integer.valueOf(status.ordinal()) : null);
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(result.getPage());
        searchResult.setList(result.getList());
        return searchResult;
    }

    public boolean checkActiveProductOnContracts(int productId) throws Exception {
        return this.contractProductDao.list(new Page(), "product_id=? AND status=?", "id", productId, MegafonContractProductStatus.ACTIVE.ordinal()).getList().size() > 0;
    }

    public SearchResult<MegafonContractProductHistory> getHistoryList(Page page, int contractId, String msisdn, int productId, String productTitle, Period period) throws Exception {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder filter = new StringBuilder();
        if (contractId > 0) {
            filter.append("contract_id=?");
            parameters.add(contractId);
        }
        if (Utils.notBlankString((String)msisdn)) {
            filter.append("msisdn=?");
            parameters.add(msisdn);
        }
        if (productId > 0) {
            filter.append("product_id=?");
            parameters.add(productId);
        }
        if (Utils.notBlankString((String)productTitle)) {
            filter.append("LIKE '%?%'");
            parameters.add(productTitle);
        }
        if (period != null) {
            if (period.getDateFrom() != null) {
                filter.append(" AND date_from>=?");
                parameters.add(period.getDateFrom());
            }
            if (period.getDateTo() != null) {
                filter.append(" AND date_to<=?");
                parameters.add(period.getDateTo());
            }
        }
        if (page == null) {
            page = new Page();
        }
        Result<MegafonContractProductHistory> result = this.productHistoryDao.list(page, filter.toString(), "id", parameters.toArray());
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(result.getPage());
        searchResult.setList(result.getList());
        return searchResult;
    }

    public boolean checkAllowActivateProduct(MegafonContractProduct contractProduct) throws Exception {
        if (contractProduct.getStartTime() == null) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435!");
        }
        if (Utils.isBlankString((String)contractProduct.getMsisdn())) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: msisdn");
        }
        if (contractProduct.getTariffId() <= 0) {
            throw new BGException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u0430\u0440\u0438\u0444!");
        }
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        MegafonProduct product = megafonService.getProduct(contractProduct.getProductId());
        if (product == null) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID = " + contractProduct.getProductId());
        }
        MegafonApiClient apiClient = new MegafonApiClient(this.context.getModuleId());
        this.checkAlreadyActivatedProduct(apiClient, contractProduct, product.getProductOfferingId());
        if (this.checkBalance(product, contractProduct.getContractId())) {
            throw new RuntimeException(String.format("\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 CID=%s. \u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 ID:%s = %s.", contractProduct.getContractId(), product.getId(), product.getPrice()));
        }
        return apiClient.checkActivateProduct(contractProduct.getMsisdn(), product.getProductOfferingId(), contractProduct.getStartTime());
    }

    private void checkAlreadyActivatedProduct(MegafonApiClient apiClient, MegafonContractProduct contractProduct, String uuid) {
        boolean isTestWorkMode = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).getInt("megafon.work.mode", 2) == 2;
        JSONArray tariffs = apiClient.getTariffInfo(contractProduct.getMsisdn());
        for (int i = 0; i < tariffs.length(); ++i) {
            String dateTo;
            Date deactivateDate;
            JSONObject tariff = tariffs.optJSONObject(i);
            long productOfferingId = tariff.optLong("productOfferingId");
            if (productOfferingId != Utils.parseLong((String)uuid) || (deactivateDate = TimeUtils.parseDate((String)(dateTo = tariff.optJSONObject("activationPeriod").optString("dateTo")), (String)"yyyy-MM-dd'T'HH:mm:ss")) == null || !deactivateDate.after(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)contractProduct.getStartTime())) || isTestWorkMode) continue;
            throw new RuntimeException(String.format("\u041d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 = %s \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 productOfferingId = %s", contractProduct.getContractId(), uuid));
        }
    }

    public void contractProductUpdate(MegafonContractProduct contractProduct) throws Exception {
        LocalDateTime startDate = contractProduct.getStartTime();
        if (startDate == null) {
            throw new BGException("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430!");
        }
        if (!contractProduct.getStartTime().toLocalDate().isBefore(LocalDate.now())) {
            throw new BGException("\u0414\u0430\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u043e\u0448\u043b\u043e\u043c!");
        }
        if (contractProduct.getStartTime().toLocalDate().isEqual(LocalDate.now())) {
            this.productActivateRequest(contractProduct);
        } else {
            this.contractProductDao.update(contractProduct);
        }
    }

    public void productActivateRequest(MegafonContractProduct megafonContractProduct) throws Exception {
        if (megafonContractProduct.getStatus() != null && megafonContractProduct.getStatus() != MegafonContractProductStatus.INACTIVE) {
            throw new RuntimeException("\u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \"\u041d\u0435\u0430\u043a\u0442\u0438\u0432\u0435\u043d\"!");
        }
        if (megafonContractProduct.getTariffId() <= 0) {
            throw new RuntimeException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0430\u0440\u0438\u0444!");
        }
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        MegafonProduct product = megafonService.getProduct(megafonContractProduct.getProductId());
        if (product == null) {
            throw new RuntimeException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID = " + megafonContractProduct.getProductId());
        }
        LocalDate now = LocalDate.now();
        if (megafonContractProduct.getStartTime() == null || megafonContractProduct.getStartTime().toLocalDate().isBefore(now)) {
            throw new RuntimeException("\u0414\u0430\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u043e\u0448\u043b\u043e\u043c!");
        }
        if (megafonContractProduct.getStartTime().toLocalDate().isAfter(now)) {
            this.contractProductDao.update(megafonContractProduct);
            return;
        }
        if (this.checkBalance(product, megafonContractProduct.getContractId())) {
            throw new RuntimeException(String.format("\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 CID=%s. \u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 ID:%s = %s.", megafonContractProduct.getContractId(), product.getId(), product.getPrice()));
        }
        String msisdn = Utils.isBlankString((String)megafonContractProduct.getAdditionalMsisdn()) ? megafonContractProduct.getMsisdn() : megafonContractProduct.getAdditionalMsisdn();
        MegafonApiClient megafonClient = new MegafonApiClient(this.context.getModuleId());
        JSONObject activateResponse = megafonClient.activateSim(megafonContractProduct.getContractId(), msisdn);
        if (activateResponse.optString("activ_status").equals("1")) {
            this.contractAddCharge(megafonContractProduct.getContractId(), new BigDecimal(150), product);
        }
        this.addPaymentForActivate(megafonClient, megafonContractProduct.getContractId(), msisdn, product);
        this.getLogger().debug(String.format("ProductActivate => contractId=%s, productId=%s, productTitle=%s", megafonContractProduct.getContractId(), product.getId(), product.getTitle()));
        long orderId = megafonClient.productActivate(megafonContractProduct, product.getProductOfferingId());
        this.getLogger().debug(String.format("ProductActivate result: contractId=%s, productId=%s, orderId=%s", megafonContractProduct.getContractId(), product.getId(), orderId));
        megafonContractProduct.setStatus(MegafonContractProductStatus.ACTIVATION_ORDERED);
        megafonContractProduct.setOrderId(orderId);
        this.contractProductDao.update(megafonContractProduct);
        MegafonCheckOrderStatus.getInstance().checkOrders();
    }

    private void addPaymentForActivate(MegafonApiClient megafonClient, int contractId, String msisdn, MegafonProduct product) {
        BigDecimal productPrice;
        BigDecimal currentBalance = new BigDecimal(Utils.maskBlank((String)megafonClient.getCustomersInfo(msisdn).optString("currentBalance"), (String)"0"));
        if (currentBalance.compareTo(productPrice = new BigDecimal(product.getPrice())) <= 0) {
            BigDecimal diff = productPrice.subtract(currentBalance);
            this.getLogger().debug("\u041d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0435 msisdn={} \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 productOfferingId={} \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435 = {}", (Object)msisdn, (Object)product.getProductOfferingId(), (Object)diff);
            MegafonKassaApiClient kassaApiClient = new MegafonKassaApiClient(this.moduleId);
            kassaApiClient.addPayment(contractId, msisdn, diff, "");
        }
    }

    private void contractAddCharge(int contractId, BigDecimal summa, MegafonProduct product) throws Exception {
        Charge charge = new Charge();
        charge.setContractId(contractId);
        charge.setSum(summa);
        charge.setUserId(0);
        charge.setTypeId(Utils.parseInt((String)this.getModuleSetup().get("chargeType"), (int)0));
        charge.setComment("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 = " + product.getTitle());
        charge.setDate(new Date());
        charge.setTimeChange(new Date());
        ((ChargeService)this.context.getService(ChargeService.class, 0)).chargeUpdate(charge);
    }

    private boolean checkBalance(MegafonProduct product, int contractId) {
        boolean bl;
        BalanceDao balanceDao = new BalanceDao(this.getConnection());
        try {
            LocalDate now = LocalDate.now();
            bl = balanceDao.getBalance(contractId, now.getYear(), now.getMonthValue()).compareTo(new BigDecimal(product.getPrice())) >= 0;
        }
        catch (Throwable throwable) {
            try {
                try {
                    balanceDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGException e) {
                throw new RuntimeException(e);
            }
        }
        balanceDao.close();
        return bl;
    }

    public void productDeactivateRequest(MegafonContractProduct megafonContractProduct) throws Exception {
        if (megafonContractProduct.getStatus() != null && megafonContractProduct.getStatus() != MegafonContractProductStatus.ACTIVE) {
            throw new RuntimeException("\u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \"\u0410\u043a\u0442\u0438\u0432\u0435\u043d\"!");
        }
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        MegafonProduct product = megafonService.getProduct(megafonContractProduct.getProductId());
        if (product == null) {
            throw new RuntimeException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID = " + megafonContractProduct.getProductId());
        }
        this.getLogger().debug(String.format("ProductDeactivate => contractId=%s, productId=%s, productTitle=%s", megafonContractProduct.getContractId(), product.getId(), product.getTitle()));
        MegafonApiClient megafonClient = new MegafonApiClient(this.context.getModuleId());
        long orderId = megafonClient.productDeactivate(megafonContractProduct, product.getProductOfferingId());
        this.getLogger().debug(String.format("ProductActivate result: contractId=%s, productId=%s, orderId=%s", megafonContractProduct.getContractId(), product.getId(), orderId));
        megafonContractProduct.setStatus(MegafonContractProductStatus.DEACTIVATION_ORDERED);
        megafonContractProduct.setOrderId(orderId);
        this.contractProductDao.update(megafonContractProduct);
        MegafonCheckOrderStatus.getInstance().checkOrders();
    }

    public void productActivate(MegafonContractProduct megafonContractProduct) throws Exception {
        MegafonProduct product = this.getProductOrThrow(megafonContractProduct.getProductId());
        Service service = this.getNpayServiceOrTrow(product.getNpayServiceId());
        TariffService tariffService = (TariffService)this.context.getService(TariffService.class, 0);
        TariffPlan tariffWithActivate = tariffService.tariffPlanGet(megafonContractProduct.getTariffId());
        if (tariffWithActivate == null) {
            throw new RuntimeException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u0441 ID=" + megafonContractProduct.getTariffId());
        }
        NPayService npayService = (NPayService)this.context.getService(NPayService.class, this.getNpayMidOrThrow());
        ServiceObject serviceObject = npayService.serviceObjectList(megafonContractProduct.getContractId(), -1, -1, -1, true, new Date()).stream().filter(so -> so.getServiceId() == service.getId()).findAny().orElse(null);
        if (serviceObject == null) {
            serviceObject = new ServiceObject();
            serviceObject.setServiceId(service.getId());
            serviceObject.setContractId(megafonContractProduct.getContractId());
            serviceObject.setCol(BigDecimal.ONE);
            serviceObject.setDate1(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)megafonContractProduct.getStartTime()));
            serviceObject.setDate2(megafonContractProduct.getEndTime() != null ? TimeUtils.convertLocalDateTimeToDate((LocalDateTime)megafonContractProduct.getEndTime()) : null);
            serviceObject.setComment(String.format("\u041c\u0435\u0433\u0430\u0444\u043e\u043d. \u041f\u0440\u043e\u0434\u0443\u043a\u0442: ID=%s, \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435=%s", product.getId(), product.getTitle()));
        }
        this.getLogger().debug(String.format("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u0431\u043e\u043d.\u043f\u043b\u0430\u0442\u044b. cid=%s, serviceId=%s", megafonContractProduct.getContractId(), service.getId()));
        npayService.serviceObjectUpdate(megafonContractProduct.getContractId(), serviceObject);
        this.getLogger().debug(String.format("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440. cid=%s, serviceId=%s", megafonContractProduct.getContractId(), tariffWithActivate.getId()));
        ((ContractTariffService)this.context.getService(ContractTariffService.class, 0)).contractTariffUpdate(ContractTariff.builder().setContractId(megafonContractProduct.getContractId()).setComment("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u0430 \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u041c\u0435\u0433\u0430\u0444\u043e\u043d. \u041f\u0440\u043e\u0434\u0443\u043a\u0442: " + product.getTitle()).setPeriod(new Period(new Date(), null)).setTariffPlanId(tariffWithActivate.getId()).build());
        megafonContractProduct.setStatus(MegafonContractProductStatus.ACTIVE);
        this.contractProductDao.update(megafonContractProduct);
    }

    public void productDeactivate(MegafonContractProduct megafonContractProduct) throws Exception {
        int npayMid = this.getNpayMidOrThrow();
        MegafonProduct product = this.getProductOrThrow(megafonContractProduct.getProductId());
        NPayService npayService = (NPayService)this.context.getService(NPayService.class, npayMid);
        List serviceObjectList = npayService.serviceObjectList(megafonContractProduct.getContractId(), -1, npayMid, -1, false, null);
        ServiceObject serviceObject = serviceObjectList.stream().filter(so -> so.getServiceId() == product.getNpayServiceId()).findFirst().orElseThrow(() -> new RuntimeException(String.format("\u041d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 cid=%s \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0430 \u0441 serviceId=%s", megafonContractProduct.getContractId(), product.getNpayServiceId())));
        this.getLogger().debug(String.format("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430, \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438 \u041c\u0435\u0433\u0430\u0444\u043e\u043d, \u0441\u043c\u0435\u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u0430 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. cid=%s, productId=%s, serviceId=%s", megafonContractProduct.getContractId(), product.getId(), product.getNpayServiceId()));
        LocalDateTime now = LocalDateTime.now();
        serviceObject.setDate2(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)now));
        npayService.serviceObjectUpdate(megafonContractProduct.getContractId(), serviceObject);
        megafonContractProduct.setStatus(MegafonContractProductStatus.DISABLED);
        megafonContractProduct.setEndTime(now);
        this.contractProductDao.update(megafonContractProduct);
        TariffService tariffService = (TariffService)this.context.getService(TariffService.class, 0);
        TariffPlan tariffWithActivate = tariffService.tariffPlanGet(megafonContractProduct.getTariffId());
        if (tariffWithActivate == null) {
            this.getLogger().error((Object)new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u0441 ID=" + megafonContractProduct.getTariffId()));
        }
        ContractTariffService contractTariffService = (ContractTariffService)this.context.getService(ContractTariffService.class, 0);
        contractTariffService.contractTariffList(megafonContractProduct.getContractId(), new Date(), 0, 0).stream().filter(contractTariff -> contractTariff.getTariffPlanId() == tariffWithActivate.getId()).findFirst().ifPresent(contractTariff -> {
            try {
                contractTariff.getPeriod().setDateTo(new Date());
                contractTariffService.contractTariffUpdate(contractTariff);
            }
            catch (Exception e) {
                this.getLogger().error((Object)e);
            }
        });
    }

    private MegafonProduct getProductOrThrow(int productId) throws Exception {
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        MegafonProduct product = megafonService.getProduct(productId);
        if (product == null) {
            throw new RuntimeException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID = " + productId);
        }
        return product;
    }

    private int getNpayMidOrThrow() throws BGException {
        int npayMid = -1;
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            if (!"npay".equals(module.getName())) continue;
            npayMid = module.getId();
        }
        if (npayMid <= 0) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043c\u043e\u0434\u0443\u043b\u044c Npay");
        }
        return npayMid;
    }

    public void optionActivateRequest(MegafonContractProduct contractProduct, MegafonOption option) throws Exception {
        LocalDateTime productEndTime = contractProduct.getEndTime();
        if (productEndTime.isBefore(LocalDateTime.now())) {
            throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u043e\u043f.\u043e\u043f\u0446\u0438\u044e, \u0442.\u043a. \u043f\u0435\u0440\u0438\u043e\u0434 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0441\u044f");
        }
        String msisdn = Utils.isBlankString((String)contractProduct.getAdditionalMsisdn()) ? contractProduct.getMsisdn() : contractProduct.getAdditionalMsisdn();
        MegafonApiClient megafonClient = new MegafonApiClient(this.context.getModuleId());
        long orderId = megafonClient.optionActivate(msisdn, LocalDateTime.now(), productEndTime, option.getUuid());
        this.getLogger().debug(String.format("optionActivateRequest result: contractId=%s, optionId=%s, orderId=%s", contractProduct.getContractId(), option.getId(), orderId));
        MegafonContractOption contractOption = new MegafonContractOption();
        contractOption.setContractId(contractProduct.getContractId());
        contractOption.setOptionId(option.getId());
        contractOption.setContractProductId(contractProduct.getContractId());
        contractOption.setStatus(MegafonContractProductStatus.ACTIVATION_ORDERED);
        contractOption.setOrderId(orderId);
        contractOption.setStartTime(LocalDateTime.now());
        contractOption.setEndTime(productEndTime);
        new MegafonContractOptionDao(this.getConnection(), this.moduleId).update(contractOption);
        MegafonCheckOrderStatus.getInstance().checkOrders();
    }

    public void optionActivate(MegafonContractProduct contractProduct, MegafonContractOption contractOption) throws Exception {
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        MegafonOption option = megafonService.getMegafonOption(contractOption.getOptionId());
        Service service = this.getNpayServiceOrTrow(option.getNpayServiceId());
        ServiceObject serviceObject = new ServiceObject();
        serviceObject.setServiceId(service.getId());
        serviceObject.setContractId(contractProduct.getContractId());
        serviceObject.setCol(BigDecimal.ONE);
        serviceObject.setDate1(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)contractOption.getStartTime()));
        serviceObject.setDate2(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)contractOption.getEndTime()));
        serviceObject.setComment(String.format("\u041c\u0435\u0433\u0430\u0444\u043e\u043d. \u0414\u043e\u043f.\u043e\u043f\u0446\u0438\u044f: ID=%s, \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435=%s", option.getId(), option.getTitle()));
        NPayService npayService = (NPayService)this.context.getService(NPayService.class, this.getNpayMidOrThrow());
        this.getLogger().debug(String.format("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u0431\u043e\u043d.\u043f\u043b\u0430\u0442\u044b. cid=%s, serviceId=%s", contractProduct.getContractId(), service.getId()));
        npayService.serviceObjectUpdate(contractProduct.getContractId(), serviceObject);
        contractOption.setOrderId(0L);
        contractOption.setStatus(MegafonContractProductStatus.ACTIVE);
        new MegafonContractOptionDao(this.getConnection(), this.moduleId).update(contractOption);
    }

    private Service getNpayServiceOrTrow(int npayServiceId) throws Exception {
        return ModuleCache.getInstance().getModuleServicesList(this.getNpayMidOrThrow()).stream().filter(s -> s.getId() == npayServiceId).findFirst().orElseThrow();
    }
}

