/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.JRViewer;
import bitel.billing.module.services.ServicePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;

public class PrintReportPanel
extends ServicePanel {
    private String sid = null;
    private String aid = null;
    private int year;
    private int month;
    private int day;
    private JPanel viewPanel = new JPanel();
    private JRViewer viewer = null;
    int unit = 0x100000;
    private boolean dataShown = false;

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public PrintReportPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.viewPanel.setLayout(new BorderLayout());
        this.viewPanel.setBackground(new Color(255, 255, 255));
        this.add(this.viewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton genButton = new JButton();
        genButton.setText("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c");
        this.add(genButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 14, 0, new Insets(10, 0, 0, 0), 0, 0));
        genButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintReportPanel.this.generateReport();
            }
        });
        this.setSize(new Dimension(300, 300));
    }

    public void setData(String sid, String aid, int year, int month, int day) {
        this.aid = aid;
        this.sid = sid;
        this.year = year;
        this.month = month;
        this.day = day;
        this.dataShown = false;
        if (this.isVisible()) {
            this.generateReport();
        }
    }

    public void setData() {
        if (!this.dataShown) {
            this.generateReport();
        }
    }

    private void generateReport() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetJasperStatData");
        request.setAttribute("sid", this.sid);
        request.setAttribute("aid", this.aid);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        request.setAttribute("year", String.valueOf(this.year));
        request.setAttribute("month", String.valueOf(this.month));
        request.setAttribute("day", String.valueOf(this.day));
        request.setAttribute("contentType", "binary");
        request.setAttribute("unit", String.valueOf(this.unit));
        byte[] data = this.getBytes(request);
        if (data != null) {
            try {
                if (this.viewer == null) {
                    this.viewer = new JRViewer((JasperPrint)JRLoader.loadObject((InputStream)new ByteArrayInputStream(data)));
                    this.viewPanel.add((Component)this.viewer);
                    this.viewer.setVisible(true);
                    this.viewPanel.validate();
                } else {
                    this.viewer.setReport((JasperPrint)JRLoader.loadObject((InputStream)new ByteArrayInputStream(data)));
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((String)("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 - " + ex.getLocalizedMessage()));
                ex.printStackTrace();
            }
        }
        this.dataShown = true;
    }
}

