/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.inet.common.bean.InetOption;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Node;

public class InetOptionDao
extends AbstractIdDao<InetOption>
implements Directory<InetOption> {
    public InetOptionDao(Connection con, int mid) {
        super(con, mid, "inet_option");
    }

    protected InetOption getFromRS(ResultSet rs) throws SQLException, BGException {
        InetOption result = new InetOption();
        result.setId(rs.getInt("id"));
        result.setParentId(rs.getInt("parentId"));
        result.setTitle(rs.getString("title"));
        result.setGroupIntersection(rs.getBoolean("groupIntersection"));
        result.setConfig(rs.getString("config"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    protected void updateImpl(InetOption b) throws BGException, SQLException {
        PreparedStatement ps;
        if (Utils.isBlankString((String)b.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (parentId, title, groupIntersection, config, comment) VALUES (?,?,?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=?, title=?, groupIntersection=?, config=?, comment=? WHERE id=?");
            ps.setInt(6, b.getId());
        }
        ps.setInt(1, b.getParentId());
        ps.setString(2, b.getTitle());
        ps.setBoolean(3, b.isGroupIntersection());
        ps.setString(4, b.getConfig());
        ps.setString(5, b.getComment());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    public InetOption get(String title) throws BGException {
        return (InetOption)this.get("title=?", new Object[]{title});
    }

    public List<InetOption> list() throws BGException {
        return this.list(null, "title", new Object[0]);
    }

    public InetOption tree() throws BGException {
        InetOption root = new InetOption();
        root.setGroupIntersection(true);
        List list = this.list(null, "title", new Object[0]);
        return (InetOption)TreeUtils.tree((List)list, (Node)root);
    }

    public void move(int newParentId, Set<Integer> children) throws BGException {
        if (newParentId < 0 || children == null || children.size() == 0) {
            throw new BGIllegalArgumentException();
        }
        InetOption root = this.tree();
        for (Integer id : children) {
            InetOption child = this.find(root, id);
            if (this.find(child, newParentId) == null) continue;
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u043e\u043f\u0446\u0438\u044e \u0432 \u0434\u043e\u0447\u0435\u0440\u043d\u044e\u044e.");
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=? WHERE id IN (" + Utils.toString(children) + ")");
            ps.setInt(1, newParentId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private InetOption find(InetOption option, int id) {
        if (option.getId() == id) {
            return option;
        }
        if (option.getChildren() != null) {
            for (InetOption child : option.getChildren()) {
                InetOption result = this.find(child, id);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

