/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardRemove;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.TelegramNotification;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;

@WebServlet(name="telegramHelpdeskWebhook", urlPatterns={"/telegramHelpdeskWebhook/*"})
public class TelegramHelpdeskWebhook
extends HttpServlet {
    private static Logger log = LogManager.getLogger();
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setStatus(200);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletInputStream inputStream = httpServletRequest.getInputStream();
        byte[] bytes = Utils.readByBlock((InputStream)inputStream);
        String body = new String(bytes, "UTF-8");
        JSONObject jsonObject = new JSONObject(body);
        Connection con = Setup.getSetup().getDBConnection();
        JSONObject messageObject = jsonObject.optJSONObject("message");
        JSONObject callbackQueryObject = jsonObject.optJSONObject("callback_query");
        SendMessage sendMessage = null;
        if (messageObject != null) {
            String text = messageObject.optString("text");
            String chatId = String.valueOf(messageObject.optQuery("/chat/id"));
            String telegramUserId = String.valueOf(((JSONObject)messageObject.optQuery("/from")).optLong("id"));
            String telegramUserName = ((JSONObject)messageObject.optQuery("/from")).optString("username");
            JSONObject replyToMessage = messageObject.optJSONObject("reply_to_message");
            if (replyToMessage != null) {
                this.hdReplyToMessage(con, replyToMessage.optString("text"), text, telegramUserId, telegramUserName);
            }
            if ("/start".equals(text)) {
                String saveChatId = ServerUtils.getSetupValue((Connection)con, (String)("telegram." + telegramUserId + ".chat.id"), null);
                if (saveChatId == null) {
                    saveChatId = ServerUtils.getSetupValue((Connection)con, (String)("telegram." + telegramUserName + ".chat.id"), null);
                }
                if (saveChatId != null && chatId.equals(saveChatId)) {
                    sendMessage = new SendMessage();
                    sendMessage.setChatId(chatId);
                    sendMessage.setText("\u041f\u0440\u0438\u0432\u0435\u0442, \u043c\u044b \u0443\u0436\u0435 \u0437\u043d\u0430\u043a\u043e\u043c\u044b...");
                } else {
                    ServerUtils.setSetupValue((Connection)con, (String)("telegram." + telegramUserName + ".chat.id"), (String)chatId);
                    ServerUtils.setSetupValue((Connection)con, (String)("telegram." + telegramUserId + ".chat.id"), (String)chatId);
                    sendMessage = new SendMessage();
                    sendMessage.setChatId(chatId);
                    sendMessage.setText("\u041f\u0440\u0438\u0432\u0435\u0442, \u043f\u0440\u0438\u044f\u0442\u043d\u043e \u043f\u043e\u0437\u043d\u0430\u043a\u043e\u043c\u0438\u0442\u044c\u0441\u044f...");
                }
            } else if ("/hideKeys".equals(text)) {
                sendMessage = new SendMessage();
                sendMessage.setChatId(chatId);
                sendMessage.setReplyMarkup((ReplyKeyboard)this.getReplyKeyboardRemove());
            } else if ("/showMyId".equals(text)) {
                sendMessage = new SendMessage();
                sendMessage.setChatId(chatId);
                sendMessage.setText("ID# " + telegramUserId);
            }
        } else if (callbackQueryObject != null) {
            String data = callbackQueryObject.optString("data");
            String chatId = String.valueOf(callbackQueryObject.optQuery("/message/chat/id"));
            if (!data.isEmpty()) {
                String messageText;
                int messageId;
                if (data.startsWith("HD|")) {
                    Object sendMessageText = "Ok";
                    String[] datas = data.split("\\|");
                    if ("setTopicUserId".equals(datas[1]) && datas.length == 4) {
                        try {
                            TopicManager topicManager = new TopicManager(con, this.plugin);
                            Topic topic = topicManager.getTopic(Utils.parseInt((String)datas[2]));
                            if (topic != null) {
                                topic.setUserId(Utils.parseInt((String)datas[3]));
                                topicManager.updateTopic(topic);
                            }
                        }
                        catch (Exception e) {
                            sendMessageText = e.getLocalizedMessage();
                        }
                    } else {
                        sendMessageText = datas[1] + " - \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
                    }
                    sendMessage = new SendMessage();
                    sendMessage.setChatId(chatId);
                    sendMessage.setText((String)sendMessageText);
                } else if (data.equals("download_attachments") && (messageId = this.parseMessageId(messageText = callbackQueryObject.optJSONObject("message").optString("text"))) > 0) {
                    String telegramApiUrl = this.plugin.getSetup().get("telegram.api.url", "https://api.telegram.org/");
                    String telegramBotToken = this.plugin.getSetup().get("telegram.bot.token", null);
                    try {
                        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(con);
                        TelegramNotification.sendAttachmentFiles(chatId, telegramBotToken, telegramApiUrl, (FileStorage)fileStorage, fileStorage.getFilesListByOwner(messageId));
                    }
                    catch (BGException e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        String responseData = mapper.writeValueAsString(sendMessage);
        log.debug("message = {}", (Object)responseData);
        httpServletResponse.setStatus(200);
        httpServletResponse.setHeader("Content-Type", "application/json");
        ServletOutputStream outputStream = httpServletResponse.getOutputStream();
        outputStream.write(responseData.getBytes("UTF-8"));
        outputStream.flush();
    }

    private int parseTopicId(String replyToText) {
        return Utils.parseInt((String)replyToText.substring(3, replyToText.indexOf(45, 4)), (int)0);
    }

    private int parseMessageId(String replyToText) {
        return Utils.parseInt((String)replyToText.substring(replyToText.indexOf(45, 4) + 1, replyToText.indexOf(32)), (int)0);
    }

    private void hdReplyToMessage(Connection con, String replyToText, String text, String telegramUserId, String telegramUserName) {
        int topicId = 0;
        int replyToMessageId = 0;
        if (replyToText != null && replyToText.contains("-")) {
            topicId = this.parseTopicId(replyToText);
            replyToMessageId = this.parseMessageId(replyToText);
        }
        if (topicId > 0) {
            try {
                Object user;
                TopicManager topicManager = new TopicManager(con, this.plugin);
                Topic topic = topicManager.getTopic(topicId);
                boolean owner = false;
                int userId = topic.getUserId();
                if (userId > 0 && (user = UserMap.getUser((Integer)userId)) != null) {
                    boolean bl = owner = user.getConfigSetup().get("telegram.user.id").equals(telegramUserId) || user.getConfigSetup().get("telegram.user.name").equals(telegramUserName);
                }
                if (owner) {
                    for (Message message : topic.getMessages()) {
                        if (message.getId() != replyToMessageId || message.getUserIdFrom() != 0 || message.getUserIdTo() != -1) continue;
                        topicManager.setMessageAdminRead(message.getId(), userId);
                    }
                    Message message = Message.builder().setTopicId(topicId).setUserIdFrom(topic.getUserId()).setDateFrom(new Date()).setBody(text).build();
                    topicManager.updateMessage("new", message);
                    topicManager.sendNotification(topic, message);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    private ReplyKeyboardRemove getReplyKeyboardRemove() {
        ReplyKeyboardRemove replyKeyboardRemove = new ReplyKeyboardRemove();
        replyKeyboardRemove.setRemoveKeyboard(Boolean.valueOf(true));
        return replyKeyboardRemove;
    }
}

