/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.gar.server.service;

import java.util.Collection;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarAddressCity;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarAddressHouse;
import ru.bitel.bgbilling.plugins.gar.common.bean.GarAddressStreet;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityData;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityType;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class GarLoader {
    private final AddressService addressService;
    private final int countryId;

    public GarLoader(int countryId, ServerContext serverContext) throws BGException {
        this.addressService = (AddressService)serverContext.getService(AddressService.class, 0);
        this.countryId = countryId;
    }

    protected City findCityByTitle(String cityName) throws BGException {
        List cityList = this.addressService.searchCityList(this.countryId, cityName, null, null).getList();
        return Utils.isEmptyCollection((Collection)cityList) ? null : (City)cityList.get(0);
    }

    protected int saveCityInDBIfNotExists(GarAddressCity garAddressCity) throws BGException {
        if (this.findCityByTitle(garAddressCity.getTitle()) == null) {
            return this.saveCityInDB(garAddressCity);
        }
        return -1;
    }

    private int saveCityInDB(GarAddressCity garAddressCity) throws BGException {
        AddressEntityData newCity = new AddressEntityData();
        newCity.setAddressEntityType(AddressEntityType.CITY);
        newCity.setParentId(this.countryId);
        newCity.setTitlePrefix((String)(Utils.isBlankString((String)garAddressCity.getTypeName()) ? "\u0433." : garAddressCity.getTypeName() + "."));
        newCity.setTitle(garAddressCity.getTitle());
        this.addressService.addressEntityDataUpdate(newCity);
        return newCity.getRecordId();
    }

    protected List<Street> findStreet(int cityId, String streetTitle) throws BGException {
        return this.addressService.searchStreetList(cityId, streetTitle, "equal", null).getList();
    }

    protected int saveStreetInDB(int cityId, GarAddressStreet garAddressStreet) throws BGException {
        City city = this.addressService.cityGet(cityId);
        if (city == null) {
            throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0443\u043b\u0438\u0446\u0443 \u0432 \u0431\u0430\u0437\u0443 \u0434\u0430\u043d\u043d\u044b\u0445, \u0442.\u043a. \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u0430\u0441\u0435\u043b\u0451\u043d\u043d\u044b\u0439 \u043f\u0443\u043d\u043a\u0442. cityId=" + cityId);
        }
        AddressEntityData newStreet = new AddressEntityData();
        newStreet.setAddressEntityType(AddressEntityType.STREET);
        newStreet.setParentId(cityId);
        newStreet.setTitlePrefix((String)(Utils.isBlankString((String)garAddressStreet.getTypeName()) ? "\u0443\u043b." : garAddressStreet.getTypeName() + "."));
        newStreet.setTitle(garAddressStreet.getTitle());
        this.addressService.addressEntityDataUpdate(newStreet);
        return newStreet.getRecordId();
    }

    protected void saveHousesByStreet(int bgStreetId, GarAddressStreet street) throws BGException {
        Street bgStreet = this.addressService.streetGet(bgStreetId);
        if (street != null && bgStreet != null && Utils.notEmptyCollection((Collection)street.getHouses())) {
            for (GarAddressHouse house : street.getHouses()) {
                AddressEntityData newHouse = new AddressEntityData();
                newHouse.setAddressEntityType(AddressEntityType.HOUSE);
                newHouse.setParentId(bgStreetId);
                newHouse.addEntityParameter("postIndex", house.getPostIndex());
                newHouse.addEntityParameter("cityId", String.valueOf(bgStreet.getCityId()));
                newHouse.setTitle(house.getTitle());
                this.trySaveHouse(newHouse);
            }
        }
    }

    private void trySaveHouse(AddressEntityData house) throws BGException {
        block2: {
            try {
                this.addressService.addressEntityDataUpdate(house);
            }
            catch (BGException e) {
                if (e.getMessage().equals("\u0414\u043e\u043c \u0443\u0436\u0435 \u0438\u043c\u0435\u0435\u0442\u0441\u044f")) break block2;
                throw e;
            }
        }
    }
}

