/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.SenderType;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class SenderTypePanel
extends BGUPanel {
    private BGUTable table;
    private SenderTypeTableModel model = new SenderTypeTableModel();

    protected void jbInit() {
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SenderTypePanel.this.performAction("edit");
                }
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(((DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class)).getSenderTypes())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new SenderEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u043c\u0435\u0442\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438", new SenderType()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            SenderType current = (SenderType)this.model.getSelectedRow();
            if (current == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            if (current.getId() <= 0) {
                throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 \u043d\u0435\u043b\u044c\u0437\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c!");
            }
            new SenderEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u043c\u0435\u0442\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438", current).open();
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            SenderType current = (SenderType)this.model.getSelectedRow();
            if (current == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (current.getId() <= 0) {
                throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u044f\u0442\u044c!");
            }
            ((DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class)).deleteSenderType(current.getId());
            this.performAction("refresh");
        });
    }

    class SenderTypeTableModel
    extends BGTableModel<SenderType> {
        public SenderTypeTableModel() {
            super(SenderTypeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", 5, 50, 50, "id", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title");
        }
    }

    class SenderEditorDialog
    extends BGEditorDialog<SenderType> {
        private final BGTextField titleField;
        private final DynamicClassChooser classChooser;

        public SenderEditorDialog(String title, SenderType data) {
            super(title, (Object)data);
            this.titleField = new BGTextField(40);
            this.classChooser = new DynamicClassChooser(true);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u0418\u043c\u044f \u043c\u0435\u0442\u043e\u0434\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.titleField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043b\u0430\u0441\u0441:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.classChooser, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.classChooser.setIfaceName(((DispatchService)((ClientContext)SenderTypePanel.this.getContext()).getPort(DispatchService.class)).getSenderIfaceClassName());
            this.classChooser.performAction("refresh");
            this.titleField.setText(((SenderType)this.data).getTitle());
            if (((SenderType)this.data).getId() > 0) {
                this.classChooser.setSelectedItem(((SenderType)this.data).getClassName());
            } else {
                this.classChooser.setSelectedIndex(0);
            }
        }

        public boolean doApply() throws Exception {
            String className = this.classChooser.getSelectedClass();
            if (Utils.isBlankString((String)className)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043b\u0430\u0441\u0441!");
                return false;
            }
            ((SenderType)this.data).setClassName(className);
            ((SenderType)this.data).setTitle(this.titleField.getText());
            ((DispatchService)((ClientContext)SenderTypePanel.this.getContext()).getPort(DispatchService.class)).updateSenderType((SenderType)this.data);
            SenderTypePanel.this.performAction("refresh");
            return true;
        }
    }
}

