/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.AccessCodes;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceError;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceErrorFilter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.sql.ConnectionSet;

public class VoiceErrorDao
extends AbstractIdDao<VoiceError> {
    private final ConnectionSet connectionSet;

    public VoiceErrorDao(ConnectionSet connectionSet, int moduleId, Date date) {
        super(connectionSet.getConnection(), moduleId, "voice_error", date);
        this.connectionSet = connectionSet;
    }

    protected VoiceError getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceError result = new VoiceError();
        result.setId(rs.getInt("id"));
        result.setAccountId(rs.getInt("accountId"));
        result.setHour((Date)rs.getTimestamp("hour"));
        result.setCode(rs.getInt("errorCode"));
        result.setPhoneFrom(rs.getString("phoneFrom"));
        result.setPhoneTo(rs.getString("phoneTo"));
        result.setSessionStart((Date)rs.getTimestamp("sessionStart"));
        result.setDeviceId(rs.getInt("deviceId"));
        result.setFromPort(rs.getString("fromPort"));
        result.setToPort(rs.getString("toPort"));
        result.setDuration(rs.getLong("duration"));
        return result;
    }

    protected void updateImpl(VoiceError b) throws BGException, SQLException {
        String query = (b.getId() > 0 ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET accountId=?, hour=?, errorCode=?, phoneFrom=?, phoneTo=?, sessionStart=?, deviceId=?, fromPort=?, toPort=?, duration=? ";
        if (b.getId() > 0) {
            query = query + " WHERE id=?";
        }
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        int idx = 1;
        idx = this.setParams(b, ps, idx);
        if (b.getId() > 0) {
            ps.setInt(idx++, b.getId());
        }
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    private int setParams(VoiceError b, PreparedStatement ps, int idx) throws SQLException {
        if (b.getAccountId() > 0) {
            ps.setInt(idx++, b.getAccountId());
        } else {
            ps.setNull(idx++, 4);
        }
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)b.getHour()));
        ps.setInt(idx++, b.getCode());
        ps.setString(idx++, b.getPhoneFrom());
        ps.setString(idx++, b.getPhoneTo());
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)b.getSessionStart()));
        ps.setInt(idx++, b.getDeviceId());
        ps.setString(idx++, b.getFromPort());
        ps.setString(idx++, b.getToPort());
        ps.setLong(idx++, b.getDuration());
        return idx;
    }

    public void deleteErrors(int deviceId, LocalDateTime hour) throws BGException {
        this.delete("deviceId=? && hour=?", new Object[]{deviceId, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)hour)});
    }

    public Result<VoiceError> list(VoiceErrorFilter filter, Page page) throws BGException {
        ArrayList<VoiceError> result = new ArrayList<VoiceError>();
        Connection con = this.connectionSet.getTrashConnection(this.tableName, 2);
        try {
            if (ServerUtils.tableExists((Connection)con, (String)this.tableName)) {
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT SQL_CALC_FOUND_ROWS error.*, contract.title, account.title as title FROM " + this.tableName + " as error");
                sb.append(" LEFT JOIN voice_account_base_" + this.moduleId + " as account ON account.id > 0 AND account.id=error.accountId ");
                sb.append(" LEFT JOIN contract ON account.contractId > 0 && contract.id=account.contractId ");
                sb.append(" WHERE error.hour>=? AND error.hour<?");
                if (Utils.notEmptyCollection((Collection)filter.getContractIds())) {
                    sb.append(" AND contract.id IN (" + Utils.toString((Iterable)filter.getContractIds()) + ")");
                }
                if (Utils.notEmptyCollection((Collection)filter.getDeviceIds())) {
                    sb.append(" AND error.deviceId IN (" + Utils.toString((Iterable)filter.getDeviceIds()) + ")");
                }
                if (Utils.notBlankString((String)filter.getPhoneFrom())) {
                    sb.append(" AND error.phoneFrom LIKE ?");
                }
                if (Utils.notBlankString((String)filter.getPhoneTo())) {
                    sb.append(" AND error.phoneTo LIKE ?");
                }
                sb.append(" ORDER BY error.hour ASC").append(page.sqlLimit());
                PreparedStatement ps = con.prepareStatement(sb.toString());
                int i = 0;
                ps.setTimestamp(++i, TimeUtils.convertDateToTimestampSeconds((Date)filter.getDateFrom()));
                ps.setTimestamp(++i, TimeUtils.convertDateToTimestampSeconds((Date)filter.getDateTo()));
                if (Utils.notBlankString((String)filter.getPhoneFrom())) {
                    ps.setString(++i, "%" + filter.getPhoneFrom() + "%");
                }
                if (Utils.notBlankString((String)filter.getPhoneTo())) {
                    ps.setString(++i, "%" + filter.getPhoneTo() + "%");
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    VoiceError error = this.getFromRS(rs);
                    error.setContractTitle(rs.getString("contract.title"));
                    error.setAccountTitle(rs.getString("account.title"));
                    error.setErrorText(AccessCodes.toString((ParameterMap)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)), (int)error.getCode()));
                    result.add(error);
                }
                rs.close();
                ps.close();
                page.setRecordCount(ServerUtils.foundRows((Connection)con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return new Result(result, page);
    }

    public void insertErrors(List<VoiceError> errors) throws BGException {
        if (errors.size() == 0) {
            return;
        }
        StringBuffer query = new StringBuffer(errors.size() * 4);
        query.append(" INSERT INTO " + this.tableName + "(accountId, hour, errorCode, phoneFrom, phoneTo, sessionStart, deviceId, fromPort, toPort, duration) VALUES ");
        String questions = "(?,?,?,?,?,?,?,?,?,?)";
        for (int i = 0; i < errors.size(); ++i) {
            if (i > 0) {
                query.append(",");
            }
            query.append(questions);
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            int idx = 1;
            for (VoiceError error : errors) {
                idx = this.setParams(error, ps, idx);
            }
            ps.executeUpdate();
            try (ResultSet generatedKeys = ps.getGeneratedKeys();){
                idx = 0;
                Iterator<VoiceError> it = errors.iterator();
                while (generatedKeys.next()) {
                    VoiceError error = it.next();
                    error.setId(generatedKeys.getInt(1));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public static void checkTables(Connection con, int moduleId, Date date) throws BGException {
        try (Statement st = con.createStatement();){
            String tableName = ServerUtils.getModuleMonthTableName((String)"voice_error", (Date)date, (int)moduleId);
            if (!ServerUtils.tableExists((Connection)con, (String)tableName)) {
                st.executeUpdate(" CREATE TABLE " + tableName + " ( `id` int(11) NOT NULL AUTO_INCREMENT,`accountId` int(11) NULL DEFAULT NULL,`hour` datetime NOT NULL,`errorCode` int(11) NOT NULL,`phoneFrom` VARCHAR(50) NULL DEFAULT NULL,`phoneTo` VARCHAR(50) NULL DEFAULT NULL,`sessionStart` DATETIME NOT NULL,`deviceId` INT NOT NULL,`fromPort` VARCHAR(50) NULL DEFAULT NULL,`toPort` VARCHAR(50) NULL DEFAULT NULL, `duration` INT(11) NULL DEFAULT NULL, PRIMARY KEY (`id`),KEY `account` (`accountId`),CONSTRAINT `fk_" + tableName + "_account_base` FOREIGN KEY (`accountId`) REFERENCES `voice_account_base_" + moduleId + "` (`id`) ON UPDATE CASCADE ON DELETE CASCADE)");
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

