/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountTypeAbstract;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public abstract class VoiceAccountTypeAbstractDao<T extends VoiceAccountTypeAbstract>
extends AbstractIdDao<T>
implements Directory<T> {
    protected boolean isOperator;

    public VoiceAccountTypeAbstractDao(Connection con, int moduleId) {
        super(con, moduleId, "voice_account_type");
    }

    protected T getFromRS(ResultSet rs) throws SQLException, BGException {
        T result = this.createAccountTypeInstance();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setConfig(rs.getString("config"));
        result.setEntitySpecId(rs.getInt("entitySpecId"));
        return result;
    }

    protected abstract T createAccountTypeInstance();

    protected void updateImpl(T b) throws BGException, SQLException {
        boolean update = b.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, config=?, isOperator=?, entitySpecId=?" + this.fields() + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, b.getTitle());
            ps.setString(index++, b.getConfig());
            ps.setBoolean(index++, b.isOperator());
            ps.setInt(index++, b.getEntitySpecId());
            index = this.setParams(b, ps, index);
            if (update) {
                ps.setInt(index++, b.getId());
            }
            ps.executeUpdate();
            if (!update) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    protected abstract int setParams(T var1, PreparedStatement var2, int var3) throws SQLException;

    protected abstract String fields();

    public List<T> list() throws BGException {
        return this.list("isOperator = ?", null, new Object[]{this.isOperator});
    }

    public T get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }
}

