/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.tariff;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class CallTypeTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon iconIn = ClientUtils.getIcon((String)"call_in");
    private static Icon iconOut = ClientUtils.getIcon((String)"call_out");
    private static Icon iconEmpty = ClientUtils.getIcon((String)"phone_handset.png");
    private JPanel editor;
    private BGUComboBox<IdTitle> typeCombo;
    private JCheckBox revertNumber;
    private int type = 0;
    private boolean revert;

    public Component getView() {
        this.extractData();
        Icon icon = null;
        String title = null;
        if (this.type == 1) {
            icon = iconIn;
            title = "\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439";
        } else if (this.type == 2) {
            icon = iconOut;
            title = "\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439";
        } else {
            icon = iconEmpty;
            title = "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d";
        }
        return new JLabel("\u0422\u0438\u043f \u0437\u0432\u043e\u043d\u043a\u0430: " + title, icon, 2);
    }

    protected JPanel getEditorPanel() {
        if (this.editor == null) {
            this.editor = new JPanel();
            this.typeCombo = new BGUComboBox();
            this.typeCombo.addItem((Object)new IdTitle(1, "\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439"));
            this.typeCombo.addItem((Object)new IdTitle(2, "\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439"));
            this.revertNumber = new JCheckBox();
            this.revertNumber.setText("\u0418\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043d\u043e\u043c\u0435\u0440\u0430 \u0434\u043b\u044f \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0445");
            this.revertNumber.setVisible(true);
            this.editor.add(new JLabel("\u0422\u0438\u043f \u0437\u0432\u043e\u043d\u043a\u0430: "));
            this.editor.add((Component)this.typeCombo);
            this.editor.add(this.revertNumber);
        }
        return this.editor;
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.type = Utils.parseInt((String)((String)data.get("typeId")));
        this.revert = Utils.parseBoolean((String)((String)data.get("revert")));
    }

    protected void loadData() {
        this.extractData();
        this.typeCombo.setSelectedIndex(this.type - 1);
        this.revertNumber.setSelected(this.revert);
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        int type = ((IdTitle)this.typeCombo.getSelectedItem()).getId();
        data.put("typeId", String.valueOf(type));
        data.put("revert", String.valueOf(this.revertNumber.isSelected()));
        this.setDataInHash(data);
    }

    public void serializeToXML(Element el) {
        super.serializeToXML(el);
        this.extractData();
        String title = ((IdTitle)this.typeCombo.getSelectedItem()).getTitle();
        if (Utils.notEmptyString((String)title)) {
            el.setAttribute("title", title);
        }
        el.setAttribute("id", String.valueOf(this.type));
        el.setAttribute("revert", String.valueOf(this.revertNumber.isSelected()));
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) {
        HashMap<String, String> data = new HashMap<String, String>(3);
        data.put("typeId", el.getAttribute("id"));
        data.put("revert", el.getAttribute("revert"));
        this.setDataInHash(data);
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

