/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineTypeProduct;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineProductService;
import ru.bitel.common.Utils;

@WebServlet(name="SoftLineExecutor", urlPatterns={"/softlineexecutor/*"})
public class ModuleExecutor
extends CommonExecutor {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int moduleId = Utils.parseInt((String)req.getParameter("moduleId"), (int)0);
        int productId = Utils.parseInt((String)req.getParameter("productId"), (int)-1);
        SoftLineTypeProduct type = SoftLineTypeProduct.valueOf((int)Utils.parseInt((String)req.getParameter("typeProduct"), (int)0));
        if (productId < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("ID \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f < 0 !");
            }
            return;
        }
        byte[] pictureBytes = this.getProductPicture(moduleId, productId, type);
        if (pictureBytes != null) {
            resp.getOutputStream().write(pictureBytes);
        }
    }

    private byte[] getProductPicture(int moduleId, int productId, SoftLineTypeProduct type) {
        try {
            ServerContext context = new ServerContext(this.setup, 0, -1);
            SoftLineProductService productService = (SoftLineProductService)context.getService(SoftLineProductService.class, moduleId);
            return productService.getProductPicture(productId, type);
        }
        catch (BGException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private byte[] getBytesPicture(File picture) throws IOException {
        byte[] bytesArray = new byte[(int)picture.length()];
        FileInputStream fis = new FileInputStream(picture);
        fis.read(bytesArray);
        fis.close();
        return bytesArray;
    }
}

