/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sberbank.client;

import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.modules.sberbank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.sberbank.common.bean.TransactionStatus;
import ru.bitel.common.Utils;

public abstract class TransactionTableModel
extends AbstractTransactionTableModel<Transaction> {
    static final String COLUMN_ERROR = "error";
    static final String COLUMN_ORDER_ID = "orderId";
    static final String COLUMN_APPROVAL_CODE = "approvalCode";
    static final String COLUMN_CARDHOLDER_NAME = "cardholderName";
    static final String COLUMN_CODE_DESCRIPTION = "codeDescription";
    static final String COLUMN_TITLE_ERROR = "\u0421\u0442\u0430\u0442\u0443\u0441 \u0437\u0430\u043f\u0440\u043e\u0441\u0430";
    static final String COLUMN_TITLE_ORDER_ID = "OrderId";
    static final String COLUMN_TITLE_APPROVAL_CODE = "ApprovalCode";
    static final String COLUMN_TITLE_CARDHOLDER_NAME = "\u0418\u043c\u044f \u0434\u0435\u0440\u0436\u0430\u0442\u0435\u043b\u044f \u043a\u0430\u0440\u0442\u044b";
    static final String COLUMN_TITLE_CODE_DESCRIPTION = "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438";

    public TransactionTableModel(String name) {
        super(name, Transaction.class);
    }

    protected Object getStatusValue(Transaction value, int column) throws BGException {
        AbstractTransactionStatus result = TransactionStatus.ALL.getStatusByCode(value.getStatus());
        return result == null ? value.getStatus() : result.getTitle();
    }

    public Object getValue(Transaction value, int column) throws BGException {
        String identifier = this.getIdentifier(column);
        if ("property".equals(identifier)) {
            if (value.getTransactionType() == BGTransactionType.CARD) {
                String nameValue;
                String panValue = this.getParameter(value.getParameters(), "cardAuthInfo.pan");
                if (Utils.isBlankString((String)panValue)) {
                    panValue = this.getParameter(value.getParameters(), "Pan");
                }
                if (Utils.isBlankString((String)(nameValue = this.getParameter(value.getParameters(), "cardAuthInfo.cardholderName")))) {
                    nameValue = this.getParameter(value.getParameters(), COLUMN_CARDHOLDER_NAME);
                }
                return panValue + " " + nameValue;
            }
            if (value.getTransactionType() == BGTransactionType.QR_SBP) {
                return this.getParameter(value.getParameters(), "sbp_operation_params.sbp_masked_payer");
            }
        } else {
            if (COLUMN_ORDER_ID.equals(identifier)) {
                String key = switch (value.getTransactionType()) {
                    case BGTransactionType.CARD -> COLUMN_ORDER_ID;
                    case BGTransactionType.QR_SBP -> "order_id";
                    default -> "";
                };
                return this.getParameter(value.getParameters(), key);
            }
            if (COLUMN_ERROR.equals(identifier)) {
                String errorCodeKey = "errorCode";
                String errorMessageKey = "errorMessage";
                String actionCodeDescription = "";
                if (value.getTransactionType() == BGTransactionType.QR_SBP) {
                    errorCodeKey = "error_code";
                    errorMessageKey = "error_message";
                } else if (value.getTransactionType() == BGTransactionType.CARD) {
                    actionCodeDescription = this.getParameter(value.getParameters(), "actionCodeDescription");
                }
                String errorCode = this.getParameter(value.getParameters(), errorCodeKey);
                String errorMessage = this.getParameter(value.getParameters(), errorMessageKey);
                return (String)(errorCode == null ? "" : "[#" + errorCode + "] ") + errorMessage + (String)(actionCodeDescription.isEmpty() ? "" : " (" + actionCodeDescription + ")");
            }
            if (COLUMN_APPROVAL_CODE.equals(identifier)) {
                String paramValue = this.getParameter(value.getParameters(), "cardAuthInfo.approvalCode");
                if (Utils.isBlankString((String)paramValue)) {
                    paramValue = this.getParameter(value.getParameters(), COLUMN_APPROVAL_CODE);
                }
                return paramValue;
            }
        }
        return super.getValue((Object)value, column);
    }
}

