/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.tariff.tree;

import java.math.BigDecimal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmServiceCost;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmTariffContext;
import ru.bitel.bgbilling.modules.rscm.server.tariff.RscmTariffRequest;
import ru.bitel.common.ParameterMap;

public class ServiceUnitCostTariffTreeNode
extends DefaultTariffTreeNode<RscmTariffRequest, RscmTariffContext> {
    private static final Logger log = LogManager.getLogger();
    private final BigDecimal cost;
    private final String costMode;
    private final BigDecimal divisor;
    private final int tariffVarId;

    public ServiceUnitCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.cost = parameterMap.getBigDecimal("cost", BigDecimal.ZERO);
        this.divisor = parameterMap.getBigDecimal("col", BigDecimal.ONE);
        this.costMode = parameterMap.get("costMode", "const");
        this.tariffVarId = parameterMap.getInt("tariffVarId", 0);
        if (log.isDebugEnabled()) {
            log.debug("cost = {}; divisor = {}; costMode = {}; tariffVarId = {}", (Object)this.cost, (Object)this.divisor, (Object)this.costMode, (Object)this.tariffVarId);
        }
    }

    protected int executeImpl(Long treeNodeId, RscmTariffRequest tariffRequest, RscmTariffContext tariffContext) {
        BigDecimal inCost = this.cost;
        log.debug("inCost = {}; costMode = {}; divisor = {}", (Object)inCost, (Object)this.costMode, (Object)this.divisor);
        if ("var".equals(this.costMode)) {
            ContractTariffVar contractTariffVar = tariffRequest.getContractTariffVar(this.tariffVarId);
            log.debug("contractTariffVar = {}; tariffVarId = {}", (Object)contractTariffVar, (Object)this.tariffVarId);
            if (contractTariffVar != null) {
                String value = contractTariffVar.getValue();
                inCost = new BigDecimal(value == null ? contractTariffVar.getDefaultValue() : value);
                log.debug("value = {}; inCost = {}", (Object)value, (Object)inCost);
            }
        }
        ((RscmServiceCost)tariffRequest.serviceCost).divisor = this.divisor;
        ((RscmServiceCost)tariffRequest.serviceCost).setCost(inCost);
        tariffRequest.setAccepted(true);
        return 1;
    }
}

