/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client.tariff;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatTextField;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class MonthAddModeCostTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"coin");
    private JLabel view;
    private int account;
    private String cost;
    private String type;
    private String accountTitle;
    private FloatTextField costTf;
    private BGComboBox<ComboBoxItem> typeCombo;
    private Directory dir;
    private BGComboBox<IdTitle> accountCombo;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.dir = this.getDirManager().getDirectory("module_accounts");
    }

    private void initEdit() {
        if (this.costTf == null) {
            this.costTf = new FloatTextField();
            this.typeCombo = new BGComboBox();
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"0", "\u0431\u0435\u0437\u0443\u0441\u043b\u043e\u0432\u043d\u043e"));
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"1", "\u043f\u0440\u043e\u043f\u043e\u0440\u0446. \u043f\u0435\u0440\u0438\u043e\u0434\u0443"));
            this.accountCombo = new BGComboBox(this.dir.getItems());
        }
    }

    protected JPanel getEditorPanel() {
        this.initEdit();
        JPanel edit = new JPanel();
        edit.add(new JLabel("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u044c "));
        edit.add((Component)this.accountCombo);
        edit.add(new JLabel(" \u0434\u043e "));
        edit.add((Component)this.costTf);
        edit.add(new JLabel(" "));
        edit.add((Component)this.typeCombo);
        return edit;
    }

    public Component getView() {
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.extractData();
        StringBuffer title = new StringBuffer();
        title.append("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u044c ");
        title.append(this.accountTitle);
        title.append(" \u0434\u043e ");
        title.append(this.cost);
        title.append(" ");
        if (this.type.equals("0")) {
            title.append("\u0431\u0435\u0437\u0443\u0441\u043b\u043e\u0432\u043d\u043e");
        } else if (this.type.equals("1")) {
            title.append("\u043f\u0440\u043e\u043f\u043e\u0440\u0446. \u043f\u0435\u0440\u0438\u043e\u0434\u0443");
        }
        this.view.setText(title.toString());
        return this.view;
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.cost = (String)data.get("cost");
        this.type = Utils.maskNull((String)((String)data.get("type")));
        this.account = Utils.parseInt((String)((String)data.get("account")), (int)0);
        this.accountTitle = this.dir.getValue(this.account);
    }

    protected void loadData() {
        this.extractData();
        this.costTf.setText(this.cost);
        ClientUtils.setComboBoxSelection(this.typeCombo, (Object)this.type);
        this.setDirectoryItemSelection((JComboBox)this.accountCombo, this.account);
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("cost", this.costTf.getText());
        data.put("type", ClientUtils.getIdFromComboBox(this.typeCombo));
        data.put("account", String.valueOf(this.getIdFromDirectoryCombo((JComboBox)this.accountCombo)));
        this.setDataInHash(data);
    }
}

