/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client;

import bitel.billing.module.common.ActualDateFilter;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDecimalTextField;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.common.service.NPayService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class ServicePropertiesPanel
extends ServicePanel {
    private BGUTable table = null;
    private ServiceObjectTableModel tableModel = new ServiceObjectTableModel(false);
    private ActualDateFilter filter = new ActualDateFilter((BGPanel)this);

    public ServicePropertiesPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.table = new BGUTable((TableModel)((Object)this.tableModel));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ServicePropertiesPanel.this.startEdit((ServiceObject)ServicePropertiesPanel.this.tableModel.getSelectedRow());
                }
            }
        });
        this.table.setComponentPopupMenu(this.getPopupMenu());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.filter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 3), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
    }

    public void init(int contractId, int moduleId, int objectId) {
        super.init(contractId, moduleId, objectId);
        if (objectId > 0) {
            this.tableModel = new ServiceObjectTableModel(true);
            this.table.setModel((TableModel)((Object)this.tableModel));
            this.table.invalidate();
        }
    }

    public void setData() {
        this.filter.updateDate();
        try {
            this.tableModel.setData(this.getNPayService().serviceObjectList(this.getContractId(), this.objectId, -1, -1, this.filter.isEnabled(), this.filter.getDate()));
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void deleteItem() {
        List serviceObjects = this.tableModel.getSelectedRows();
        if (serviceObjects == null || serviceObjects.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u0443(\u044b)?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            for (ServiceObject serviceObject : serviceObjects) {
                try {
                    this.getNPayService().serviceObjectDelete(serviceObject.getContractId(), serviceObject.getId());
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            this.setData();
        }
    }

    public void editItem() {
        this.startEdit((ServiceObject)this.tableModel.getSelectedRow());
    }

    public void newItem() {
        this.startEdit(ServiceObject.builder().setContractId(this.getContractId()).build());
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem transferItem = new JMenuItem("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        popupMenu.add(transferItem);
        transferItem.addActionListener(e -> {
            ServiceObject serviceObject = (ServiceObject)this.tableModel.getSelectedRow();
            if (serviceObject != null) {
                this.transferToContract("MovePay", "id", String.valueOf(serviceObject.getId()));
            }
        });
        JMenuItem wrapItem = new JMenuItem("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u0434\u0430\u0442\u044b");
        popupMenu.add(wrapItem);
        wrapItem.addActionListener(e -> {
            ServiceObject serviceObject = (ServiceObject)this.tableModel.getSelectedRow();
            if (serviceObject != null) {
                this.wrapToContract("WrapPay", "id", String.valueOf(serviceObject.getId()));
            }
        });
        return popupMenu;
    }

    private void startEdit(ServiceObject serviceObjectRow) {
        if (serviceObjectRow != null) {
            new ServiceObjectEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", serviceObjectRow).open();
            this.setData();
        }
    }

    private NPayService getNPayService() {
        return (NPayService)this.getContext().getWebService(NPayService.class);
    }

    private ModuleService getModuleService() {
        return (ModuleService)this.getContext().getWebService(ModuleService.class, 0);
    }

    class ServiceObjectTableModel
    extends BGTableModel<ServiceObject> {
        private boolean objectMode;

        public ServiceObjectTableModel(boolean objectMode) {
            super(ServiceObjectTableModel.class.getName());
            this.objectMode = false;
            this.objectMode = objectMode;
            this.reinitColumns();
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0423\u0441\u043b#ID", Integer.class, 50, 50, 50, "serviceId", true, false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 100, 100, -1, "serviceTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0426\u0435\u043d\u0430 \u0437\u0430 \u0435\u0434.", 100, 100, 100, "cost", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e", 80, 80, 80, "col", true, (TableCellRenderer)new DecimalTableCellRenderer("###,###,###,##0.000"));
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", false, (TableCellRenderer)new PeriodTableCellRenderer());
            if (!this.objectMode) {
                this.addColumn("\u041e\u0431\u044a\u0435\u043a\u0442", 100, 100, -1, "objectTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0421\u0443\u0449\u043d\u043e\u0441\u0442\u044c", Boolean.class, 70, 70, 70, "entity", true);
            }
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(ServiceObject serviceObject, int column) throws BGException {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "period": {
                    return new Period(serviceObject.getDate1(), serviceObject.getDate2());
                }
                case "entity": {
                    return serviceObject.getEntityMid() > 0;
                }
                case "cost": {
                    return serviceObject.getCost() != null ? serviceObject.getCost() : "\u043f\u043e \u0442\u0430\u0440\u0438\u0444\u0443";
                }
            }
            return super.getValue((Object)serviceObject, column);
        }
    }

    class ServiceObjectEditor
    extends BGEditorDialog<ServiceObject> {
        private JTabbedPane tabbedPane;
        private List<Service> serviceList;
        private BGDecimalTextField col;
        private BGDecimalTextField cost;
        private BGUList<IdTitle> services;
        private BGUList<IdTitle> serviceSets;
        private BGComboBox<ComboBoxItem> objectCombo;
        private BGControlPanelPeriodNoB servicePeriod;
        private BGTextArea comment;
        private JCheckBox showAllObj;
        private JCheckBox filterActive;
        private JCheckBox filterUsed;

        public ServiceObjectEditor(String title, ServiceObject data) {
            super(title, (Object)data);
            this.serviceList = null;
            this.col = new BGDecimalTextField(10);
            this.cost = new BGDecimalTextField(10);
            this.services = new BGUList();
            this.serviceSets = new BGUList();
            this.objectCombo = new BGComboBox();
            this.servicePeriod = new BGControlPanelPeriodNoB();
            this.comment = new BGTextArea();
            this.showAllObj = new JCheckBox("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b");
            this.filterActive = new JCheckBox("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u043c\u0443 \u043f\u0435\u0440\u0438\u043e\u0434\u0443");
            this.filterUsed = new JCheckBox("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0444\u043b\u0430\u0433\u0443 \"\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f\"");
        }

        public void doDialogPanel() {
            int gridx = 0;
            this.panel.add((Component)this.getServicePanel(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.panel.add((Component)this.getParameterPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            try {
                this.serviceSets.setData(ServicePropertiesPanel.this.getNPayService().serviceSetList());
                this.serviceList = ServicePropertiesPanel.this.getModuleService().moduleServiceList(ServicePropertiesPanel.this.getContext().getModuleId());
                this.setServiceListData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.services.setSelectionMode(0);
            this.services.addListSelectionListener(e -> {
                if (this.tabbedPane.getSelectedIndex() == 1) {
                    this.serviceSets.clearSelection();
                }
            });
            this.serviceSets.addListSelectionListener(e -> {
                if (this.tabbedPane.getSelectedIndex() == 0) {
                    this.services.clearSelection();
                    this.services.setSelectedIndex(-1);
                }
            });
            String oid = "0";
            if (((ServiceObject)this.data).getId() < 1) {
                this.servicePeriod.setDateCalendar1((Calendar)new GregorianCalendar());
                this.servicePeriod.setDateCalendar2(null);
                this.col.setText("1");
                this.cost.setText("");
                this.comment.setText("");
            } else {
                try {
                    ServiceObject serviceObject = ServicePropertiesPanel.this.getNPayService().serviceObjectGet(((ServiceObject)this.data).getId());
                    if (serviceObject != null) {
                        oid = String.valueOf(serviceObject.getObjectId());
                        this.cost.setText(Optional.ofNullable(serviceObject.getCost()).map(a -> Utils.formatBigDecimal((BigDecimal)a, (int)2)).orElse(""));
                        this.col.setText(String.valueOf(serviceObject.getCol()));
                        this.servicePeriod.setPeriod(new Period(serviceObject.getDate1(), serviceObject.getDate2()));
                        this.comment.setText(serviceObject.getComment());
                        int serviceId = serviceObject.getServiceId();
                        this.services.setSelectedId(serviceId, true);
                    }
                }
                catch (Exception e2) {
                    ClientUtils.showErrorMessageDialog((Throwable)e2);
                }
            }
            this.services.setEnabled(((ServiceObject)this.data).getId() == 0);
            this.serviceSets.setEnabled(((ServiceObject)this.data).getId() == 0);
            ServicePropertiesPanel.this.buildObjectCombo(this.objectCombo, this.showAllObj.isSelected(), oid);
            this.showAllObj.setEnabled(this.objectCombo.isEnabled());
            this.tabbedPane.setSelectedIndex(((ServiceObject)this.data).getId() == 0 ? 0 : 1);
        }

        public boolean doApply() throws Exception {
            String oid = ClientUtils.getIdFromComboBox(this.objectCombo);
            IdTitle serviceValue = (IdTitle)this.services.getSelectedValue();
            String colValue = this.col.getText();
            if (Utils.isBlankString((String)colValue)) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e!");
                return false;
            }
            HashSet<String> serviceIds = new HashSet<String>();
            if (serviceValue != null) {
                serviceIds.add(String.valueOf(serviceValue.getId()));
            }
            for (IdTitle listItem : this.serviceSets.getSelectedValuesList()) {
                serviceIds.addAll(ServicePropertiesPanel.this.getNPayService().serviceSetGet(listItem.getId()));
            }
            for (String serviceId : serviceIds) {
                if (Utils.isBlankString((String)this.servicePeriod.getDateString1())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                    return false;
                }
                ((ServiceObject)this.data).setServiceId(Utils.parseInt((String)serviceId));
                ((ServiceObject)this.data).setCost(Utils.parseBigDecimal((String)this.cost.getText(), null));
                ((ServiceObject)this.data).setCol(Utils.parseBigDecimal((String)colValue, (BigDecimal)BigDecimal.ONE));
                ((ServiceObject)this.data).setDate1(this.servicePeriod.getDateFrom());
                ((ServiceObject)this.data).setDate2(this.servicePeriod.getDateTo());
                ((ServiceObject)this.data).setComment(this.comment.getText());
                ((ServiceObject)this.data).setObjectId(ServicePropertiesPanel.this.objectId > 0 ? ServicePropertiesPanel.this.objectId : Utils.parseInt((String)oid));
                ServicePropertiesPanel.this.getNPayService().serviceObjectUpdate(((ServiceObject)this.data).getContractId(), (ServiceObject)this.data);
            }
            return true;
        }

        private JPanel getServicePanel() {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add((Component)this.getListPanel(this.serviceSets, null), "\u041d\u0430\u0431\u043e\u0440\u044b \u0443\u0441\u043b\u0443\u0433");
            this.tabbedPane.add((Component)this.getListPanel(this.services, this.getServiceFilterPanel()), "\u0423\u0441\u043b\u0443\u0433\u0438");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            return panel;
        }

        private JPanel getListPanel(BGUList<?> list, JPanel filterPanel) {
            Dimension dimension = new Dimension(500, 250);
            JScrollPane scrollPane = new JScrollPane((Component)list);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            if (filterPanel != null) {
                panel.add((Component)filterPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            }
            return panel;
        }

        private JPanel getServiceFilterPanel() {
            this.filterActive.addChangeListener(e -> this.setServiceListData());
            this.filterUsed.addChangeListener(e -> this.setServiceListData());
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.filterActive, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            panel.add((Component)this.filterUsed, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            return panel;
        }

        private void setServiceListData() {
            boolean active = this.filterActive.isSelected();
            boolean used = this.filterUsed.isSelected();
            LocalDate now = LocalDate.now();
            ArrayList<IdTitle> items = new ArrayList<IdTitle>();
            for (Service service : this.serviceList) {
                if (used && (!used || !service.isUsing()) || active && (!active || !TimeUtils.dateInPeriod((LocalDate)now, (Period)service.getActivePeriod()))) continue;
                items.add(new IdTitle(service.getId(), service.getTitle()));
            }
            this.services.setData(items);
        }

        private JPanel getParameterPanel() {
            this.showAllObj.addActionListener(e -> {
                ServicePropertiesPanel.this.buildObjectCombo(this.objectCombo, this.showAllObj.isSelected(), "0");
                this.showAllObj.setEnabled(this.objectCombo.isEnabled());
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getPeriodColPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041e\u0431\u044a\u0435\u043a\u0442:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)this.objectCombo, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.showAllObj, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0426\u0435\u043d\u0430 \u0437\u0430 \u0435\u0434.(\u043e\u043f\u0446\u0438\u043e\u043d., \u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434. \u0446\u0435\u043d\u0443 \u0438\u0437 \u0442\u0430\u0440\u0438\u0444\u0430):"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)this.cost, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane((Component)this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getPeriodColPanel() {
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:"), new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
            panel.add((Component)this.servicePeriod, new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.col, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 10, 0, 0), 0, 0));
            return panel;
        }
    }
}

