/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.notification.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.notification.common.bean.ContractNotification;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractNotificationDao
extends AbstractIdDao<ContractNotification> {
    private static final Logger logger = LogManager.getLogger();
    private static final String TABLE_NAME = "contract_notification";

    public ContractNotificationDao(Connection con) {
        super(con, 0, TABLE_NAME);
    }

    public List<ContractNotification> list(int contractId) throws BGException {
        return super.list("cid=?", "dt DESC", new Object[]{contractId});
    }

    public int getUnreadNotificationsCount(int contractId) {
        int count = 0;
        try {
            String query = "SELECT COUNT(id) FROM contract_notification WHERE cid=? AND is_read=0";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            ps.close();
        }
        catch (SQLException e) {
            logger.error("ContractNotificationManager.getNewNotificationsCount( " + contractId + " )", (Throwable)e);
        }
        return count;
    }

    protected ContractNotification getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractNotification notice = new ContractNotification();
        notice.setId(rs.getInt("id"));
        notice.setContractId(rs.getInt("cid"));
        notice.setDateTime((Date)rs.getTimestamp("dt"));
        notice.setSubject(rs.getString("subject"));
        notice.setMessage(rs.getString("message"));
        notice.setRead(rs.getBoolean("is_read"));
        return notice;
    }

    protected void updateImpl(ContractNotification notice) throws BGException {
        Objects.requireNonNull(notice);
        boolean update = notice.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + "contract_notification SET subject=?, message=?, cid=?, is_read=?" + (update ? " WHERE id=?" : ", dt=NOW()");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, notice.getSubject());
            ps.setString(index++, notice.getMessage());
            ps.setInt(index++, notice.getContractId());
            ps.setInt(index++, notice.isRead() ? 1 : 0);
            if (update) {
                ps.setInt(index++, notice.getId());
            }
            ps.executeUpdate();
            if (!update) {
                notice.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public boolean markReadNotification(int contractId, int id) throws BGException {
        boolean bl;
        block8: {
            PreparedStatement ps = this.con.prepareStatement("UPDATE contract_notification SET is_read=? WHERE id=? AND cid=?");
            try {
                ps.setInt(1, 1);
                ps.setInt(2, id);
                ps.setInt(3, contractId);
                boolean bl2 = bl = ps.executeUpdate() > 0;
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            ps.close();
        }
        return bl;
    }
}

