/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGThrowingConsumer;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.GroupParent;
import ru.bitel.common.function.TryCall;
import ru.bitel.common.function.TryCallBoolean;

public abstract class AbstractBGUPanel<C, P extends AbstractBGUPanel<C, P>>
extends JPanel {
    public static final String NEW = "new";
    public static final String EDIT = "edit";
    public static final String DELETE = "delete";
    public static final String INIT = "init";
    public static final String REFRESH = "refresh";
    public static final String MOVE_UP = "move_up";
    public static final String MOVE_DOWN = "move_down";
    public static final String OK = "ok";
    public static final String CLOSE = "close";
    public static final String CANCEL = "cancel";
    public static final String RESET = "reset";
    public static final String IMPORT = "import";
    public static final String EXPORT = "export";
    public static final Icon ICON_NEW = ClientUtils.getIcon("item_add");
    public static final Icon ICON_EDIT = ClientUtils.getIcon("item_edit");
    public static final Icon ICON_DELETE = ClientUtils.getIcon("item_delete");
    public static final Icon ICON_REFRESH = ClientUtils.getIcon("refresh");
    protected volatile boolean initData = false;
    private C context;
    private volatile C initContext;
    private volatile boolean jbInited = false;
    private volatile boolean inited = false;
    private List<Runnable> afterJbInitTasks = new ArrayList<Runnable>();
    private Future<P> worker = null;

    protected void initAction(DefaultAction action, String command, KeyStroke stroke) {
    }

    protected void tryCall(TryCall tryCall) {
        tryCall.call();
    }

    protected boolean tryCallBoolean(TryCallBoolean tryCall) {
        return tryCall.call();
    }

    protected void actionPerformed(DefaultAction action, ActionEvent e) {
        try {
            action.actionPerformedImpl(e);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
    }

    protected void processException(Throwable e) {
        e.printStackTrace();
    }

    protected boolean isJbInited() {
        return this.jbInited;
    }

    protected void beforeAsyncJbInit(C initContext) {
    }

    protected void afterAsyncJbInit() {
    }

    protected void afterJbInit() {
        new ArrayList<Runnable>(this.afterJbInitTasks).forEach(a -> a.run());
    }

    public void addAfterJbInitTask(Runnable runnable) {
        if (this.jbInited) {
            runnable.run();
        } else {
            this.afterJbInitTasks.add(runnable);
        }
    }

    public AbstractBGUPanel() {
        this.init0();
    }

    public AbstractBGUPanel(LayoutManager layout) {
        super(layout);
        this.init0();
    }

    public AbstractBGUPanel(C context) {
        this.context = context;
        this.init0();
    }

    public AbstractBGUPanel(LayoutManager layout, C context) {
        super(layout);
        this.context = context;
        this.init0();
    }

    private void init0() {
        String name = this.getClass().getSimpleName();
        name = name == null || name.length() == 0 ? name : name.substring(0, 1).toLowerCase() + name.substring(1);
        this.setName(name);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getID() == 1400) {
                    if (e.getChangeFlags() == 1L) {
                        if (!AbstractBGUPanel.this.jbInited && !Boolean.TRUE.equals(AbstractBGUPanel.this.getClientProperty(BGEditor.class))) {
                            AbstractBGUPanel.this.build();
                        }
                    } else if (e.getChangeFlags() == 4L && e.getChanged().isVisible()) {
                        if (!AbstractBGUPanel.this.jbInited) {
                            AbstractBGUPanel.this.removeHierarchyListener(this);
                        }
                        AbstractBGUPanel.this.shownNotify();
                    }
                }
            }
        });
    }

    protected void shownNotify() {
    }

    protected void init() {
        if (!this.inited) {
            this.inited = true;
            this.initActions();
        }
    }

    protected void initActions() {
    }

    public C getContext() {
        if (this.context != null) {
            return this.context;
        }
        Container parent = this;
        while ((parent = parent.getParent()) != null) {
            if (parent instanceof AbstractBGUPanel) {
                this.context = ((AbstractBGUPanel)parent).getContext();
                return this.context;
            }
            this.context = this.innerGetContext(parent);
            if (this.context == null) continue;
            return this.context;
        }
        this.context = this.innerGetContext(null);
        return this.context;
    }

    protected C innerGetContext(Container parent) {
        return null;
    }

    public ClientContext getKernelContext() {
        return new ClientContext("kernel", 0, -1, null);
    }

    protected void build() {
        if (!this.jbInited) {
            if (this.worker == null) {
                try {
                    this.init();
                    this.jbInit();
                    this.afterJbInit();
                    this.validate();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
                this.jbInited = true;
            } else {
                try {
                    this.worker.get();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        }
    }

    protected Future<P> buildAsync1() {
        this.build();
        if (!this.jbInited) {
            if (this.worker == null) {
                this.init();
                this.initContext = this.getContext();
                Worker w = new Worker();
                w.execute();
                this.worker = w;
                return this.worker;
            }
            return this.worker;
        }
        this.worker = new Future<P>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public P get() throws InterruptedException, ExecutionException {
                return AbstractBGUPanel.this;
            }

            @Override
            public P get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return AbstractBGUPanel.this;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }
        };
        return this.worker;
    }

    public void performActionClose() {
        this.getActionMap().get(CLOSE).actionPerformed(new ActionEvent(this, 1001, CLOSE));
    }

    public void performActionOpen() {
        this.getActionMap().get("open").actionPerformed(new ActionEvent(this, 1001, "open"));
    }

    public boolean performAction(String action) {
        return this.performAction(action, action);
    }

    protected boolean performAction(String action, String command) {
        if (!this.performAction(null, action, command)) {
            ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
            return false;
        }
        return true;
    }

    public boolean performAction(Object source, String action, String command) {
        Action instance = this.getActionMap().get(action);
        if (instance == null && INIT.equals(action)) {
            instance = this.getActionMap().get(REFRESH);
        }
        if (instance != null) {
            if (source == null) {
                source = this;
            }
            instance.actionPerformed(new ActionEvent(source, 1001, command));
            return true;
        }
        return this.performActionDeep(this, action, command);
    }

    private boolean performActionDeep(JComponent comp, String action, String command) {
        for (Component c : comp.getComponents()) {
            if (c instanceof GroupParent || !(c instanceof AbstractBGUPanel ? ((AbstractBGUPanel)c).performAction(null, action, command) : c instanceof JComponent && this.performActionDeep((JComponent)c, action, command))) continue;
            return true;
        }
        return false;
    }

    protected abstract void jbInit() throws Exception;

    public abstract class DefaultAction
    extends BGUAction {
        public DefaultAction(String command, String name) {
            super((JComponent)AbstractBGUPanel.this, command, name, new String[0]);
        }

        public DefaultAction(String command, String name, KeyStroke stroke) {
            super((JComponent)AbstractBGUPanel.this, command, name, stroke, new String[0]);
        }

        public DefaultAction(String command, String name, Icon icon) {
            super((JComponent)AbstractBGUPanel.this, command, name, icon, new String[0]);
        }

        public DefaultAction(String command, String name, KeyStroke stroke, Icon icon) {
            super((JComponent)AbstractBGUPanel.this, command, name, stroke, icon, new String[0]);
        }

        public Action getParentAction() {
            return this.getParentAction(AbstractBGUPanel.this);
        }

        @Override
        protected void init(JComponent panel, String command, KeyStroke stroke) {
            super.init(panel, command, stroke);
            AbstractBGUPanel.this.initAction(this, command, stroke);
        }

        public DefaultAction setIcon(Icon icon) {
            this.putValue("SmallIcon", icon);
            return this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractBGUPanel.this.actionPerformed(this, e);
        }

        public abstract void actionPerformedImpl(ActionEvent var1) throws Exception;

        public void perform() {
            this.perform(null, null);
        }

        public void perform(Object source) {
            this.perform(source, null);
        }

        public void perform(Object source, String command) {
            if (source == null) {
                source = this;
            }
            this.actionPerformed(new ActionEvent(source, 1001, command));
        }
    }

    class Worker
    extends SwingWorker<P, Object> {
        Worker() {
        }

        @Override
        protected P doInBackground() throws Exception {
            try {
                AbstractBGUPanel.this.beforeAsyncJbInit(AbstractBGUPanel.this.initContext);
                AbstractBGUPanel.this.jbInit();
                AbstractBGUPanel.this.afterAsyncJbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return AbstractBGUPanel.this;
        }

        @Override
        protected void done() {
            AbstractBGUPanel.this.jbInited = true;
            AbstractBGUPanel.this.worker = null;
            AbstractBGUPanel.this.validate();
        }
    }

    public abstract class AsyncAction<B>
    extends DefaultAction {
        public AsyncAction(String command, String name) {
            super(command, name);
        }

        public AsyncAction(String command, String name, KeyStroke stroke) {
            super(command, name, stroke);
        }

        public AsyncAction(String command, String name, Icon icon) {
            super(command, name, icon);
        }

        public AsyncAction(String command, String name, KeyStroke stroke, Icon icon) {
            super(command, name, stroke, icon);
        }

        @Override
        protected void init(JComponent panel, String command, KeyStroke stroke) {
            this.putValue("Action.MenuAction", Boolean.TRUE);
            super.init(panel, command, stroke);
        }

        protected abstract B doInBackground() throws Exception;

        protected abstract void done(B var1) throws Exception;

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            new SwingWorker<B, Void>(){

                @Override
                protected B doInBackground() throws Exception {
                    return AsyncAction.this.doInBackground();
                }

                @Override
                protected void done() {
                    try {
                        AsyncAction.this.done(this.get());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        AbstractBGUPanel.this.processException(e.getCause());
                    }
                    catch (Exception e) {
                        AbstractBGUPanel.this.processException(e);
                    }
                }
            }.execute();
        }
    }

    public abstract class MenuAction
    extends DefaultAction {
        public MenuAction(String command, String name) {
            super(command, name);
        }

        public MenuAction(String command, String name, KeyStroke stroke) {
            super(command, name, stroke);
        }

        public MenuAction(String command, String name, Icon icon) {
            super(command, name, icon);
        }

        public MenuAction(String command, String name, KeyStroke stroke, Icon icon) {
            super(command, name, stroke, icon);
        }

        @Override
        protected void init(JComponent panel, String command, KeyStroke stroke) {
            this.putValue("Action.MenuAction", Boolean.TRUE);
            super.init(panel, command, stroke);
        }
    }

    public class BGDefaultAction
    extends DefaultAction {
        private String name;
        private BGThrowingConsumer consumer;

        public BGDefaultAction(String command, String name, BGThrowingConsumer consumer) {
            super(command, name);
            this.name = name;
            this.consumer = consumer;
        }

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (AbstractBGUPanel.INIT.equals(this.name) && AbstractBGUPanel.this.initData) {
                return;
            }
            this.consumer.accept(e);
        }

        @Override
        public void setEnabled(boolean newValue) {
            super.setEnabled(newValue);
        }
    }

    public class BGActionItemDelete
    extends BGDefaultAction {
        public BGActionItemDelete(BGThrowingConsumer consumer) {
            super("item.delete", "item.delete", consumer);
            this.setIcon(ClientUtils.getIcon("item_delete.png"));
        }
    }

    public class BGActionItemEdit
    extends BGDefaultAction {
        public BGActionItemEdit(BGThrowingConsumer consumer) {
            super("item.edit", "item.edit", consumer);
            this.setIcon(ClientUtils.getIcon("item_edit.png"));
        }
    }

    public class BGActionItemAdd
    extends BGDefaultAction {
        public BGActionItemAdd(BGThrowingConsumer consumer) {
            super("item.add", "item.add", consumer);
            this.setIcon(ClientUtils.getIcon("item_add.png"));
        }
    }

    public class BGActionDelete
    extends BGDefaultAction {
        public BGActionDelete(BGThrowingConsumer consumer) {
            super(AbstractBGUPanel.DELETE, AbstractBGUPanel.DELETE, consumer);
        }

        public BGActionDelete(String prefix, String name, BGThrowingConsumer consumer) {
            super(prefix + ".delete", name, consumer);
        }
    }

    public class BGActionEdit
    extends BGDefaultAction {
        public BGActionEdit(BGThrowingConsumer consumer) {
            super(AbstractBGUPanel.EDIT, AbstractBGUPanel.EDIT, consumer);
        }

        public BGActionEdit(String prefix, String name, BGThrowingConsumer consumer) {
            super(prefix + ".edit", name, consumer);
        }
    }

    public class BGActionNew
    extends BGDefaultAction {
        public BGActionNew(BGThrowingConsumer consumer) {
            super(AbstractBGUPanel.NEW, AbstractBGUPanel.NEW, consumer);
        }

        public BGActionNew(String prefix, String name, BGThrowingConsumer consumer) {
            super(prefix + ".new", name, consumer);
        }
    }

    public class BGActionInit
    extends BGDefaultAction {
        public BGActionInit(BGThrowingConsumer consumer) {
            super(AbstractBGUPanel.INIT, AbstractBGUPanel.INIT, consumer);
        }
    }

    public class BGActionRefresh
    extends BGDefaultAction {
        public BGActionRefresh(BGThrowingConsumer consumer) {
            super(AbstractBGUPanel.REFRESH, AbstractBGUPanel.REFRESH, consumer);
        }

        public BGActionRefresh(String prefix, String name, BGThrowingConsumer consumer) {
            super(prefix + ".refresh", name, consumer);
        }
    }
}

