/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import bitel.billing.server.tariff.TariffModuleTree;
import bitel.billing.server.tariff.TariffTreeBuilder;
import bitel.billing.server.tariff.TariffTreesCache;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public final class TariffTreeSet {
    private final String _module;
    private final int _mid;
    private TariffTreeBuilder _ttb;
    private List<TariffSetEntry> _tariffEntriesList = new ArrayList<TariffSetEntry>();
    private boolean _useCache = false;

    public TariffTreeSet(String module, int moduleId, TariffTreeBuilder tariffTreeBuilder, int contractId, boolean useCache) {
        this._useCache = useCache;
        this._ttb = tariffTreeBuilder;
        this._mid = moduleId;
        this._module = module;
    }

    private TariffModuleTree getModuleTree(int treeID, int mid, String module) {
        TariffModuleTree result = null;
        if (treeID >= 0 && mid >= 0) {
            if (this._useCache) {
                result = TariffTreesCache.getCache().getTreeFromCache(this._ttb, treeID, mid);
            }
            if (result == null) {
                result = new TariffModuleTree(module, treeID, mid);
                if (!result.load(this._ttb)) {
                    result = null;
                } else if (this._useCache) {
                    TariffTreesCache.getCache().putTreeToCache(result);
                }
            }
        } else {
            System.err.println("TariffTreeSet:getModuleTree treeID or mid incorrect!");
        }
        return result;
    }

    public void addTariffTree(int treeId, int emid, int eid, Date dateFrom, Date dateTo) {
        TariffModuleTree moduleTree;
        if (treeId > 0 && (moduleTree = this.getModuleTree(treeId, this._mid, this._module)) != null) {
            TariffSetEntry entry = new TariffSetEntry(dateFrom, dateTo, moduleTree, emid, eid);
            this._tariffEntriesList.add(entry);
        }
    }

    public TariffModuleTree getTree(Date date) {
        TariffSetEntry tse;
        TariffModuleTree result = null;
        Iterator<TariffSetEntry> iterator = this._tariffEntriesList.iterator();
        while (iterator.hasNext() && (result = (tse = iterator.next()).getTreeForDate(date)) == null) {
        }
        return result;
    }

    @Deprecated
    public TariffModuleTree getTree(Calendar date) {
        return this.getTree(date.getTime());
    }

    public TariffSetEntry getTreeEntry(Calendar date) {
        TariffSetEntry result = null;
        for (TariffSetEntry tse : this._tariffEntriesList) {
            if (!tse.isActualOnDate(date)) continue;
            result = tse;
            break;
        }
        return result;
    }

    public List<TariffModuleTree> getTreeList() {
        ArrayList<TariffModuleTree> result = new ArrayList<TariffModuleTree>();
        for (TariffSetEntry tse : this._tariffEntriesList) {
            result.add(tse.getTree());
        }
        return result;
    }

    public List<TariffModuleTree> getTreeList(Date date) {
        ArrayList<TariffModuleTree> result = new ArrayList<TariffModuleTree>();
        for (TariffSetEntry tse : this._tariffEntriesList) {
            TariffModuleTree tree = tse.getTreeForDate(date);
            if (tree == null) continue;
            result.add(tree);
        }
        return result;
    }

    @Deprecated
    public List<TariffModuleTree> getTreeList(Calendar date) {
        return date != null ? this.getTreeList(date.getTime()) : this.getTreeList();
    }

    public List<TariffSetEntry> getTreeEntryList(Calendar date) {
        ArrayList<TariffSetEntry> result = new ArrayList<TariffSetEntry>();
        for (TariffSetEntry tse : this._tariffEntriesList) {
            if (!tse.isActualOnDate(date)) continue;
            result.add(tse);
        }
        return result;
    }

    public List<TariffModuleTree> getTreeList(int emid, int eid) {
        ArrayList<TariffModuleTree> result = new ArrayList<TariffModuleTree>();
        for (TariffSetEntry tse : this._tariffEntriesList) {
            if (tse.getEmid() != 0 && tse.getEmid() != emid || tse.getEid() != 0 && tse.getEid() != eid) continue;
            result.add(tse.getTree());
        }
        return result;
    }

    public List<TariffSetEntry> getEntries() {
        return this._tariffEntriesList;
    }

    public static final class TariffSetEntry {
        private Date dateFrom;
        private Date dateTo;
        private final int eid;
        private final int emid;
        private final TariffModuleTree tree;

        public TariffSetEntry(Date from, Date to, TariffModuleTree tree, int emid, int eid) {
            this.dateFrom = from;
            this.dateTo = to;
            this.tree = tree;
            this.eid = eid;
            this.emid = emid;
        }

        public Date getDateFrom() {
            return this.dateFrom;
        }

        public Date getDateTo() {
            return this.dateTo;
        }

        public void setDateFrom(Date dateFrom) {
            this.dateFrom = dateFrom;
        }

        public void setDateTo(Date dateTo) {
            this.dateTo = dateTo;
        }

        public int getEid() {
            return this.eid;
        }

        public int getEmid() {
            return this.emid;
        }

        public TariffModuleTree getTreeForDate(Date date) {
            TariffModuleTree result = null;
            if (this.isActualOnDate(date)) {
                result = this.tree;
            }
            return result;
        }

        @Deprecated
        public TariffModuleTree getTreeForDate(Calendar date) {
            return this.getTreeForDate(date.getTime());
        }

        public float getPartOnPeriod(Calendar periodFrom, Calendar periodTo) {
            return TimeUtils.getPart(TimeUtils.convertDateToCalendar(this.dateFrom), TimeUtils.convertDateToCalendar(this.dateTo), periodFrom, periodTo);
        }

        public float getPartOnPeriod(Calendar periodFrom, Calendar periodTo, List<Period> suspendPeriodList) {
            Calendar toDate;
            Calendar fromDate = TimeUtils.convertDateToCalendar(this.dateFrom);
            if (fromDate == null || TimeUtils.dateBefore(fromDate, periodFrom)) {
                fromDate = periodFrom;
            }
            if ((toDate = TimeUtils.convertDateToCalendar(this.dateTo)) == null || TimeUtils.dateBefore(periodTo, toDate)) {
                toDate = periodTo;
            }
            int day1 = fromDate.get(5);
            int result = TimeUtils.daysDelta(fromDate, toDate) + 1;
            BitSet days = new BitSet();
            days.set(day1, day1 + result);
            BitSet daysSuspended = new BitSet();
            if (suspendPeriodList != null) {
                int size = suspendPeriodList.size();
                for (int i = 0; i < size; ++i) {
                    Calendar to;
                    Period p = suspendPeriodList.get(i);
                    Calendar from = p.getDateFromCalendar();
                    if (from == null || from.compareTo(fromDate) < 0) {
                        from = fromDate;
                    }
                    if ((to = p.getDateToCalendar()) == null || to.compareTo(toDate) > 0) {
                        to = toDate;
                    }
                    int dim = TimeUtils.daysDelta(fromDate, from);
                    result = TimeUtils.daysDelta(from, to) + 1;
                    if (result <= 0) continue;
                    daysSuspended.set(day1 + dim, day1 + dim + result);
                }
            }
            days.andNot(daysSuspended);
            int daysCount = days.cardinality();
            return (float)daysCount / (float)(TimeUtils.daysDelta(periodFrom, periodTo) + 1);
        }

        public boolean isActualOnDate(Date date) {
            return !(this.tree == null || date == null || this.dateFrom != null && !TimeUtils.dateBeforeOrEq(this.dateFrom, date) || this.dateTo != null && !TimeUtils.dateBeforeOrEq(date, this.dateTo));
        }

        @Deprecated
        public boolean isActualOnDate(Calendar date) {
            return this.isActualOnDate(date.getTime());
        }

        public TariffModuleTree getTree() {
            return this.tree;
        }
    }
}

