/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server.bean;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class DynamicCodeDao {
    public static final String SOURCE_ENCODING = "UTF-8";
    public static final Pattern RESOURCE_REGEXP_BLACKLIST = Pattern.compile("^.+\\.bak$|^.+\\.bak\\.\\d+$");
    private Connection con;

    public DynamicCodeDao(Connection con) {
        this.con = con;
    }

    public static final String getScriptsDir() {
        Setup setup = Setup.getSetup();
        return setup.get("dynamic.src.dir", setup.get("dyn.src.dir", "dyn"));
    }

    public byte[] getClassData(String className) throws ClassNotFoundException {
        byte[] classData = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT data FROM script_classes WHERE name=?");){
            ps.setString(1, className);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    classData = rs.getBytes(1);
                }
            }
        }
        catch (SQLException ex) {
            throw new ClassNotFoundException(className + " not found in DB ( table 'script_classes' )");
        }
        return classData;
    }

    public static String getClassSource(String className) throws BGException {
        try {
            return Files.readString(DynamicCodeDao.getClassFile(className).toPath());
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public synchronized void updateClassData(String className, byte[] data, long lastModified) throws BGException {
        try {
            String query = "UPDATE script_classes SET data=?, last_mod=? WHERE name=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setBlob(1, new ByteArrayInputStream(data));
            ps.setLong(2, lastModified);
            ps.setString(3, className);
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = "INSERT INTO script_classes SET data=?, last_mod=?, name=?";
                ps = this.con.prepareStatement(query);
                ps.setBlob(1, new ByteArrayInputStream(data));
                ps.setLong(2, lastModified);
                ps.setString(3, className);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public static void updateClassSource(String className, String data) throws BGException {
        File src = DynamicCodeDao.getClassFile(className);
        try {
            if (src.exists()) {
                DynamicCodeDao.backup(className);
            } else {
                src.getParentFile().mkdirs();
                src.createNewFile();
            }
            Files.writeString(src.toPath(), (CharSequence)data, Charset.forName(SOURCE_ENCODING), new OpenOption[0]);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private static void backup(String className) throws IOException, BGException {
        File bak = DynamicCodeDao.getClassBakFile(className);
        bak.createNewFile();
        DynamicCodeDao.writeDataToFile(bak, DynamicCodeDao.getClassSource(className));
    }

    public static void restoreSourcesFromBackup(String className) throws BGException {
        File bak = DynamicCodeDao.getClassBakFile(className);
        if (bak.exists()) {
            File src = DynamicCodeDao.getClassFile(className);
            try {
                DynamicCodeDao.writeDataToFile(src, Files.readString(bak.toPath()));
                bak.delete();
            }
            catch (IOException ex) {
                throw new BGException(ex);
            }
        }
    }

    public static void deleteSourcesBackup(String className) {
        File bak = DynamicCodeDao.getClassBakFile(className);
        if (bak.exists()) {
            bak.delete();
        }
    }

    public List<DynamicClass> getDynamicClasses() throws Exception {
        ArrayList<DynamicClass> result = new ArrayList<DynamicClass>();
        File scripts = new File(DynamicCodeDao.getScriptsDir());
        this.traverse(result, scripts, "");
        for (DynamicClass clazz : result) {
            this.markIfUpdated(clazz);
        }
        return result;
    }

    private void markIfUpdated(DynamicClass clazz) throws BGException {
        if (!clazz.isJavaSource()) {
            clazz.setNeedsRecompile(false);
            return;
        }
        try {
            String query = "SELECT last_mod FROM script_classes WHERE name=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, clazz.getClassName());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                clazz.setNeedsRecompile(rs.getLong(1) != clazz.getLastModified());
            } else {
                clazz.setNeedsRecompile(true);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    private void traverse(List<DynamicClass> classes, File directory, String prefix) {
        for (File file : directory.listFiles()) {
            int i;
            if (file.isDirectory() && !file.getName().startsWith(".")) {
                this.traverse(classes, file, prefix + file.getName() + ".");
                continue;
            }
            if (file.getName().endsWith(".java")) {
                classes.add(new DynamicClass(prefix + file.getName().substring(0, file.getName().length() - 5), file.lastModified()));
                continue;
            }
            if (RESOURCE_REGEXP_BLACKLIST.matcher(file.getName().toLowerCase()).matches() || (i = file.getName().indexOf(46)) == -1) continue;
            String extension = i > 0 ? file.getName().substring(i + 1) : "";
            classes.add(new DynamicClass(prefix + file.getName().substring(0, file.getName().length() - extension.length() - 1), file.lastModified(), extension));
        }
    }

    public static File getClassFile(String className) {
        return DynamicClass.getClassFile(DynamicCodeDao.getScriptsDir(), className);
    }

    private static File getClassBakFile(String className) {
        String path = className.replace('.', File.separatorChar);
        return new File(DynamicCodeDao.getScriptsDir(), path + ".bak");
    }

    private static void writeDataToFile(File file, String data) throws IOException {
        file.createNewFile();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), SOURCE_ENCODING);
        writer.write(data);
        writer.flush();
        writer.close();
    }

    public void updateClassInterfaces(Class<?> clazz) throws BGException {
        HashSet interfaces = new HashSet();
        this.traverseClasses(interfaces, clazz);
        try {
            String query = "DELETE FROM script_classes_ifaces WHERE name=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, clazz.getName());
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO script_classes_ifaces(name,iface) VALUES(?,?)";
            ps = this.con.prepareStatement(query);
            for (Class clazz2 : interfaces) {
                ps.setString(1, clazz.getName());
                ps.setString(2, clazz2.getName());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    private void traverseClasses(Set<Class<?>> interfaces, Class<?> clazz) {
        for (Class<?> iface : clazz.getInterfaces()) {
            interfaces.add(iface);
        }
        if (clazz.getSuperclass() != null) {
            this.traverseClasses(interfaces, clazz.getSuperclass());
        }
    }

    public List<String> getActualClassesByInterface(String interfaceName) throws BGException {
        ArrayList<String> result = new ArrayList<String>();
        String query = "SELECT name FROM script_classes_ifaces WHERE iface=? AND name NOT LIKE '%$%'";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, interfaceName);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public static void backupAndDelete(String className) throws BGException {
        try {
            DynamicCodeDao.backup(className);
        }
        catch (IOException ex) {
            throw new BGException(ex);
        }
        File srcFile = DynamicCodeDao.getClassFile(className);
        if (!srcFile.delete()) {
            throw new BGException("Cannot delete " + srcFile.getAbsolutePath());
        }
    }

    public void deleteClassFromDb(String className) throws BGException {
        try {
            String query = "DELETE FROM script_classes_ifaces WHERE name=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, className);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM script_classes WHERE name=?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, className);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM script_classes_ifaces WHERE name LIKE ?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, className + "$%");
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM script_classes WHERE name LIKE ?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, className + "$%");
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void clearTables() throws BGException {
        try {
            String query = "DELETE FROM script_classes_ifaces";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM script_classes";
            ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public List<Pair<String, byte[]>> getClassData() throws BGException {
        ArrayList<Pair<String, byte[]>> result = new ArrayList<Pair<String, byte[]>>();
        try {
            String query = "SELECT name, data FROM script_classes";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                byte[] classData = rs.getBytes(2);
                if (!Utils.notBlankString(name) || classData == null) continue;
                result.add(new Pair<String, byte[]>(name, classData));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }
}

