/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.server.DatabaseClassLoader;
import ru.bitel.bgbilling.kernel.dynamic.server.ReadOnlyClassManager;

public abstract class DynamicClassManager {
    private static DynamicClassManager instanceToInit;
    protected final Logger logger = LogManager.getLogger();
    private ConcurrentHashMap<String, Class<?>> loadedClasses = new ConcurrentHashMap();
    protected ClassLoader parentClassLoader;

    public static void setInstance(DynamicClassManager manager) {
        instanceToInit = manager;
    }

    public static DynamicClassManager getInstance() {
        return InstanceHolder.instance;
    }

    protected void addLoadedClass(String className, Class<?> clazz) {
        this.loadedClasses.put(className, clazz);
    }

    protected void flushLoadedClassCache() {
        this.loadedClasses.clear();
    }

    protected DynamicClassManager(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        try {
            this.addListeners();
        }
        catch (BGException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected abstract void addListeners() throws BGException;

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> loaded = this.loadedClasses.get(className);
        if (loaded == null) {
            loaded = new DatabaseClassLoader(this.parentClassLoader).loadClass(className);
            this.addLoadedClass(className, loaded);
        }
        return loaded;
    }

    public final <T> T newProxyInstance(Class<T> interfaceClass, String implClassName) {
        UpdatingInvocationHandler handler = new UpdatingInvocationHandler(implClassName);
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)handler);
    }

    public final <T> T newInstance(Class<T> interfaceClass, String implClassName) throws BGException {
        try {
            return (T)this.loadClass(implClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public final <T> T newInstance(Class<T> interfaceClass, String implClassName, Class<?>[] types, Object[] initargs) throws BGException {
        try {
            Class<T> clazz = this.loadClass(implClassName).asSubclass(interfaceClass);
            Constructor<T> constructor = clazz.getConstructor(types);
            return constructor.newInstance(initargs);
        }
        catch (InvocationTargetException ex) {
            throw new BGException(ex);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private static class InstanceHolder {
        static volatile DynamicClassManager instance = instanceToInit != null ? instanceToInit : new ReadOnlyClassManager(Thread.currentThread().getContextClassLoader());

        private InstanceHolder() {
        }
    }

    private class UpdatingInvocationHandler
    implements InvocationHandler {
        private String backendClassName;
        private Object backend;

        public UpdatingInvocationHandler(String className) {
            this.backendClassName = className;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> clz = DynamicClassManager.this.loadClass(this.backendClassName);
            if (this.backend == null || this.backend.getClass() != clz) {
                this.backend = clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if ("instanceOf".equals(method.getName())) {
                Class clazz = (Class)args[0];
                return clazz.isInstance(this.backend);
            }
            return method.invoke(this.backend, args);
        }
    }
}

