/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.parameter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamHistoryDialog;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamPanel;

public class CustomerParamTextField
extends JPanel {
    private String title = "";
    private String oldValue = "";
    private final String fieldKey;
    private JTextField textField;
    private final CustomerParamPanel customerParamPanel;

    public CustomerParamTextField(String title, int column, String fieldKey, CustomerParamPanel customerParamPanel) {
        this(title, column, fieldKey, null, customerParamPanel);
    }

    public CustomerParamTextField(String title, String fieldKey, CustomerParamPanel customerParamPanel) {
        this(title, 20, fieldKey, null, customerParamPanel);
    }

    public CustomerParamTextField(String title, String fieldKey, CustomerParamPanel customerParamPanel, String fieldName) {
        this(title, 20, fieldKey, null, customerParamPanel);
        this.setName(fieldName);
    }

    public CustomerParamTextField(String title, int column, final String fieldKey, final String regexp, final CustomerParamPanel customerParamPanel) {
        super(new GridBagLayout());
        this.title = title;
        this.textField = new JTextField(column);
        this.fieldKey = fieldKey;
        this.customerParamPanel = customerParamPanel;
        JButton button = new JButton("...");
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(e -> new CustomerParamHistoryDialog(title, fieldKey, customerParamPanel));
        this.add((Component)this.textField, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)button, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String text = CustomerParamTextField.this.textField.getText();
                if (((ClientContext)customerParamPanel.getContext()).getCustomerId() > 0 && !CustomerParamTextField.this.oldValue.equals(text)) {
                    if (regexp != null && !text.matches(regexp)) {
                        ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0448\u0430\u0431\u043b\u043e\u043d\u0443 - " + regexp);
                        return;
                    }
                    customerParamPanel.updateCustomerValue(fieldKey, text);
                    CustomerParamTextField.this.oldValue = text;
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    public void setData() {
        Object object = ((ClientContext)this.customerParamPanel.getContext()).getCustomer().optQuery(this.fieldKey);
        this.oldValue = object == null ? "" : String.valueOf(object);
        this.textField.setText(this.oldValue);
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getTitle() {
        return this.title;
    }
}

