/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.AbstractTabPanel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.customer.client.CustomerEditor;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.kernel.customer.common.service.CustomerService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class CustomerManagerPanel
extends BGUTabPanel
implements AbstractTabPanel {
    public static final String TAB_ID = "customers";
    private BGUTable table;
    private JTextField accountText = new JTextField(20);
    private ContractParameterService contractParameterService;
    private JLabel recordCount = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: 0");
    private JTabbedPane customerTypeTabbedPane = new JTabbedPane();
    private BGControlPanelPages pages = new BGControlPanelPages();
    private CustomerTableModel customerTableModel = new CustomerTableModel();
    private Map<String, JComponent> fizFilterComponentMap = new HashMap<String, JComponent>();
    private Map<String, JComponent> jurFilterComponentMap = new HashMap<String, JComponent>();
    private List<Customer.CustomerFiz> fizNameValues = Arrays.asList(Customer.CustomerFiz.values());
    private List<Customer.CustomerJur> jurNameValues = Arrays.asList(Customer.CustomerJur.values());
    private ContractService contractService;
    private CustomerService customerService;

    public CustomerManagerPanel() {
        super(new ClientContext(TAB_ID, 0, 0, ClientUtils.getRBName(CustomerManagerPanel.class)), TAB_ID, "\u041a\u043b\u0438\u0435\u043d\u0442\u044b");
    }

    @Override
    protected void jbInit() throws Exception {
        BGSplitPaneNoBorder splitPaneNoBorder = new BGSplitPaneNoBorder(1, this.getFilterPanel(), (Component)this.getResultPanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPaneNoBorder, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.performAction("refresh");
    }

    private JPanel getFilterPanel() {
        ActionListener actionListener = e -> {
            this.accountText.setText("");
            this.pages.setPageIndex(1);
            this.performAction("refresh");
        };
        this.customerTypeTabbedPane.add((Component)this.getJurFilterPanel(actionListener), Customer.CustomerType.JUR_CUSTOMER.getTitle());
        this.customerTypeTabbedPane.add((Component)this.getFizFilterPanel(actionListener), Customer.CustomerType.FIZ_CUSTOMER.getTitle());
        this.customerTypeTabbedPane.addChangeListener(e -> {
            this.accountText.setText("");
            this.pages.setPageIndex(1);
            this.performAction("refresh");
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getAccountPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(18, 3, 3, 3), 0, 0));
        panel.add((Component)this.customerTypeTabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getAccountPanel() {
        Font font = this.accountText.getFont();
        this.accountText.setFont(font.deriveFont(font.getSize2D() * 1.25f));
        this.accountText.setHorizontalAlignment(0);
        this.accountText.addActionListener(e -> {
            if (!this.accountText.getText().matches("^\\d+$")) {
                ClientUtils.showErrorMessageDialog("\u041b\u0438\u0446\u0435\u0432\u043e\u0439 \u0441\u0447\u0435\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0446\u0438\u0444\u0440\u043e\u0432\u044b\u043c");
                return;
            }
            try {
                Customer searchResult = this.getCustomerService().customerByAccount(Utils.parseLong(this.accountText.getText()));
                this.customerTableModel.setData(searchResult != null ? Arrays.asList(searchResult) : Collections.emptyList());
                Page page = new Page(1, 25);
                page.setRecordCount(searchResult != null ? 1 : 0);
                this.pages.setPage(page);
                this.recordCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger(page.getRecordCount()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041b\u0438\u0446\u0435\u0432\u043e\u0439 \u0441\u0447\u0435\u0442:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.accountText, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getFizFilterPanel(ActionListener actionListener) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName(Customer.CustomerType.FIZ_CUSTOMER.name());
        panel.add((Component)this.getFilterButtonPanel(this.fizFilterComponentMap, actionListener), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 5), 0, 0));
        for (Customer.CustomerFiz customerFiz : this.fizNameValues) {
            BGTextField textField = new BGTextField(20);
            textField.setHorizontalAlignment(0);
            textField.addActionListener(actionListener);
            this.fizFilterComponentMap.put(customerFiz.key(), textField);
            panel.add((Component)new JLabel(customerFiz.description()), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)textField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        }
        panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getJurFilterPanel(ActionListener actionListener) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName(Customer.CustomerType.JUR_CUSTOMER.name());
        panel.add((Component)this.getFilterButtonPanel(this.jurFilterComponentMap, actionListener), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 5), 0, 0));
        for (Customer.CustomerJur customerJur : this.jurNameValues) {
            BGTextField textField = new BGTextField(20);
            textField.setHorizontalAlignment(0);
            textField.addActionListener(actionListener);
            this.jurFilterComponentMap.put(customerJur.key(), textField);
            panel.add((Component)new JLabel(customerJur.description()), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)textField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        }
        panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getFilterButtonPanel(Map<String, JComponent> componentMap, ActionListener actionListener) {
        JButton cleanFilter = new JButton("[X]");
        cleanFilter.addActionListener(e -> {
            for (JComponent component : componentMap.values()) {
                if (!(component instanceof BGTextField)) continue;
                ((BGTextField)component).setText("");
            }
        });
        JButton doFilter = new JButton(">>>");
        doFilter.addActionListener(actionListener);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)cleanFilter, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 10, 0, 5), 0, 0));
        panel.add((Component)doFilter, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getResultPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 5, 3), 0, 0));
        panel.add((Component)this.getTablePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getTopPanel() {
        this.pages.addPropertyChangeListener(e -> {
            if (e.getPropertyName().startsWith("to")) {
                this.performAction("refresh");
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.recordCount, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pages, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTablePanel() {
        this.table = new BGUTable(this.customerTableModel);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CustomerManagerPanel.this.customerTableModel.optSelectedRow().ifPresentOrElse(customer -> new CustomerEditor("\u0414\u0430\u043d\u043d\u044b\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430", (Customer)customer, CustomerManagerPanel.this).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430"));
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected ContractParameterService getContractParameterService() {
        if (this.contractParameterService == null) {
            this.contractParameterService = ((ClientContext)this.getContext()).getPort(ContractParameterService.class);
        }
        return this.contractParameterService;
    }

    protected ContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = ((ClientContext)this.getContext()).getWebService(ContractService.class, 0);
        }
        return this.contractService;
    }

    protected CustomerService getCustomerService() {
        if (this.customerService == null) {
            this.customerService = ((ClientContext)this.getContext()).getWebService(CustomerService.class, 0);
        }
        return this.customerService;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            ArrayList<KeyValue> filters = new ArrayList<KeyValue>();
            Customer.CustomerType customerType = Customer.CustomerType.valueOf(this.customerTypeTabbedPane.getSelectedComponent().getName());
            if (customerType == Customer.CustomerType.FIZ_CUSTOMER) {
                for (Customer.CustomerFiz customerFiz : this.fizNameValues) {
                    String value;
                    JComponent component = this.fizFilterComponentMap.get(customerFiz.key());
                    if (!(component instanceof BGTextField) || !Utils.notBlankString(value = ((BGTextField)component).getText())) continue;
                    filters.add(new KeyValue(customerFiz.key(), value));
                }
            } else if (customerType == Customer.CustomerType.JUR_CUSTOMER) {
                for (Customer.CustomerJur customerJur : this.jurNameValues) {
                    String value;
                    JComponent component = this.jurFilterComponentMap.get(customerJur.key());
                    if (!(component instanceof BGTextField) || !Utils.notBlankString(value = ((BGTextField)component).getText())) continue;
                    filters.add(new KeyValue(customerJur.key(), value));
                }
            }
            SearchResult<Customer> searchResult = this.getCustomerService().searchCustomerList(customerType, filters, this.pages.getPage(), this.table.getSort());
            this.customerTableModel.setData(searchResult.getList());
            this.pages.setPage(searchResult.getPage());
            this.recordCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger(searchResult.getPage().getRecordCount()));
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            Customer customer = (Customer)this.customerTableModel.getSelectedRow();
            if (customer == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430");
                return;
            }
            if (customer.getContractCount() > 0) {
                ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e, \u0435\u0441\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                return;
            }
            if (ClientUtils.confirmDelete(this.getCustomerTitle(customer))) {
                this.getCustomerService().customerDelete(customer.getId());
                this.performAction("refresh");
            }
        });
    }

    private String getCustomerTitle(Customer customer) {
        JSONObject json = new JSONObject(customer.getData());
        if (Customer.CustomerType.JUR_CUSTOMER.equals((Object)customer.getCustomerType())) {
            return (String)json.optQuery(Customer.CustomerJur.NAME.key());
        }
        if (Customer.CustomerType.FIZ_CUSTOMER.equals((Object)customer.getCustomerType())) {
            return this.getFIO(json);
        }
        return "ID#" + customer.getId();
    }

    private String getFIO(JSONObject json) {
        Object o;
        Object i;
        Object fio = "";
        Object f = json.optQuery(Customer.CustomerFiz.LAST_NAME.key());
        if (f != null) {
            fio = (String)fio + f;
        }
        if ((i = json.optQuery(Customer.CustomerFiz.FIRST_NAME.key())) != null) {
            fio = (String)fio + ("".equals(fio) ? "" : " ") + i;
        }
        if ((o = json.optQuery(Customer.CustomerFiz.MIDDLE_NAME.key())) != null) {
            fio = (String)fio + ("".equals(fio) ? "" : " ") + o;
        }
        return fio;
    }

    class CustomerTableModel
    extends BGTableModel<Customer> {
        public CustomerTableModel() {
            super(CustomerTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0438\u043f", 100, 100, 100, "type", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, -1, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 150, 150, 150, "contractCount", true, DecimalTableCellRenderer.INTEGER());
        }

        @Override
        public Object getValue(Customer val, int column) throws BGException {
            String i;
            switch (i = this.getIdentifier(column)) {
                case "type": {
                    return val.getCustomerType().getTitle();
                }
                case "title": {
                    JSONObject json = new JSONObject(val.getData());
                    if (Customer.CustomerType.JUR_CUSTOMER.equals((Object)val.getCustomerType())) {
                        return json.optQuery(Customer.CustomerJur.NAME.key());
                    }
                    if (!Customer.CustomerType.FIZ_CUSTOMER.equals((Object)val.getCustomerType())) break;
                    return CustomerManagerPanel.this.getFIO(json);
                }
            }
            return super.getValue(val, column);
        }
    }
}

