/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractSearchable;
import ru.bitel.bgbilling.kernel.contract.search.common.SearchImplementation;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.common.Utils;

public class ContractSearchableClassesCache {
    private static final Logger logger = LogManager.getLogger((String)ContractSearchableClassesCache.class.getSimpleName());
    private static ContractSearchableClassesCache searchableClassesCash;
    private static final Map<String, ContractSearchable> implClasses;
    private static final List<SearchImplementation> implementationWrappers;

    public static ContractSearchableClassesCache getInstance() {
        if (searchableClassesCash == null) {
            searchableClassesCash = new ContractSearchableClassesCache();
        }
        return searchableClassesCash;
    }

    private ContractSearchableClassesCache() {
        try {
            this.reloadSearchClasses();
            logger.debug("Loading searchable implementation classes is successful");
        }
        catch (BGException e) {
            logger.error((Object)e);
        }
    }

    public void reloadSearchClasses() throws BGException {
        implClasses.clear();
        implementationWrappers.clear();
        this.loadKernelImplementation();
        this.loadModulesImplementation();
        this.loadCustomImplementation();
    }

    private void loadKernelImplementation() {
        if (logger.isDebugEnabled()) {
            logger.debug("Initialize kernel searchable classes");
        }
        Utils.getClassList("ru.bitel.bgbilling.kernel.contract.search.server.searchimpl").forEach(kernelClazz -> {
            try {
                ContractSearchable kernelImplClazz = Utils.newInstance(kernelClazz.getName(), ContractSearchable.class);
                if (kernelImplClazz != null) {
                    implClasses.put(kernelClazz.getName(), kernelImplClazz);
                    implementationWrappers.add(this.createImplementationWrapper("\u042f\u0434\u0440\u043e", 0, kernelClazz.getName(), kernelImplClazz.getTitle()));
                }
            }
            catch (BGException ex) {
                logger.error((Object)ex);
            }
        });
    }

    private void loadModulesImplementation() {
        logger.debug("Initialize modules and plugins searchable classes");
        HashMap installedModulesWithServerPath = new HashMap();
        ModuleCache.getInstance().getInstalledModulesList().forEach(module -> installedModulesWithServerPath.put(module.getName(), module.getPackageServer()));
        List<BGModule> installedModules = ModuleCache.getInstance().getModulesList();
        installedModules.forEach(installedModule -> Utils.getClassList((String)installedModulesWithServerPath.get(installedModule.getName()) + ".searchimpl").forEach(moduleClass -> {
            try {
                ContractSearchable moduleImplClazz = Utils.newInstance(moduleClass.getName(), ContractSearchable.class);
                if (moduleImplClazz != null) {
                    implClasses.put(moduleClass.getName(), moduleImplClazz);
                    implementationWrappers.add(this.createImplementationWrapper(installedModule.getTitle(), installedModule.getId(), moduleClass.getName(), moduleImplClazz.getTitle() + " ( " + installedModule.getTitle() + " )"));
                }
            }
            catch (BGException ex) {
                logger.error((Object)ex);
            }
        }));
    }

    private void loadCustomImplementation() throws BGException {
        logger.debug("Initialize custom searchable classes");
        ServerContext serverContext = (ServerContext)ServerContext.get();
        DynamicCodeService dynamicCodeService = serverContext.getService(DynamicCodeService.class, 0);
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        dynamicCodeService.getDynamicClassesByInterface(ContractSearchable.class.getName()).forEach(customSearch -> {
            try {
                ContractSearchable customImplClass = dynamicClassManager.newInstance(ContractSearchable.class, customSearch.getClassName());
                implClasses.put(customSearch.getClassName(), customImplClass);
                implementationWrappers.add(this.createImplementationWrapper("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439", 0, customSearch.getClassName(), customImplClass.getTitle()));
            }
            catch (BGException e) {
                logger.error((Object)e);
            }
        });
    }

    private SearchImplementation createImplementationWrapper(String moduleTitle, int moduleId, String pathToImplClass, String title) {
        return SearchImplementation.builder().setModuleTitle(moduleTitle).setModuleId(moduleId).setPathToImplClass(pathToImplClass).setTitle(Utils.maskBlank(title, "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e")).setEnable(false).build();
    }

    public Map<String, ContractSearchable> getClasses() {
        return implClasses;
    }

    public ContractSearchable getClass(String pathToClass) {
        return implClasses.get(pathToClass);
    }

    public List<SearchImplementation> getImplementationsWrapper() {
        return implementationWrappers;
    }

    static {
        implClasses = new HashMap<String, ContractSearchable>();
        implementationWrappers = new ArrayList<SearchImplementation>();
    }
}

