/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.contract.bean.ContractManager;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractParameterGroupName;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterMultiListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractParameterGroupAttrModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractParameterGroupModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractParameterGroupNameDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractPatternDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService")
public class ContractParameterServiceImpl
extends AbstractService
implements ContractParameterService {
    @Override
    public ContractParameterGroup contractParameterGroupGet(int id) throws BGException {
        return this.context.getDirectory(ContractParameterGroup.class, 0).get(id);
    }

    @Override
    public List<ContractParameterGroup> contractParameterGroupList() throws BGException {
        return this.context.getDirectory(ContractParameterGroup.class, 0).list();
    }

    @Override
    public String contractParameterGroupJson() throws BGException {
        JSONArray array = new JSONArray();
        Connection con = this.getConnection();
        try (ContractManager contractManager = new ContractManager(con);
             ContractPatternDao contractPatternDao = new ContractPatternDao(con);
             ContractParameterGroupNameDao contractParameterGroupNameDao = new ContractParameterGroupNameDao(con);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT * FROM contract_parameter_group");){
            Map groupContractMap = contractManager.getContractParameterGroupCountMap();
            Map<Integer, Integer> patternMap = contractPatternDao.getPatternParameterGroupCountMap();
            HashMap<Integer, List> groupParameterIds = new HashMap<Integer, List>();
            while (rs.next()) {
                int groupId = rs.getInt("gid");
                List list = groupParameterIds.getOrDefault(groupId, new ArrayList());
                list.add(rs.getInt("pid"));
                groupParameterIds.put(groupId, list);
            }
            contractParameterGroupNameDao.reset();
            for (ContractParameterGroupName groupName : contractParameterGroupNameDao.list()) {
                JSONObject json = new JSONObject();
                json.put("id", groupName.getId());
                json.put("title", (Object)groupName.getTitle());
                json.put("patterns", (Object)patternMap.getOrDefault(groupName.getId(), 0));
                json.put("contracts", (Object)groupContractMap.getOrDefault(groupName.getId(), 0));
                json.put("parameterIds", (Object)(groupParameterIds.containsKey(groupName.getId()) ? Utils.toString((Iterable)groupParameterIds.get(groupName.getId())) : ""));
                array.put((Object)json);
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return array.toString();
    }

    @Override
    public int contractParameterGroupUpdate(ContractParameterGroup group) throws BGException {
        this.context.getDirectory(ContractParameterGroup.class, 0).update(group);
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
        return group.getId();
    }

    @Override
    public void contractParameterGroupDelete(int id) throws BGException {
        this.context.getDirectory(ContractParameterGroup.class, 0).delete(id);
    }

    @Override
    public List<ContractParameterListItem> contractParameterListItemList(int parameterTypeId) throws BGException {
        return this.context.getDirectory(ContractParameterListItem.class, parameterTypeId).list();
    }

    @Override
    public List<ContractParameterMultiListItem> contractParameterMultiListItemList(int parameterTypeId) throws BGException {
        return this.context.getDirectory(ContractParameterMultiListItem.class, parameterTypeId).list();
    }

    @Override
    public int contractParameterListItemUpdate(int parameterTypeId, ContractParameterListItem item) throws BGException {
        this.context.getDirectory(ContractParameterListItem.class, parameterTypeId).update(item);
        this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
        return item.getId();
    }

    @Override
    public int contractParameterMultiListItemUpdate(int parameterTypeId, ContractParameterMultiListItem item) throws BGException {
        this.context.getDirectory(ContractParameterMultiListItem.class, parameterTypeId).update(item);
        this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
        return item.getId();
    }

    @Override
    public void contractParameterListItemDelete(int parameterTypeId, int id) throws BGException {
        this.context.getDirectory(ContractParameterListItem.class, parameterTypeId).delete(id);
        this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
    }

    @Override
    public void contractParameterMultiListItemDelete(int parameterTypeId, int id) throws BGException {
        this.context.getDirectory(ContractParameterMultiListItem.class, parameterTypeId).delete(id);
        this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
    }

    @Override
    public ContractParameterGroupAttr contractParameterGroupAttrGet(int id) throws BGException {
        return this.context.getDirectory(ContractParameterGroupAttr.class, 0).get(id);
    }

    @Override
    public List<ContractParameterGroupAttr> contractParameterGroupAttrList() throws BGException {
        return this.context.getDirectory(ContractParameterGroupAttr.class, 0).list();
    }

    @Override
    public int contractParameterGroupAttrUpdate(ContractParameterGroupAttr attr) throws BGException {
        this.context.getDirectory(ContractParameterGroupAttr.class, 0).update(attr);
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
        return attr.getId();
    }

    @Override
    public void contractParameterGroupAttrDelete(int id) throws BGException {
        this.context.getDirectory(ContractParameterGroupAttr.class, 0).delete(id);
    }

    @Override
    public void contractParameterGroupUpdateLink(int contractParameterGroupId, Set<Integer> parameterIds) throws BGException {
        try (ContractParameterGroupAttrDao dao = new ContractParameterGroupAttrDao(this.getConnection());){
            dao.updateLink(contractParameterGroupId, parameterIds);
        }
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
    }

    @Override
    public String paramPhoneFormats() throws BGException, BGMessageException {
        return Setup.getSetup().get("phones.formats");
    }

    @Override
    public void contractParameterGroupAttrOrderSet(List<ContractParameterGroupAttr> list) throws BGException {
        try (ContractParameterGroupAttrDao contractParameterGroupAttrDao = new ContractParameterGroupAttrDao(this.getConnection());){
            contractParameterGroupAttrDao.updateOrderPosition(list);
            this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
        }
    }
}

