/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.call;

import bitel.billing.module.services.ServicePanel;
import bitel.billing.module.services.call.LimitData;
import bitel.billing.module.services.call.LimitEditor;
import bitel.billing.module.services.call.TableLimit;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

public class SPP_ConnectLimit
extends ServicePanel
implements ActionListener,
PatternModuleTabPanel.PatternModuleTabPanelItemParams {
    private Element services = null;
    private LimitEditor serviceConditionEditor = new LimitEditor();
    private BGDialogToolBar dialogToolBar = new BGDialogToolBar();
    private TableLimit tableLimit = new TableLimit();
    private CardLayout cardLayout1 = new CardLayout();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel4 = new JPanel();

    public SPP_ConnectLimit() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dialogToolBar.setDefaultButtons(this);
        this.dialogToolBar.setOrientation(1);
        this.dialogToolBar.setToolBar(new String[]{"newItem", "copyItem", "editItem", "deleteItem", "separator", "refresh", "separator", "upItem", "downItem"});
        this.jPanel2.setVisible(true);
        this.jPanel3.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new BGTitleBorder(" \u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f "));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        BGButtonPanelRestoreOkCancelHelp bGControlPanel_02 = new BGButtonPanelRestoreOkCancelHelp();
        bGControlPanel_02.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SPP_ConnectLimit.this.bGControlPanel_02_actionPerformed(e);
            }
        });
        this.jPanel4.setLayout(this.cardLayout1);
        this.jPanel4.add((Component)this.jPanel2, "table");
        this.jPanel4.add((Component)this.jPanel3, "editor");
        this.jPanel3.setVisible(false);
        this.jPanel2.add((Component)this.dialogToolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanel2.add((Component)new JScrollPane(this.tableLimit), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.jPanel3.add((Component)this.serviceConditionEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanel3.add((Component)bGControlPanel_02, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jPanel4, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tableLimit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SPP_ConnectLimit.this.tableLimit_keyPressed(e);
            }
        });
        this.tableLimit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SPP_ConnectLimit.this.tableLimit_mouseClicked(e);
            }
        });
        this.dialogToolBar.setFloatable(false);
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("ListServicesLimit");
        request.setContractId(this.getContractId());
        request.setAttribute("lid", this.id);
        this.setDocument(this.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            this.tableLimit.setRowData(XMLUtils.getNode(doc, "limit"));
            this.services = (Element)XMLUtils.getNode(doc, "services");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.newItem();
        } else if ("copyItem".equals(actionCommand)) {
            this.copyItem();
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand)) {
            this.deleteItem();
        } else if ("refresh".equals(actionCommand)) {
            this.setData();
        } else if ("upItem".equals(actionCommand)) {
            this.tableLimit.moveRow(0);
        } else if ("downItem".equals(actionCommand)) {
            this.tableLimit.moveRow(1);
        }
    }

    void tableLimit_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.editItem();
        }
    }

    void tableLimit_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 155) {
            this.newItem();
        } else if (e.getKeyCode() == 10) {
            this.editItem();
        } else if (e.getKeyCode() == 127) {
            this.deleteItem();
        } else if (e.getKeyCode() == 33) {
            this.tableLimit.moveRow(0);
        } else if (e.getKeyCode() == 34) {
            this.tableLimit.moveRow(1);
        }
    }

    @Override
    public void newItem() {
        this.serviceConditionEditor.init(new LimitData(true), this.services);
        this.cardLayout1.show(this.jPanel4, "editor");
    }

    @Override
    public void copyItem() {
        int index = this.tableLimit.getSelectedRow();
        if (index == -1) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
            return;
        }
        LimitData limitData = (LimitData)this.tableLimit.getValueAt(index, 0);
        LimitData limitDataClone = (LimitData)limitData.clone();
        this.serviceConditionEditor.init(limitDataClone, this.services);
        limitDataClone.setNew(true);
        this.cardLayout1.show(this.jPanel4, "editor");
    }

    @Override
    public void editItem() {
        int index = this.tableLimit.getSelectedRow();
        if (index == -1) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
            return;
        }
        LimitData limitData = (LimitData)this.tableLimit.getValueAt(index, 0);
        this.serviceConditionEditor.init(limitData, this.services);
        this.cardLayout1.show(this.jPanel4, "editor");
    }

    @Override
    public void deleteItem() {
        int index = this.tableLimit.getSelectedRow();
        if (index == -1) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
            return;
        }
        this.tableLimit.removeRow(index);
    }

    private void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.serviceConditionEditor.trySetData();
        } else if ("ok".equals(actionCommand)) {
            this.serviceConditionEditor.updateLimitData();
            LimitData limitData = this.serviceConditionEditor.getLimitData();
            if (limitData.isNew()) {
                this.tableLimit.addRow(limitData);
                limitData.setNew(false);
            } else {
                int index = this.tableLimit.getSelectedRow();
                if (index > -1) {
                    this.tableLimit.updateRow(index, limitData);
                }
            }
            this.cardLayout1.show(this.jPanel4, "table");
        } else if ("cancel".equals(actionCommand)) {
            this.cardLayout1.show(this.jPanel4, "table");
        }
    }

    @Override
    public boolean updateData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("DeleteLimit");
        request.setAttribute("lid", this.id);
        request.setModuleId(this.getModuleId());
        if (ClientUtils.checkStatus(this.getDocument(request))) {
            DefaultTableModel model = this.tableLimit.getDefaultModel();
            for (int i = 0; i < this.tableLimit.getRowCount(); ++i) {
                LimitData limitData = (LimitData)model.getValueAt(i, 0);
                request = new Request();
                request.setModule(this.module);
                request.setAction("UpdateLimitService");
                request.setModuleId(this.getModuleId());
                request.setAttribute("lid", this.id);
                request.setAttribute("num", String.valueOf(i));
                request.setAttribute("type", String.valueOf(limitData.getType()));
                request.setAttribute("param1", limitData.getParam1());
                request.setAttribute("param2", limitData.getParam2());
                request.setAttribute("date1", limitData.getDate1());
                request.setAttribute("date2", limitData.getDate2());
                request.setAttribute("sid", limitData.getServices());
                request.setAttribute("kr", limitData.getTimeCondition());
                request.setAttribute("comment", limitData.getComment());
                ClientUtils.checkStatus(this.getDocument(request));
            }
        }
        return true;
    }

    @Override
    public void initParams(int mid) {
        Request request = new Request();
        request.setModule("service");
        request.setModuleId(mid);
        request.setAction("GetServiceList");
        Document doc = this.getDocument(request);
        this.services = (Element)XMLUtils.getNode(doc, "services");
    }

    @Override
    public void setParams(Element element) {
        if (element != null) {
            this.tableLimit.setRowData(XMLUtils.selectElement(element, "limit"));
        } else {
            this.tableLimit.setRowData(null);
        }
    }

    @Override
    public void serializeParams(Element element) {
        Element limit = XMLUtils.createElement(element, "limit");
        DefaultTableModel model = this.tableLimit.getDefaultModel();
        for (int i = 0; i < this.tableLimit.getRowCount(); ++i) {
            LimitData limitData = (LimitData)model.getValueAt(i, 0);
            Element limitService = XMLUtils.createElement(limit, "service");
            limitService.setAttribute("num", String.valueOf(i));
            limitService.setAttribute("type", String.valueOf(limitData.getType()));
            limitService.setAttribute("param1", limitData.getParam1());
            limitService.setAttribute("param2", limitData.getParam2());
            limitService.setAttribute("date1", limitData.getDate1());
            limitService.setAttribute("date2", limitData.getDate2());
            limitService.setAttribute("sid", limitData.getServices());
            limitService.setAttribute("kr", limitData.getTimeCondition());
            limitService.setAttribute("comment", limitData.getComment());
            HashSet<String> set = new HashSet<String>();
            StringTokenizer tt = new StringTokenizer(limitData.getTimeCondition(), "-");
            while (tt.hasMoreTokens()) {
                String ss = tt.nextToken();
                if (set.contains(ss)) continue;
                StringTokenizer st = new StringTokenizer(ss, "_");
                String hh = st.hasMoreTokens() ? st.nextToken() : "";
                String dw = st.hasMoreTokens() ? st.nextToken() : "";
                String dm = st.hasMoreTokens() ? st.nextToken() : "";
                String mm = st.hasMoreTokens() ? st.nextToken() : "";
                Element item = XMLUtils.createElement(limitService, "item");
                item.setAttribute("dm", dm);
                item.setAttribute("dw", dw);
                item.setAttribute("hh", hh);
                item.setAttribute("mm", mm);
                set.add(ss);
            }
        }
    }
}

