/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class BGPopup
extends JPopupMenu {
    private LocalDate date = LocalDate.now();
    private LocalDate workDate = LocalDate.now();
    private DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("LLLL");
    private List<JLabel> monthLabelList = new ArrayList<JLabel>();
    private List<JLabel> yearLabelList = new ArrayList<JLabel>();
    private Color defaultColor = null;
    private Color panelColor = Color.LIGHT_GRAY;
    private Color lineColor = new Color(160, 160, 160);
    private Color selectColor = Color.GRAY;
    private Color currentColor = new Color(96, 96, 255);
    private int currentYear = 0;
    private int currentMonth = 0;

    public BGPopup() {
        this.setLayout(new GridBagLayout());
        this.defaultColor = this.getBackground();
        LocalDate now = LocalDate.now();
        this.currentYear = now.getYear();
        this.currentMonth = now.getMonthValue() - 1;
        try {
            JLabel label;
            int index;
            LocalDate workDate = LocalDate.now();
            workDate = workDate.withDayOfMonth(1);
            for (index = 0; index < 12; ++index) {
                workDate = workDate.withMonth(index + 1);
                label = new JLabel(this.dateFormat.format(workDate));
                label.setHorizontalAlignment(0);
                label.setName("month_" + index);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(3, 5, 3, 5));
                if (index == this.currentMonth) {
                    label.setForeground(this.currentColor);
                }
                this.add((Component)label, new GridBagConstraints(0, index + 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.monthLabelList.add(label);
            }
            for (index = 0; index < 5; ++index) {
                label = new JLabel();
                label.setHorizontalAlignment(0);
                label.setName("year_" + index);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(3, 5, 3, 5));
                this.add((Component)label, new GridBagConstraints(index + 2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.yearLabelList.add(label);
            }
            MonthMouseAdapter monthMouseAdapter = new MonthMouseAdapter();
            for (int xIndex = 0; xIndex < 5; ++xIndex) {
                for (int yIndex = 0; yIndex < 12; ++yIndex) {
                    JPanel panel = new JPanel();
                    panel.setBackground(Color.LIGHT_GRAY);
                    panel.setName("panel_" + xIndex + "_" + yIndex);
                    panel.addMouseListener(monthMouseAdapter);
                    this.add((Component)panel, new GridBagConstraints(xIndex + 2, yIndex + 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
            }
            ActionListener yearActionListener = event -> this.b(Integer.parseInt(event.getActionCommand()));
            BGButton decMonth = new BGButton("");
            decMonth.setIcon(ClientUtils.getIcon("to_prev.gif"));
            decMonth.setActionCommand("-5");
            decMonth.addActionListener(yearActionListener);
            this.add((Component)decMonth, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            BGButton addMonth = new BGButton("");
            addMonth.setIcon(ClientUtils.getIcon("to_next.gif"));
            addMonth.setActionCommand("5");
            addMonth.addActionListener(yearActionListener);
            this.add((Component)addMonth, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.a(-1, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void a(int x, int y) {
        void var4_17;
        int index;
        for (index = 0; index < this.yearLabelList.size(); ++index) {
            void var4_4;
            Color color = this.defaultColor;
            if (index == x) {
                Color color2 = this.lineColor;
            }
            this.yearLabelList.get(index).setBackground((Color)var4_4);
        }
        for (index = 0; index < this.monthLabelList.size(); ++index) {
            void var4_10;
            Color color = this.defaultColor;
            if (index == y) {
                Color color3 = this.lineColor;
            }
            this.monthLabelList.get(index).setBackground((Color)var4_10);
        }
        int year = this.workDate.getYear();
        for (Component component : this.getComponents()) {
            JPanel panel;
            String name;
            if (!(component instanceof JPanel) || !(name = (panel = (JPanel)component).getName()).startsWith("panel_")) continue;
            String[] tokens = name.split("_");
            int panelX = Integer.parseInt(tokens[1]);
            int panelY = Integer.parseInt(tokens[2]);
            Color color2 = this.defaultColor;
            if (panelX % 2 != panelY % 2) {
                color2 = this.panelColor;
            }
            if (year + panelX == this.currentYear && panelY == this.currentMonth) {
                color2 = this.currentColor;
            } else if (x == panelX && y == panelY) {
                color2 = this.selectColor;
            } else if (x == panelX || y == panelY) {
                color2 = this.lineColor;
            }
            panel.setBackground(color2);
        }
        Object var4_12 = null;
        if (x > -1 && y > -1) {
            LocalDate localDate3 = this.workDate;
            localDate3 = localDate3.withMonth(y + 1);
            localDate3 = localDate3.withYear(this.workDate.getYear() + x);
        } else {
            LocalDate localDate = this.date;
        }
        this.firePropertyChange("currentSelectDate", null, var4_17);
    }

    private void b(int step) {
        this.workDate = this.workDate.plusYears(step);
        this.setYear();
        this.a(-1, -1);
    }

    private void c(int x, int y) {
        this.a(-1, -1);
        this.workDate = this.workDate.plusYears(x);
        this.workDate = this.workDate.withMonth(y + 1);
        this.firePropertyChange("selectDate", this.date, this.workDate);
        this.setVisible(false);
    }

    private void setYear() {
        int year = this.workDate.getYear();
        Color labelColor = new JLabel().getForeground();
        for (Component component : this.getComponents()) {
            JLabel label;
            String labelName;
            if (!(component instanceof JLabel) || !(labelName = (label = (JLabel)component).getName()).startsWith("year_")) continue;
            int index = Integer.parseInt(labelName.substring(5));
            if (year + index == this.currentYear) {
                label.setForeground(this.currentColor);
            } else {
                label.setForeground(labelColor);
            }
            label.setText(String.valueOf(year + index));
        }
    }

    public void setLocalDate(LocalDate date) {
        if (date != null) {
            this.date = date;
            this.workDate = date.minusYears(2L);
            this.setYear();
            this.a(-1, -1);
        }
    }

    private class MonthMouseAdapter
    extends MouseAdapter {
        private MonthMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            String[] tokens = ((JPanel)event.getSource()).getName().split("_");
            BGPopup.this.a(Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]));
        }

        @Override
        public void mouseExited(MouseEvent event) {
            BGPopup.this.a(-1, -1);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            String[] tokens = ((JPanel)event.getSource()).getName().split("_");
            BGPopup.this.c(Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]));
        }
    }
}

