/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGControlPanelDateNoB;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientSetup;

public class ActualDateFilter
extends JPanel {
    private static final String CONTRACT_ACTUAL_DATE_FILTER_KEY = ".contract.actual.date.filter";
    private JPanel parent;
    private boolean isBgpanel = false;
    private JCheckBox enabled = new JCheckBox("\u0432\u044b\u0432\u043e\u0434\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b, \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u043d\u0430 \u0434\u0430\u0442\u0443");
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();

    public ActualDateFilter(BGPanel parent) {
        this.parent = parent;
        this.jbInit();
    }

    public ActualDateFilter(BGUPanel parent) {
        this.parent = parent;
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.isBgpanel = this.parent instanceof BGPanel;
        boolean isFilterSelected = ClientSetup.getInstance().getBoolean(this.parent.getClass().getCanonicalName() + CONTRACT_ACTUAL_DATE_FILTER_KEY, true);
        this.enabled.setSelected(isFilterSelected);
        this.enabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ActualDateFilter.this.isBgpanel) {
                    ((BGPanel)ActualDateFilter.this.parent).trySetData();
                } else {
                    ((BGUPanel)ActualDateFilter.this.parent).performAction("refresh");
                }
            }
        });
        this.date.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ActualDateFilter.this.isBgpanel) {
                    ((BGPanel)ActualDateFilter.this.parent).trySetData();
                } else {
                    ((BGUPanel)ActualDateFilter.this.parent).performAction("refresh");
                }
            }
        });
        this.enabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String key = ActualDateFilter.this.parent.getClass().getCanonicalName() + ActualDateFilter.CONTRACT_ACTUAL_DATE_FILTER_KEY;
                ClientSetup.getInstance().getUserConfig().set(key, String.valueOf(ActualDateFilter.this.enabled.isSelected()));
                ClientSetup.getInstance().saveUserConfig();
            }
        });
        this.add((Component)this.enabled, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.date, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 3), 0, 0));
    }

    public void updateDate() {
        if (this.date.getDateString().isEmpty()) {
            this.date.setLocalDate(LocalDate.now());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.isSelected();
    }

    public Calendar getDateCalendar() {
        return this.date.getDateCalendar();
    }

    public Date getDate() {
        if (this.isEnabled()) {
            return this.date.getDateCalendar() != null ? this.date.getDateCalendar().getTime() : null;
        }
        return null;
    }
}

