/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.transform.TransformerException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.awt.AWTRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.FOUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGPaperShadowBorder;

public class AWTViewer
extends JPanel {
    private JLabel previewImageLabel = new JLabel();
    private int currentPage;
    private double currentScaleFactor = 1.0;
    private AWTRenderer renderer = null;
    private int numberOfPages = 0;
    private int pageOrientation = 0;
    private MouseScaleListener mouseScaleListener = null;

    public AWTViewer() {
        this.setLayout(new GridBagLayout());
        this.previewImageLabel.setHorizontalAlignment(0);
        this.previewImageLabel.setBorder(new BGPaperShadowBorder());
        JPanel scrollablePanel = new JPanel(new GridBagLayout());
        scrollablePanel.add((Component)this.previewImageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane(scrollablePanel, 22, 32);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        scrollablePanel.addMouseWheelListener(e -> this.event_MouseWheel(e));
    }

    public void setPageOrientation(int pageOrientation) {
        this.pageOrientation = pageOrientation;
    }

    public void setData(Document foDoc) throws BGException {
        this.numberOfPages = 0;
        Node fo = XMLUtils.selectNode(foDoc, "/data/*[local-name()='root']");
        if (fo != null) {
            try {
                this.renderer = FOUtils.createAWTRenderer();
                FOUtils.render(fo, (Renderer)this.renderer, "application/X-fop-awt-preview");
                this.numberOfPages = this.renderer.getNumberOfPages();
                this.showPage(0);
            }
            catch (TransformerException e) {
                this.showClearPage();
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0440\u0430\u043d\u0441\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 FO-\u0448\u0430\u0431\u043b\u043e\u043d\u0430", e);
            }
            catch (FOPException e) {
                this.showClearPage();
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 FO-\u0448\u0430\u0431\u043b\u043e\u043d\u0430", e);
            }
        } else {
            this.showClearPage();
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0430\u0442\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
        }
    }

    public void showPage(int pageNum) throws BGException {
        if (this.renderer == null || this.numberOfPages <= 0) {
            this.showClearPage();
            return;
        }
        this.renderer.setScaleFactor(this.currentScaleFactor);
        try {
            BufferedImage bufferedimage = this.renderer.getPageImage(pageNum);
            if (bufferedimage != null) {
                this.previewImageLabel.setIcon(new ImageIcon(bufferedimage));
                this.repaint();
            }
        }
        catch (FOPException e) {
            this.showClearPage();
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 FO-\u0448\u0430\u0431\u043b\u043e\u043d\u0430", e);
        }
        this.currentPage = pageNum;
    }

    public void showClearPage() {
        int WIDTH = (int)(595.0 * this.currentScaleFactor);
        int HEIGHT = (int)(842.0 * this.currentScaleFactor);
        if (this.pageOrientation != 0) {
            int a = WIDTH;
            WIDTH = HEIGHT;
            HEIGHT = a;
        }
        BufferedImage clearPage = new BufferedImage(WIDTH, HEIGHT, 1);
        Graphics2D imageGraphics = clearPage.createGraphics();
        imageGraphics.setColor(Color.WHITE);
        imageGraphics.fillRect(0, 0, WIDTH, HEIGHT);
        imageGraphics.setColor(Color.BLACK);
        imageGraphics.drawLine(0, 0, WIDTH, HEIGHT);
        imageGraphics.drawLine(0, HEIGHT, WIDTH, 0);
        this.previewImageLabel.setIcon(new ImageIcon(clearPage));
        this.repaint();
    }

    public void setScaleFactor(double scaleFactor) throws BGException {
        this.currentScaleFactor = scaleFactor;
        this.showPage(this.currentPage);
    }

    public void print() {
        PrinterJob printerjob = PrinterJob.getPrinterJob();
        printerjob.setPageable((Pageable)this.renderer);
        if (printerjob.printDialog()) {
            try {
                printerjob.print();
            }
            catch (PrinterException printerexception) {
                printerexception.printStackTrace();
            }
        }
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public PageFormat getPageFormat(int pageIndex) {
        return this.renderer.getPageFormat(pageIndex);
    }

    public BufferedImage getPageImage(int pageIndex) throws FOPException {
        return this.renderer.getPageImage(pageIndex);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return this.renderer.print(graphics, pageFormat, pageIndex);
    }

    public void setMouseScaleListener(MouseScaleListener mouseScaleListener) {
        this.mouseScaleListener = mouseScaleListener;
    }

    private void event_MouseWheel(MouseWheelEvent e) {
        if (e.isControlDown() && this.mouseScaleListener != null) {
            if (e.getWheelRotation() < 0) {
                this.mouseScaleListener.scaleUp();
            } else {
                this.mouseScaleListener.scaleDown();
            }
        } else {
            ((JPanel)e.getSource()).getParent().dispatchEvent(e);
        }
    }

    public static interface MouseScaleListener {
        public void scaleUp();

        public void scaleDown();
    }
}

