/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.bgsecure;

import bitel.billing.module.admin.DialogContractSelect;
import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.admin.bgsecure.ActionsPanel;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelMonthAndDays;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalDate;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;

public class QueryLogViewer
extends BGUPanel {
    private static final String DO_REQUEST = "doRequest";
    private boolean init = false;
    private String conId = "";
    private JLabel countLabel = new JLabel();
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("BGSQueryLog");
    private BGUTable table = new BGUTable(this.tableModel);
    private BGComboBox<ComboBoxItem> users = new BGComboBox();
    private JTextArea queryInfo = new JTextArea();
    private JTextField contractMask = new JTextField();
    private JButton contractMaskFind = new JButton();
    private ActionsPanel actionsPanel = new ActionsPanel();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelMonthAndDays periodPanel = new BGControlPanelMonthAndDays();
    private BGTextField filterParamName = new BGTextField();
    private BGTextField filterParamValue = new BGTextField();
    private JCheckBox isRegexp = new JCheckBox("REGEXP");
    Action doRequestAction = new AbstractBGUPanel.DefaultAction("doRequest", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            QueryLogViewer.this.queryInfo.setText("");
            BGUTableParams tableParams = new BGUTableParams().setPeriod(QueryLogViewer.this.periodPanel.getPeriod()).setPage(QueryLogViewer.this.pagePanel.getPage()).addParam("userId", String.valueOf(QueryLogViewer.this.users.getSelectedItem().getObject())).addParam("actions", QueryLogViewer.this.actionsPanel.getActions()).addParam("contracts", QueryLogViewer.this.conId).addParam("isregexp", String.valueOf(QueryLogViewer.this.isRegexp.getModel().isSelected())).addParam("paramName", QueryLogViewer.this.filterParamName.getText().trim()).addParam("paramValue", QueryLogViewer.this.filterParamValue.getText().trim()).setSort(QueryLogViewer.this.table.getSort());
            QueryLogViewer.this.tableModel.loadData(QueryLogViewer.this.getKernelContext(), tableParams, QueryLogViewer.this.pagePanel, QueryLogViewer.this.countLabel);
        }
    };

    public QueryLogViewer(ClientContext ctx) {
        super(ctx);
    }

    @Override
    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getLeftPanel(), (Component)this.getRightpanel(), 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getLeftPanel() {
        this.periodPanel.setBorder(new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        this.periodPanel.setDate(LocalDate.now());
        this.actionsPanel.setBorder(new BGTitleBorder(" \u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f "));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.actionsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getRightpanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getQueryFilterPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getViewPanel(), new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        this.contractMask.setHorizontalAlignment(0);
        this.contractMask.setEnabled(true);
        this.contractMask.setEditable(false);
        this.contractMask.setDisabledTextColor(Color.black);
        this.contractMask.setColumns(20);
        this.contractMaskFind.setMargin(new Insets(2, 2, 2, 2));
        this.contractMaskFind.setText(">>>");
        this.contractMaskFind.addActionListener(e -> this.contractMaskFind_actionPerformed(e));
        JButton contractMaskClear = new JButton("X");
        contractMaskClear.setMargin(new Insets(2, 2, 2, 2));
        contractMaskClear.addActionListener(e -> this.contractMaskClear_actionPerformed(e));
        JPanel contractPanel = new JPanel(new GridBagLayout());
        contractPanel.setBorder(new BGTitleBorder(" \u0414\u043e\u0433\u043e\u0432\u043e\u0440 "));
        contractPanel.add((Component)this.contractMask, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        contractPanel.add((Component)contractMaskClear, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        contractPanel.add((Component)this.contractMaskFind, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        JPanel usersPanel = new JPanel(new GridBagLayout());
        usersPanel.setBorder(new BGTitleBorder(" \u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438 "));
        usersPanel.add(this.users, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)contractPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)usersPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getQueryFilterPanel() {
        JButton showButton = new JButton();
        showButton.setMnemonic('0');
        showButton.setText("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        showButton.addActionListener(actionEvent -> this.showButton_actionPerformed(actionEvent));
        BGButton clear = new BGButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c");
        clear.addActionListener(e -> {
            this.filterParamName.setText("");
            this.filterParamValue.setText("");
        });
        this.pagePanel.setKey(this.getClass().getName());
        this.pagePanel.init();
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String name = propertyChangeEvent.getPropertyName();
                if (name != null && name.startsWith("to")) {
                    QueryLogViewer.this.performAction(QueryLogViewer.DO_REQUEST);
                }
            }
        });
        JPanel jButPanel = new JPanel(new GridBagLayout());
        jButPanel.add((Component)showButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        jButPanel.add((Component)clear, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        jButPanel.add((Component)this.countLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 15, 0, 0), 0, 0));
        jButPanel.add((Component)this.pagePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430"));
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.filterParamName, new GridBagConstraints(0, 1, 1, 1, 0.2, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(" = "), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.filterParamValue, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.isRegexp, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)jButPanel, new GridBagConstraints(0, 3, 5, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        return panel;
    }

    private JPanel getViewPanel() {
        this.queryInfo.setEditable(false);
        this.queryInfo.setMargin(new Insets(3, 3, 3, 3));
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.tableModel.optSelectedRow().ifPresent(row -> this.queryInfo.setText(row.optValue("query").orElse("")));
            }
        });
        JPanel gueryInfoPanel = new JPanel(new GridBagLayout());
        gueryInfoPanel.setMaximumSize(new Dimension(200, 300));
        gueryInfoPanel.setPreferredSize(new Dimension(200, 300));
        gueryInfoPanel.add((Component)new JLabel("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0443:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 5), 0, 0));
        gueryInfoPanel.add((Component)new JScrollPane(this.queryInfo), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0417\u0430\u043f\u0440\u043e\u0441\u044b "));
        panel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)gueryInfoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if (!this.init) {
                this.initPanel();
                this.init = true;
            }
        });
    }

    private void initPanel() {
        Request request = new Request().setModule("admin").setAction("LogViewer");
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.users.setModel(ClientUtils.buildComboBox(XMLUtils.selectNode(doc, "//users"), null));
        }
        this.actionsPanel.init(((ClientContext)this.getContext()).getModule(), ((ClientContext)this.getContext()).getModuleId());
        this.actionsPanel.setData();
    }

    private void showButton_actionPerformed(ActionEvent actionEvent) {
        this.pagePanel.init();
        this.performAction(DO_REQUEST);
    }

    private void contractMaskClear_actionPerformed(ActionEvent e) {
        this.contractMask.setText("");
        this.conId = "";
    }

    private void contractMaskFind_actionPerformed(ActionEvent e) {
        String[] selected = null;
        DialogContractSelect dialog = new DialogContractSelect();
        dialog.setVisible(true);
        selected = dialog.getSelected();
        this.conId = selected[0];
        this.contractMask.setText(selected[1]);
        dialog.dispose();
    }
}

