/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressPrefixSuffix;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.ParameterDao;
import ru.bitel.oss.kernel.directories.address.server.bean.ParameterIds;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;

public class AddressUtils {
    private final Directory<Country> countryDirectory;
    private final Directory<City> cityDirectory;
    private final Directory<Area> areaDirectory;
    private final Directory<Street> streetDirectory;
    private final Directory<Quarter> quarterDirectory;

    public AddressUtils(ServerContext context) throws BGException {
        this.countryDirectory = context.getDirectory(Country.class, 0);
        this.cityDirectory = context.getDirectory(City.class, 0);
        this.areaDirectory = context.getDirectory(Area.class, 0);
        this.streetDirectory = context.getDirectory(Street.class, 0);
        this.quarterDirectory = context.getDirectory(Quarter.class, 0);
    }

    public String getAddress(ParameterMap setup, House house, EntityAttrAddress attrAddress) throws BGException {
        String formatKey = attrAddress.getFormatKey();
        String addressFormat = setup.get("addrs.format.pattern." + formatKey, setup.get("addrs.format." + formatKey, setup.get("addrs.format", "(${index}, )(${city})(, ${area})(, ${quarter})(, ${street})(, \u0434. ${house})(${frac})(, \u043a\u0432. ${flat})( ${room})(, ${pod} \u043f\u043e\u0434.)(, ${floor} \u044d\u0442.)")));
        return this.getAddress(addressFormat, house, attrAddress);
    }

    private <D extends IdTitle> String getDirectoryItem(int id, Directory<D> directory) throws BGException {
        IdTitle d;
        if (id > 0 && (d = (IdTitle)directory.get(id)) != null) {
            if (d instanceof AddressPrefixSuffix) {
                AddressPrefixSuffix address = (AddressPrefixSuffix)d;
                return address.toTitle();
            }
            return d.getTitle();
        }
        return null;
    }

    private String getAddress(String pattern, House house, EntityAttrAddress attrAddress) throws BGException {
        String quarter;
        if (house == null || attrAddress == null) {
            return "";
        }
        String area = this.getDirectoryItem(house.getArea().getId(), this.areaDirectory);
        if ("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e".equals(area) || "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d".equals(area)) {
            area = null;
        }
        if ("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e".equals(quarter = this.getDirectoryItem(house.getQuarter().getId(), this.quarterDirectory)) || "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d".equals(quarter)) {
            quarter = null;
        }
        AddressStruct addressStruct = AddressStruct.builder().setIndex(house.getPostIndex()).setCountry(this.getDirectoryItem(house.getCountry().getId(), this.countryDirectory)).setCity(this.getDirectoryItem(house.getCity().getId(), this.cityDirectory)).setArea(area).setQuarter(quarter).setStreet(this.getDirectoryItem(house.getStreet().getId(), this.streetDirectory)).setHouse(house.getHouse() > 0 ? String.valueOf(house.getHouse()) : null).setFrac(house.getFrac()).setPod(attrAddress.getPod() > 0 ? String.valueOf(attrAddress.getPod()) : null).setFloor(attrAddress.getFloor() > 0 ? String.valueOf(attrAddress.getFloor()) : null).setFlat(attrAddress.getFlat()).setRoom(attrAddress.getRoom()).setComment(attrAddress.getComment()).build();
        ParameterIds parameterIds = ParameterIds.builder(house).build();
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            addressStruct.setParamMap(new ParameterDao(con).getAddressParams(parameterIds));
        }
        catch (Exception ex) {
            LogManager.getLogger().error((Object)ex);
        }
        return ru.bitel.oss.kernel.entity.server.utils.AddressUtils.getAddress(pattern, addressStruct);
    }
}

