/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.util.ipcalc.client;

import bitel.billing.module.common.BGFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class IPCalculator
extends BGFrame {
    private static IPCalculator calculator = null;
    public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    Clipboard clipboard = null;
    ValueTextField ip_value = new ValueTextField();
    ValueTextField hex_value = new ValueTextField();
    ValueTextField dec_value = new ValueTextField();
    ButtonGroup buttonGroup = new ButtonGroup();
    SwitchRadionButton jRadioButton1 = new SwitchRadionButton("", true, "1", this.buttonGroup);
    SwitchRadionButton jRadioButton2 = new SwitchRadionButton("", false, "2", this.buttonGroup);
    SwitchRadionButton jRadioButton3 = new SwitchRadionButton("", false, "3", this.buttonGroup);
    JButton jButton1 = new JButton("\u0412\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c");
    JButton jButton2 = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
    JButton jButton3 = new JButton("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c");
    JButton jButton4 = new JButton("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
    JButton jButton5 = new JButton("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c");
    JButton jButton6 = new JButton("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
    JButton jButton7 = new JButton("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c");
    JButton jButton8 = new JButton("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
    JPanel jPanel4 = new JPanel(new GridBagLayout());

    private IPCalculator() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() throws Exception {
        this.ip_value.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                IPCalculator.this.ip_value_focusGained(e);
            }
        });
        this.hex_value.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                IPCalculator.this.hex_value_focusGained(e);
            }
        });
        this.dec_value.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                IPCalculator.this.dec_value_focusGained(e);
            }
        });
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPCalculator.this.jButton1_actionPerformed(e);
            }
        });
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPCalculator.this.setVisible(false);
                IPCalculator.this.dispose();
            }
        });
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPCalculator.this.jRadioButton1.setSelected(true);
                IPCalculator.this.insertValue(IPCalculator.this.ip_value);
            }
        });
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPCalculator.this.copyValue(IPCalculator.this.ip_value);
            }
        });
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPCalculator.this.jRadioButton2.setSelected(true);
                IPCalculator.this.insertValue(IPCalculator.this.hex_value);
            }
        });
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPCalculator.this.copyValue(IPCalculator.this.hex_value);
            }
        });
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPCalculator.this.jRadioButton3.setSelected(true);
                IPCalculator.this.insertValue(IPCalculator.this.dec_value);
            }
        });
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPCalculator.this.copyValue(IPCalculator.this.dec_value);
            }
        });
        this.jPanel4.add((Component)this.jButton1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add(Box.createGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setTitle("IP \u043a\u0430\u043b\u044c\u043a\u0443\u043b\u044f\u0442\u043e\u0440");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getPanel(" IP \u0430\u0434\u0440\u0435\u0441 ", this.ip_value, this.jButton3, this.jButton4, this.jRadioButton1), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getPanel(" HEX \u0430\u0434\u0440\u0435\u0441 ", this.hex_value, this.jButton5, this.jButton6, this.jRadioButton2), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getPanel(" DEC \u0430\u0434\u0440\u0435\u0441 ", this.dec_value, this.jButton7, this.jButton8, this.jRadioButton3), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    private JPanel getPanel(String title, ValueTextField value, JButton pasteButton, JButton copyButton, SwitchRadionButton switchButton) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new PanelTitledBorder(title));
        jPanel.add((Component)value, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)pasteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        jPanel.add((Component)copyButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        jPanel.add((Component)switchButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    void jButton1_actionPerformed(ActionEvent e) {
        String actionCommand = this.buttonGroup.getSelection().getActionCommand();
        if ("1".equals(actionCommand)) {
            long val = 0L;
            try {
                StringTokenizer st = new StringTokenizer(this.ip_value.getText(), ".");
                if (st.hasMoreTokens()) {
                    val |= Long.parseLong(st.nextToken()) << 24;
                }
                if (st.hasMoreTokens()) {
                    val |= Long.parseLong(st.nextToken()) << 16;
                }
                if (st.hasMoreTokens()) {
                    val |= Long.parseLong(st.nextToken()) << 8;
                }
                if (st.hasMoreTokens()) {
                    val |= Long.parseLong(st.nextToken());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ip_value.setText(this.getIpValue(val &= 0xFFFFFFFFL));
            this.hex_value.setText(this.getHexValue(val));
            this.dec_value.setText(String.valueOf(val));
        } else if ("2".equals(actionCommand)) {
            long val = 0L;
            try {
                val = Long.parseLong(this.hex_value.getText(), 16);
                val &= 0xFFFFFFFFL;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ip_value.setText(this.getIpValue(val));
            this.hex_value.setText(this.getHexValue(val));
            this.dec_value.setText(String.valueOf(val));
        } else if ("3".equals(actionCommand)) {
            long val = 0L;
            try {
                val = Long.parseLong(this.dec_value.getText());
                val &= 0xFFFFFFFFL;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ip_value.setText(this.getIpValue(val));
            this.hex_value.setText(this.getHexValue(val));
            this.dec_value.setText(String.valueOf(val));
        }
    }

    void ip_value_focusGained(FocusEvent e) {
        this.jRadioButton1.setSelected(true);
    }

    void hex_value_focusGained(FocusEvent e) {
        this.jRadioButton2.setSelected(true);
    }

    void dec_value_focusGained(FocusEvent e) {
        this.jRadioButton3.setSelected(true);
    }

    private String getHexValue(long value) {
        StringBuffer buf = new StringBuffer();
        buf.append(HEX[(int)((value & 0xFFFFFFFFF0000000L) >> 28)]);
        buf.append(HEX[(int)(value & 0xF000000L) >> 24]);
        buf.append(HEX[(int)(value & 0xF00000L) >> 20]);
        buf.append(HEX[(int)(value & 0xF0000L) >> 16]);
        buf.append(HEX[(int)(value & 0xF000L) >> 12]);
        buf.append(HEX[(int)(value & 0xF00L) >> 8]);
        buf.append(HEX[(int)(value & 0xF0L) >> 4]);
        buf.append(HEX[(int)(value & 0xFL)]);
        return buf.toString();
    }

    private String getIpValue(long value) {
        StringBuffer buf = new StringBuffer();
        buf.append((value & 0xFFFFFFFFFF000000L) >> 24);
        buf.append('.');
        buf.append((value & 0xFF0000L) >> 16);
        buf.append('.');
        buf.append((value & 0xFF00L) >> 8);
        buf.append('.');
        buf.append(value & 0xFFL);
        return buf.toString();
    }

    private void insertValue(JTextField textField) {
        Transferable clipData = this.clipboard.getContents((Object)this);
        try {
            DataFlavor df = DataFlavor.stringFlavor;
            textField.setText((String)clipData.getTransferData(df));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void copyValue(JTextField textField) {
        String text = textField.getText();
        if (text != null) {
            StringSelection clipString = new StringSelection(text);
            this.clipboard.setContents(clipString, clipString);
        }
    }

    public static IPCalculator newInstance() {
        if (calculator == null) {
            calculator = new IPCalculator();
        }
        return calculator;
    }

    class ValueTextField
    extends JTextField {
        public ValueTextField() {
            this.setText("");
            this.setColumns(20);
            this.setMinimumSize(new Dimension(220, 20));
            this.setHorizontalAlignment(0);
        }
    }

    class SwitchRadionButton
    extends JRadioButton {
        public SwitchRadionButton(String text, boolean selected, String actionCommand, ButtonGroup buttonGroup) {
            this.setActionCommand(actionCommand);
            this.setSelected(selected);
            this.setText(text);
            buttonGroup.add(this);
        }
    }

    class PanelTitledBorder
    extends TitledBorder {
        public PanelTitledBorder(String title) {
            super(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), title);
        }
    }
}

